/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.AsyncFutureImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PipeWriter {
    private final Map<Integer, FutureHolder> pendingIO = Collections.synchronizedMap(new HashMap());
    private final ExecutorService base;
    private static final Future<?> SIGNALED = new AsyncFutureImpl<Object>(new Object());

    public PipeWriter(ExecutorService base) {
        this.base = base;
    }

    public void shutdown() {
        this.base.shutdown();
    }

    public Future<?> submit(final int id, final Runnable command) {
        if (id == 0) {
            return this.base.submit(command);
        }
        FutureHolder fh = new FutureHolder();
        FutureHolder old = this.pendingIO.put(id, fh);
        assert (old == null);
        return fh.set(this.base.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    command.run();
                }
                finally {
                    FutureHolder old = (FutureHolder)PipeWriter.this.pendingIO.remove(id);
                    assert (old != null);
                }
            }
        }));
    }

    public Future<?> get(int id) throws InterruptedException {
        FutureHolder f = this.pendingIO.get(id);
        if (f == null) {
            return SIGNALED;
        }
        return f.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FutureHolder {
        private Future<?> f;

        private FutureHolder() {
        }

        public synchronized Future<?> set(Future<?> f) {
            this.f = f;
            this.notifyAll();
            return f;
        }

        public synchronized Future<?> get() throws InterruptedException {
            while (this.f == null) {
                this.wait();
            }
            return this.f;
        }
    }
}

