/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.forward;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.remoting.forward.CopyThread;
import hudson.remoting.forward.Forwarder;
import hudson.remoting.forward.ListeningPort;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortForwarder
extends Thread
implements Closeable,
ListeningPort {
    private final Forwarder forwarder;
    private final ServerSocket socket;
    private static final Logger LOGGER = Logger.getLogger(PortForwarder.class.getName());

    public PortForwarder(int localPort, Forwarder forwarder) throws IOException {
        super(String.format("Port forwarder %d", localPort));
        this.forwarder = forwarder;
        this.socket = new ServerSocket(localPort);
        this.setDaemon(true);
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public void run() {
        try {
            try {
                while (true) {
                    final Socket s = this.socket.accept();
                    new Thread("Port forwarding session from " + s.getRemoteSocketAddress()){

                        public void run() {
                            try {
                                OutputStream out = PortForwarder.this.forwarder.connect(new RemoteOutputStream(new SocketOutputStream(s)));
                                new CopyThread("Copier for " + s.getRemoteSocketAddress(), new SocketInputStream(s), out).start();
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.FINE, "Port forwarding session was shut down abnormally", e);
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable throwable) {
                this.socket.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Port forwarding was shut down abnormally", e);
            return;
        }
    }

    public void close() throws IOException {
        this.interrupt();
        this.socket.close();
    }

    public static ListeningPort create(VirtualChannel ch, final int acceptingPort, Forwarder forwarder) throws IOException, InterruptedException {
        final Forwarder proxy = ch.export(Forwarder.class, forwarder);
        return ch.call(new Callable<ListeningPort, IOException>(){

            @Override
            public ListeningPort call() throws IOException {
                PortForwarder t = new PortForwarder(acceptingPort, proxy);
                t.start();
                return Channel.current().export(ListeningPort.class, t);
            }
        });
    }
}

