/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.IReadResolve;
import hudson.remoting.Request;
import hudson.remoting.UnexportCommand;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteInvocationHandler
implements InvocationHandler,
Serializable {
    private final int oid;
    private transient Channel channel;
    private final boolean userProxy;
    private final boolean autoUnexportByCaller;
    private boolean goingHome;
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    RemoteInvocationHandler(Channel channel, int id, boolean userProxy, boolean autoUnexportByCaller) {
        this.channel = channel;
        this.oid = id;
        this.userProxy = userProxy;
        this.autoUnexportByCaller = autoUnexportByCaller;
    }

    public static <T> T wrap(Channel channel, int id, Class<T> type, boolean userProxy, boolean autoUnexportByCaller) {
        ClassLoader cl = type.getClassLoader();
        if (cl == null || cl == ClassLoader.getSystemClassLoader()) {
            cl = IReadResolve.class.getClassLoader();
        }
        return type.cast(Proxy.newProxyInstance(cl, new Class[]{type, IReadResolve.class}, (InvocationHandler)new RemoteInvocationHandler(channel, id, userProxy, autoUnexportByCaller)));
    }

    public static int unwrap(Object proxy, Channel src) {
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        if (h instanceof RemoteInvocationHandler) {
            RemoteInvocationHandler rih = (RemoteInvocationHandler)h;
            if (rih.channel == src) {
                return rih.oid;
            }
        }
        return -1;
    }

    public static Channel unwrap(Object proxy) {
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        if (h instanceof RemoteInvocationHandler) {
            RemoteInvocationHandler rih = (RemoteInvocationHandler)h;
            return rih.channel;
        }
        return null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> dc;
        if (method.getDeclaringClass() == IReadResolve.class) {
            if (this.goingHome) {
                return this.channel.getExportedObject(this.oid);
            }
            return proxy;
        }
        if (this.channel == null) {
            throw new IllegalStateException("proxy is not connected to a channel");
        }
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        if ((dc = method.getDeclaringClass()) == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        if (this.userProxy) {
            return this.channel.call(new RPCRequest(this.oid, method, args, dc.getClassLoader()));
        }
        return new RPCRequest(this.oid, method, args).call(this.channel);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.channel = Channel.current();
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.goingHome = this.channel != null;
        oos.defaultWriteObject();
    }

    public boolean equals(Object o) {
        if (Proxy.isProxyClass(o.getClass())) {
            o = Proxy.getInvocationHandler(o);
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteInvocationHandler that = (RemoteInvocationHandler)o;
        return this.oid == that.oid && this.channel == that.channel;
    }

    public int hashCode() {
        return this.oid;
    }

    protected void finalize() throws Throwable {
        if (this.channel != null && !this.autoUnexportByCaller) {
            this.channel.send(new UnexportCommand(this.oid));
        }
        super.finalize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RPCRequest
    extends Request<Serializable, Throwable>
    implements DelegatingCallable<Serializable, Throwable> {
        private final int oid;
        private final String methodName;
        private final String[] types;
        private final Object[] arguments;
        private transient ClassLoader classLoader;
        private static final long serialVersionUID = 1L;

        public RPCRequest(int oid, Method m, Object[] arguments) {
            this(oid, m, arguments, null);
        }

        public RPCRequest(int oid, Method m, Object[] arguments, ClassLoader cl) {
            this.oid = oid;
            this.arguments = arguments;
            this.methodName = m.getName();
            this.classLoader = cl;
            this.types = new String[arguments.length];
            Class<?>[] params = m.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                this.types[i] = params[i].getName();
            }
            assert (this.types.length == arguments.length);
        }

        @Override
        public Serializable call() throws Throwable {
            return this.perform(Channel.current());
        }

        @Override
        public ClassLoader getClassLoader() {
            if (this.classLoader != null) {
                return this.classLoader;
            }
            return this.getClass().getClassLoader();
        }

        @Override
        protected Serializable perform(Channel channel) throws Throwable {
            Object o = channel.getExportedObject(this.oid);
            if (o == null) {
                throw new IllegalStateException("Unable to call " + this.methodName + ". Invalid object ID " + this.oid);
            }
            try {
                Method m = this.choose(o);
                if (m == null) {
                    throw new IllegalStateException("Unable to call " + this.methodName + ". No matching method found on " + o.getClass());
                }
                m.setAccessible(true);
                return (Serializable)m.invoke(o, this.arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Method choose(Object o) {
            block0: for (Method m : o.getClass().getMethods()) {
                Class<?>[] paramTypes;
                if (!m.getName().equals(this.methodName) || (paramTypes = m.getParameterTypes()).length != this.arguments.length) continue;
                for (int i = 0; i < this.types.length; ++i) {
                    if (!this.types[i].equals(paramTypes[i].getName())) continue block0;
                }
                return m;
            }
            return null;
        }

        Object[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            return "RPCRequest(" + this.oid + "," + this.methodName + ")";
        }
    }
}

