/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Future;
import hudson.remoting.RequestAbortedException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jenkinsci.remoting.RoleChecker;

public abstract class PingThread
extends Thread {
    private final Channel channel;
    private final long timeout;
    private final long interval;
    private static final Logger LOGGER = Logger.getLogger(PingThread.class.getName());

    public PingThread(Channel channel, long timeout, long interval) {
        super("Ping thread for channel " + channel);
        this.channel = channel;
        this.timeout = timeout;
        this.interval = interval;
        this.setDaemon(true);
    }

    public PingThread(Channel channel, long interval) {
        this(channel, 240000L, interval);
    }

    public PingThread(Channel channel) {
        this(channel, 600000L);
    }

    @Override
    public void run() {
        try {
            block4: while (true) {
                long nextCheck = System.currentTimeMillis() + this.interval;
                this.ping();
                while (true) {
                    long diff;
                    if ((diff = nextCheck - System.currentTimeMillis()) <= 0L) continue block4;
                    Thread.sleep(diff);
                }
                break;
            }
        }
        catch (ChannelClosedException e) {
            LOGGER.fine(this.getName() + " is closed. Terminating");
        }
        catch (IOException e) {
            this.onDead(e);
        }
        catch (InterruptedException e) {
            LOGGER.fine(this.getName() + " is interrupted. Terminating");
        }
    }

    private void ping() throws IOException, InterruptedException {
        Future<Void> f = this.channel.callAsync(new Ping());
        long start = System.currentTimeMillis();
        long end = start + this.timeout;
        while (true) {
            long remaining = end - System.currentTimeMillis();
            try {
                f.get(Math.max(0L, remaining), TimeUnit.MILLISECONDS);
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RequestAbortedException) {
                    return;
                }
                this.onDead(e);
                return;
            }
            catch (TimeoutException e) {
                if (remaining > 0L) continue;
                this.onDead(new TimeoutException("Ping started on " + start + " hasn't completed at " + System.currentTimeMillis()));
                return;
            }
            break;
        }
    }

    protected abstract void onDead();

    protected void onDead(Throwable diagnosis) {
        this.onDead();
    }

    private static final class Ping
    implements Callable<Void, IOException> {
        private static final long serialVersionUID = 1L;

        private Ping() {
        }

        @Override
        public Void call() throws IOException {
            return null;
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

