/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpProtocol;

class JnlpProtocol2
extends JnlpProtocol {
    private String cookie;
    static final String NAME = "JNLP2-connect";
    static final String SECRET_KEY = "Secret-Key";
    static final String SLAVE_NAME_KEY = "Node-Name";
    static final String COOKIE_KEY = "Cookie";

    JnlpProtocol2(String secretKey, String slaveName) {
        super(secretKey, slaveName);
    }

    @Override
    public String getName() {
        return NAME;
    }

    String getCookie() {
        return this.cookie;
    }

    @Override
    public String performHandshake(DataOutputStream outputStream, BufferedInputStream inputStream) throws IOException {
        this.initiateHandshake(outputStream);
        String response = EngineUtil.readLine(inputStream);
        if (response.equals("Welcome")) {
            Properties responses = EngineUtil.readResponseHeaders(inputStream);
            this.cookie = responses.getProperty(COOKIE_KEY);
        }
        return response;
    }

    private void initiateHandshake(DataOutputStream outputStream) throws IOException {
        Properties props = new Properties();
        props.put(SECRET_KEY, this.secretKey);
        props.put(SLAVE_NAME_KEY, this.slaveName);
        if (this.cookie != null) {
            props.put(COOKIE_KEY, this.cookie);
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        props.store(o, null);
        outputStream.writeUTF("Protocol:JNLP2-connect");
        outputStream.writeUTF(o.toString("UTF-8"));
    }
}

