/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ChunkHeader;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import hudson.remoting.ObjectInputStreamEx;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.ByteBufferQueueOutputStream;
import org.jenkinsci.remoting.util.FastByteBufferQueueInputStream;
import org.jenkinsci.remoting.util.IOUtils;

public abstract class AbstractByteBufferCommandTransport
extends CommandTransport {
    private static final Logger LOGGER = Logger.getLogger(AbstractByteBufferCommandTransport.class.getName());
    private static final int READ_STATE_NEED_HEADER = 0;
    private static final int READ_STATE_MORE_HEADER = 1;
    private static final int READ_STATE_FRAME_BODY = 2;
    private static final int READ_STATE_COMMAND_READY = 3;
    private Channel channel;
    private final ByteBuffer writeChunkHeader = ByteBuffer.allocate(2);
    private int transportFrameSize = 8192;
    private ByteBuffer writeChunkBody = ByteBuffer.allocate(this.transportFrameSize);
    private CommandTransport.CommandReceiver receiver;
    private final ByteBufferQueue receiveQueue = new ByteBufferQueue(this.transportFrameSize);
    private int readState;
    private int readFrameRemaining;
    private int readFrameHeader;
    private int readCommandIndex = 0;
    private int[] readCommandSizes = new int[16];
    private ByteBufferQueue sendStaging = new ByteBufferQueue(this.transportFrameSize);

    protected abstract void write(ByteBuffer var1, ByteBuffer var2) throws IOException;

    public final void receive(@Nonnull ByteBuffer data) throws IOException, InterruptedException {
        while (this.receiver != null && this.readCommandIndex > 0) {
            this.processCommand();
        }
        block7: while (data.hasRemaining() || this.readState == 3) {
            switch (this.readState) {
                case 0: {
                    if (data.remaining() >= 2) {
                        this.readFrameHeader = ChunkHeader.read(data);
                        this.readFrameRemaining = ChunkHeader.length(this.readFrameHeader);
                        this.readState = 2;
                        continue block7;
                    }
                    this.readFrameHeader = data.get();
                    this.readState = 1;
                    continue block7;
                }
                case 1: {
                    this.readFrameHeader = ChunkHeader.parse(this.readFrameHeader, (int)data.get());
                    this.readFrameRemaining = ChunkHeader.length(this.readFrameHeader);
                    this.readState = 2;
                    continue block7;
                }
                case 2: {
                    if (data.remaining() < this.readFrameRemaining) {
                        int n = this.readCommandIndex;
                        this.readCommandSizes[n] = this.readCommandSizes[n] + data.remaining();
                        this.readFrameRemaining -= data.remaining();
                        this.receiveQueue.put(data);
                        continue block7;
                    }
                    int n = this.readCommandIndex;
                    this.readCommandSizes[n] = this.readCommandSizes[n] + this.readFrameRemaining;
                    int oldLimit = data.limit();
                    data.limit(data.position() + this.readFrameRemaining);
                    this.receiveQueue.put(data);
                    data.limit(oldLimit);
                    this.readFrameRemaining = 0;
                    if (ChunkHeader.isLast(this.readFrameHeader)) {
                        this.readState = 3;
                        continue block7;
                    }
                    this.readState = 0;
                    continue block7;
                }
                case 3: {
                    ++this.readCommandIndex;
                    if (this.readCommandIndex > this.readCommandSizes.length) {
                        this.readCommandSizes = Arrays.copyOf(this.readCommandSizes, this.readCommandSizes.length * 2);
                    }
                    this.readCommandSizes[this.readCommandIndex] = 0;
                    this.readState = 0;
                    if (this.receiver == null) continue block7;
                    this.processCommand();
                    continue block7;
                }
            }
            throw new IllegalStateException("Unknown readState = " + this.readState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand() throws IOException {
        try {
            FastByteBufferQueueInputStream is = new FastByteBufferQueueInputStream(this.receiveQueue, this.readCommandSizes[0]);
            try {
                ObjectInputStreamEx ois = new ObjectInputStreamEx(is, this.channel.baseClassLoader, this.channel.classFilter);
                Command cmd = Command.readFrom(this.channel, ois);
                this.receiver.handle(cmd);
                this.channel.notifyRead(cmd, this.readCommandSizes[0]);
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to construct Command in channel " + this.channel.getName(), e);
            }
            finally {
                int available = is.available();
                if (available > 0 && is.skip(available) != (long)available) {
                    LOGGER.log(Level.FINE, "Failed to skip remainder of Command");
                }
                IOUtils.closeQuietly(is);
            }
        }
        finally {
            if (this.readCommandIndex == 1) {
                if (this.readCommandSizes.length > 16) {
                    int temp = this.readCommandSizes[1];
                    this.readCommandSizes = new int[16];
                    this.readCommandSizes[0] = temp;
                } else {
                    this.readCommandSizes[0] = this.readCommandSizes[1];
                }
                this.readCommandIndex = 0;
            } else {
                System.arraycopy(this.readCommandSizes, 1, this.readCommandSizes, 0, this.readCommandIndex);
                --this.readCommandIndex;
            }
        }
    }

    public void setFrameSize(int transportFrameSize) {
        if (transportFrameSize <= 0 || transportFrameSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.transportFrameSize = transportFrameSize;
        this.writeChunkBody = ByteBuffer.allocate(transportFrameSize);
    }

    @Nullable
    protected Channel getChannel() {
        return this.channel;
    }

    @Override
    public final synchronized void setup(Channel channel, CommandTransport.CommandReceiver receiver) {
        this.channel = channel;
        this.receiver = receiver;
        try {
            while (receiver != null && this.readCommandIndex > 0) {
                this.processCommand();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not flush receive buffer queue", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(Command cmd, boolean last) throws IOException {
        int frame;
        long remaining;
        ByteBufferQueueOutputStream bqos = new ByteBufferQueueOutputStream(this.sendStaging);
        try (ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream(bqos);){
            cmd.writeTo(this.channel, oos);
        }
        this.channel.notifyWrite(cmd, remaining);
        for (remaining = this.sendStaging.remaining(); remaining > 0L; remaining -= (long)frame) {
            frame = remaining > (long)this.transportFrameSize ? this.transportFrameSize : (int)remaining;
            this.writeChunkHeader.clear();
            ChunkHeader.write(this.writeChunkHeader, frame, remaining > (long)this.transportFrameSize);
            this.writeChunkHeader.flip();
            this.writeChunkBody.clear();
            this.writeChunkBody.limit(frame);
            this.sendStaging.get(this.writeChunkBody);
            this.writeChunkBody.flip();
            this.write(this.writeChunkHeader, this.writeChunkBody);
        }
    }
}

