/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class BypassablePatternMonitor
extends AdministrativeMonitor {
    private static final List<String> LEGACY_DEFAULT_PATTERNS = Arrays.asList(".*/(?:configSubmit|doDelete|postBuildResult|enable|disable|cancelQueue|stop|toggleLogKeep|doWipeOutWorkspace|createItem|createView|toggleOffline|cancelQuietDown|quietDown|restart|exit|safeExit)", ".*/(?:configSubmit|doDelete|postBuildResult|cancelQueue|stop|toggleLogKeep|doWipeOutWorkspace|createItem|createView|toggleOffline)", ".*/(?:configSubmit|doDelete|build|toggleLogKeep|doWipeOutWorkspace|createItem|createView)");
    @Inject
    private AuditTrailPlugin auditTrailPlugin;

    static boolean isLegacyBypassableDefaultPattern(String pattern) {
        return LEGACY_DEFAULT_PATTERNS.contains(pattern);
    }

    static FormValidation validatePatternAgainstKnownKeywords(String pattern) {
        Pattern p = Pattern.compile(pattern);
        return FormValidation.aggregate((Collection)AuditTrailPlugin.getKnownKeywords().stream().map(keyword -> new BypassablePatternDetector((String)keyword, p)).filter(BypassablePatternDetector::isBypassed).map(BypassablePatternDetector::buildWarningMessage).collect(Collectors.toList()));
    }

    public String getMessage() {
        return BypassablePatternMonitor.validatePatternAgainstKnownKeywords(this.auditTrailPlugin.getPattern()).renderHtml();
    }

    public HttpResponse doRedirectToConfig() {
        return HttpResponses.redirectViaContextPath((String)"configure");
    }

    @RequirePOST
    public HttpResponse doApplyDefault() {
        this.auditTrailPlugin.resetPattern();
        return HttpResponses.redirectToContextRoot();
    }

    public boolean isActivated() {
        return BypassablePatternMonitor.validatePatternAgainstKnownKeywords((String)this.auditTrailPlugin.getPattern()).kind != FormValidation.Kind.OK;
    }

    public boolean isSecurity() {
        return true;
    }

    private static class BypassablePatternDetector {
        private final String keyword;
        private final List<String> messages;

        BypassablePatternDetector(String keyword, Pattern p) {
            this.keyword = keyword;
            this.messages = new ArrayList<String>();
            if (p.matcher(this.createLegitUrl()).matches()) {
                if (!p.matcher(this.createPrefixBypassableUrl()).matches()) {
                    this.messages.add("crafted URLs with prefix like " + this.createPrefixBypassableUrl());
                }
                if (!p.matcher(this.createSuffixBypassableUrl()).matches()) {
                    this.messages.add("crafted URLs with suffix like " + this.createSuffixBypassableUrl());
                }
            }
        }

        private String createLegitUrl() {
            return "/" + this.keyword;
        }

        private String createPrefixBypassableUrl() {
            return "/static/forged/" + this.keyword;
        }

        private String createSuffixBypassableUrl() {
            return "/" + this.keyword + "/forged";
        }

        boolean isBypassed() {
            return !this.messages.isEmpty();
        }

        FormValidation buildWarningMessage() {
            return FormValidation.warning((String)("Pattern seems to attempt to match " + this.createLegitUrl() + " but doesn't handle " + this.buildCraftedUrlMessage()));
        }

        private String buildCraftedUrlMessage() {
            return String.join((CharSequence)" and ", this.messages);
        }
    }
}

