/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AbstractLogFileAuditLogger;
import hudson.plugins.audit_trail.AuditLogger;
import java.io.IOException;
import java.util.logging.FileHandler;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogFileAuditLogger
extends AbstractLogFileAuditLogger {
    private int limit = 1;

    @DataBoundConstructor
    public LogFileAuditLogger(String log, int limit, int count, String logSeparator) {
        super(log, count, logSeparator);
        this.limit = limit;
        this.configure();
    }

    @Override
    Object readResolve() {
        super.readResolve();
        this.configure();
        return this;
    }

    @Override
    FileHandler getLogFileHandler() throws IOException {
        return new FileHandler(this.getLog(), this.getLimit() * 1024 * 1024, this.getCount(), true);
    }

    public int getLimit() {
        return this.limit;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuditLogger> {
        public String getDisplayName() {
            return "Log file";
        }
    }
}

