/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.plugins.audit_trail.BasicNodeNameRetriever;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;

@Extension(optional=true)
public class WorkflowNodeNameRetriever
extends BasicNodeNameRetriever {
    private static final String N_A = "N/A";

    @Override
    public String buildNodeName(Run<?, ?> run) {
        if (run instanceof WorkflowRun) {
            WorkflowRun workflowRun = (WorkflowRun)run;
            return this.printNodes(workflowRun);
        }
        return super.buildNodeName(run);
    }

    public String printNodes(WorkflowRun run) {
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return N_A;
        }
        String nodes = StreamSupport.stream(new FlowGraphWalker(exec).spliterator(), false).filter(n -> n instanceof StepStartNode).flatMap(n -> WorkflowNodeNameRetriever.extractNodeNames((StepStartNode)n)).filter(Objects::nonNull).distinct().collect(Collectors.joining(";"));
        if (nodes.isEmpty()) {
            return "no agent";
        }
        return nodes;
    }

    private static Stream<String> extractNodeNames(StepStartNode node) {
        StepDescriptor stepDescriptor = node.getDescriptor();
        if (stepDescriptor instanceof ExecutorStep.DescriptorImpl) {
            return node.getActions(WorkspaceActionImpl.class).stream().map(WorkspaceActionImpl::getNode).map(WorkflowNodeNameRetriever::normalizeNodeName);
        }
        return Stream.empty();
    }

    private static String normalizeNodeName(String nodeName) {
        if (Strings.isNullOrEmpty((String)nodeName)) {
            Computer computer = Jenkins.get().toComputer();
            if (computer == null) {
                return N_A;
            }
            return computer.getDisplayName();
        }
        return nodeName;
    }
}

