/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.buildnameupdater;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.buildnamesetter.Executor;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BuildNameUpdater
extends Builder {
    private final String buildName;
    private final String macroTemplate;
    private final boolean fromFile;
    private final boolean fromMacro;
    private final boolean macroFirst;
    private static final Logger LOGGER = Logger.getLogger(BuildNameUpdater.class.getName());

    @DataBoundConstructor
    public BuildNameUpdater(boolean fromFile, String buildName, boolean fromMacro, String macroTemplate, boolean macroFirst) {
        this.buildName = buildName;
        this.macroTemplate = macroTemplate;
        this.fromFile = fromFile;
        this.fromMacro = fromMacro;
        this.macroFirst = macroFirst;
    }

    public boolean getFromFile() {
        return this.fromFile;
    }

    public boolean getMacroFirst() {
        return this.macroFirst;
    }

    public boolean getFromMacro() {
        return this.fromMacro;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public String getMacroTemplate() {
        return this.macroTemplate;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        Object buildNameToSet = "";
        if (this.fromFile) {
            buildNameToSet = this.readFromFile(build, listener, this.buildName);
        }
        if (this.fromMacro) {
            String evaluatedMacro = this.getFromMacro(build, listener, this.macroTemplate);
            listener.getLogger().println("Evaluated macro: '" + evaluatedMacro + "'");
            Object object = buildNameToSet = this.macroFirst ? evaluatedMacro + (String)buildNameToSet : (String)buildNameToSet + evaluatedMacro;
        }
        if (StringUtils.isNotBlank((CharSequence)buildNameToSet)) {
            Executor executor = new Executor((Run)build, (TaskListener)listener);
            executor.setName((String)buildNameToSet);
        }
        return true;
    }

    private String getFromMacro(AbstractBuild build, BuildListener listener, String macro) {
        String result = null;
        try {
            result = TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)macro);
        }
        catch (MacroEvaluationException e) {
            listener.getLogger().println("Failed to evaluate macro '" + macro + "'");
            LOGGER.log(Level.WARNING, "Failed to evaluate macro '" + macro + "': ", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception was thrown during macro evaluation: ", e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Macro evaluation was interrupted: ", e);
            listener.getLogger().println("Macro evaluating failed with:");
        }
        LOGGER.log(Level.INFO, "Macro evaluated: '" + result + "'");
        return result;
    }

    private String readFromFile(AbstractBuild build, BuildListener listener, String filePath) {
        String version = "";
        if (StringUtils.isBlank((CharSequence)filePath)) {
            listener.getLogger().println("File path is empty.");
            return "";
        }
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            listener.getLogger().println("Workspace is empty.");
            return "";
        }
        FilePath fp = new FilePath(workspace, filePath);
        listener.getLogger().println("Getting version from file: " + fp);
        try {
            version = (String)fp.act((FilePath.FileCallable)new FileCallable());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read file: ", e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Getting name from file was interrupted: ", e);
        }
        listener.getLogger().println("Loaded version is " + version);
        return StringUtils.defaultString((String)version);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static class FileCallable
    extends MasterToSlaveFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private FileCallable() {
        }

        public String invoke(File file, VirtualChannel channel) throws IOException {
            if (file.getAbsoluteFile().exists()) {
                LOGGER.log(Level.INFO, "File is found, reading...");
                try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsoluteFile(), StandardCharsets.UTF_8));){
                    String string = br.readLine();
                    return string;
                }
            }
            LOGGER.log(Level.WARNING, "File was not found.");
            return "";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Please set a file path");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Update build name";
        }
    }
}

