/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import jenkins.scm.api.SCMFile;
import jenkins.scm.impl.avatars.AvatarImage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface BitbucketApi
extends AutoCloseable {
    @NonNull
    public String getOwner();

    @CheckForNull
    public String getRepositoryName();

    @NonNull
    public List<? extends BitbucketPullRequest> getPullRequests() throws IOException, InterruptedException;

    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer var1) throws IOException;

    @NonNull
    public BitbucketRepository getRepository() throws IOException;

    public void postCommitComment(@NonNull String var1, @NonNull String var2) throws IOException;

    public boolean checkPathExists(@NonNull String var1, @NonNull String var2) throws IOException;

    @CheckForNull
    public String getDefaultBranch() throws IOException;

    @CheckForNull
    public BitbucketBranch getBranch(@NonNull String var1) throws IOException;

    @NonNull
    public List<? extends BitbucketBranch> getBranches() throws IOException, InterruptedException;

    @CheckForNull
    public BitbucketBranch getTag(@NonNull String var1) throws IOException;

    @NonNull
    public List<? extends BitbucketBranch> getTags() throws IOException, InterruptedException;

    @CheckForNull
    public BitbucketCommit resolveCommit(@NonNull String var1) throws IOException;

    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest var1) throws IOException;

    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest var1) throws IOException;

    @Deprecated(since="937.0.0", forRemoval=true)
    default public void registerCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException {
    }

    @Deprecated(since="937.0.0", forRemoval=true)
    default public void updateCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException {
    }

    @Deprecated(since="937.0.0", forRemoval=true)
    default public void removeCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException {
    }

    @Deprecated(since="937.0.0", forRemoval=true)
    @NonNull
    default public List<? extends BitbucketWebHook> getWebHooks() throws IOException {
        return Collections.emptyList();
    }

    @CheckForNull
    public BitbucketTeam getTeam() throws IOException;

    @Deprecated(since="935.0.0", forRemoval=true)
    @CheckForNull
    public AvatarImage getTeamAvatar() throws IOException;

    @CheckForNull
    public AvatarImage getAvatar(@NonNull String var1) throws IOException;

    @NonNull
    public List<? extends BitbucketRepository> getRepositories(@CheckForNull UserRoleInRepository var1) throws IOException, InterruptedException;

    @NonNull
    public List<? extends BitbucketRepository> getRepositories() throws IOException, InterruptedException;

    @Deprecated(since="937.0.0", forRemoval=true)
    public void postBuildStatus(@NonNull BitbucketBuildStatus var1) throws IOException;

    public boolean isPrivate() throws IOException;

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile var1) throws IOException, InterruptedException;

    @Restricted(value={NoExternalUse.class})
    public InputStream getFileContent(BitbucketSCMFile var1) throws IOException;

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public SCMFile getFile(@NonNull BitbucketSCMFile var1) throws IOException;

    @Override
    public void close() throws IOException;

    @NonNull
    public List<? extends BitbucketCommit> getCommits(@CheckForNull String var1, @NonNull String var2) throws IOException;

    @Nullable
    default public <T> T adapt(@NonNull Class<T> clazz) {
        return null;
    }
}

