/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketProject;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryOwner;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public interface BitbucketRepository {
    @Deprecated
    public String getScm();

    public String getFullName();

    public BitbucketProject getProject();

    public BitbucketRepositoryOwner getOwner();

    public String getOwnerName();

    public String getRepositoryName();

    public boolean isPrivate();

    public boolean isArchived();

    default public String getLink(String name) {
        Map<String, List<BitbucketHref>> links = this.getLinks();
        if (links == null) {
            return null;
        }
        List<BitbucketHref> hrefs = links.get(name);
        if (hrefs == null || hrefs.isEmpty()) {
            return null;
        }
        BitbucketHref href = hrefs.get(0);
        return href == null ? null : href.getHref();
    }

    public Map<String, List<BitbucketHref>> getLinks();

    public String getAvatar();

    @NonNull
    default public List<BitbucketHref> getCloneLinks() {
        Map<String, List<BitbucketHref>> links = this.getLinks();
        if (links == null) {
            return Collections.emptyList();
        }
        List<BitbucketHref> hrefs = links.get("clone");
        if (CollectionUtils.isEmpty(hrefs)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(hrefs);
    }
}

