/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.jenkins.plugins.bitbucket.client.Cache;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketAuthenticatorUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketOAuth;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.oauth.OAuth20Service;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import jenkins.util.SetContextClassLoader;
import jenkins.util.SystemProperties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpRequest;

public class BitbucketOAuthAuthenticator
implements BitbucketAuthenticator {
    private static final String OAUTH2_CACHE_TIMEOUT_PROPERTY_NAME = "bitbucket.oauth2.cache.timeout";
    private static final Cache<String, OAuth2AccessToken> cacheToken = new Cache(SystemProperties.getInteger((String)"bitbucket.oauth2.cache.timeout", (Integer)300), TimeUnit.SECONDS);
    private final String credentialsId;
    private final String username;
    private final Secret password;

    public BitbucketOAuthAuthenticator(StandardUsernamePasswordCredentials credentials) {
        this.credentialsId = credentials.getId();
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
    }

    private OAuth2AccessToken getToken() {
        try {
            String plainSecret = Secret.toString((Secret)this.password);
            String cacheKey = DigestUtils.md2Hex((String)StringUtils.join((Object[])new String[]{this.credentialsId, this.username, plainSecret}, (char)'/'));
            return cacheToken.get(cacheKey, () -> {
                try (SetContextClassLoader cl = new SetContextClassLoader(this.getClass());){
                    OAuth2AccessToken oAuth2AccessToken;
                    block11: {
                        OAuth20Service service = new ServiceBuilder(this.username).apiSecret(plainSecret).httpClientConfig((HttpClientConfig)JDKHttpClientConfig.defaultConfig()).build((DefaultApi20)BitbucketOAuth.instance());
                        try {
                            oAuth2AccessToken = service.getAccessTokenClientCredentialsGrant();
                            if (service == null) break block11;
                        }
                        catch (Throwable throwable) {
                            if (service != null) {
                                try {
                                    service.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        service.close();
                    }
                    return oAuth2AccessToken;
                }
            });
        }
        catch (ExecutionException e) {
            OAuth2AccessTokenErrorResponse oauthEx = BitbucketAuthenticatorUtils.unwrap(e, OAuth2AccessTokenErrorResponse.class);
            if (oauthEx != null) {
                throw new BitbucketException(oauthEx.getErrorDescription() + ". Please check configured OAuth credentials client id and secret are correct.", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void configureRequest(HttpRequest request) {
        request.addHeader("Authorization", (Object)("Bearer " + this.getToken().getAccessToken()));
    }

    @Override
    public StandardUsernameCredentials getCredentialsForSCM() {
        try {
            return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, this.getId(), "OAuth2 token for " + this.getId(), "x-token-auth", this.getToken().getAccessToken());
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

