/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.notifier;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.FirstCheckoutCompletedInvisibleAction;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.jenkins.plugins.bitbucket.api.buildstatus.BitbucketBuildStatusCustomizer;
import com.cloudbees.jenkins.plugins.bitbucket.api.buildstatus.BitbucketBuildStatusNotifier;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.trait.BranchDiscoveryTrait;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public final class BitbucketBuildStatusNotifications {
    private static final Logger logger = Logger.getLogger(BitbucketBuildStatusNotifications.class.getName());

    private static String getRootURL(@NonNull Run<?, ?> build) {
        JenkinsLocationConfiguration cfg = JenkinsLocationConfiguration.get();
        if (cfg.getUrl() == null) {
            throw new IllegalStateException("Could not determine Jenkins URL.");
        }
        return DisplayURLProvider.get().getRunURL(build);
    }

    static String checkURL(@NonNull String url, BitbucketApi client) {
        try {
            URL anURL = new URL(url);
            if ("localhost".equals(anURL.getHost())) {
                throw new IllegalStateException("Jenkins URL cannot start with http://localhost");
            }
            if ("unconfigured-jenkins-location".equals(anURL.getHost())) {
                throw new IllegalStateException("Could not determine Jenkins URL.");
            }
            if (BitbucketApiUtils.isCloud(client) && !anURL.getHost().contains(".")) {
                throw new IllegalStateException("Please use a fully qualified name or an IP address for Jenkins URL, this is required by Bitbucket cloud");
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bad Jenkins URL");
        }
    }

    private static void createStatus(@NonNull Run<?, ?> build, @NonNull TaskListener listener, @NonNull BitbucketApi client, @NonNull String key, @NonNull String hash, @Nullable String refName) throws IOException {
        BitbucketBuildStatus.Status state;
        String statusDescription;
        String url;
        BitbucketSCMSource source = BitbucketBuildStatusNotifications.findBitbucketSCMSource(build);
        if (source == null) {
            return;
        }
        try {
            url = BitbucketBuildStatusNotifications.getRootURL(build);
            BitbucketBuildStatusNotifications.checkURL(url, client);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("Can not determine Jenkins root URL or Jenkins URL is not a valid URL regarding Bitbucket API. Commit status notifications are disabled until a root URL is configured in Jenkins global configuration. \nIllegalStateException: " + e.getMessage());
            return;
        }
        boolean isCloud = BitbucketApiUtils.isCloud(client);
        List<SCMSourceTrait> traits = source.getTraits();
        BitbucketSCMSourceContext context = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(traits);
        Result result = build.getResult();
        String name = build.getFullDisplayName();
        String buildDescription = build.getDescription();
        if (Result.SUCCESS.equals(result)) {
            statusDescription = (String)StringUtils.defaultIfBlank((CharSequence)buildDescription, (CharSequence)"This commit looks good.");
            state = BitbucketBuildStatus.Status.SUCCESSFUL;
        } else if (Result.UNSTABLE.equals(result)) {
            statusDescription = (String)StringUtils.defaultIfBlank((CharSequence)buildDescription, (CharSequence)"This commit may have some failing tests.");
            state = context.sendSuccessNotificationForUnstableBuild() ? BitbucketBuildStatus.Status.SUCCESSFUL : BitbucketBuildStatus.Status.FAILED;
        } else if (Result.FAILURE.equals(result)) {
            statusDescription = (String)StringUtils.defaultIfBlank((CharSequence)buildDescription, (CharSequence)"There was a failure building this commit.");
            state = BitbucketBuildStatus.Status.FAILED;
        } else if (Result.NOT_BUILT.equals(result)) {
            statusDescription = (String)StringUtils.defaultIfBlank((CharSequence)buildDescription, (CharSequence)"This commit was not built (probably the build was skipped)");
            state = context.sendStopNotificationForNotBuildJobs() ? (isCloud ? BitbucketBuildStatus.Status.STOPPED : BitbucketBuildStatus.Status.CANCELLED) : BitbucketBuildStatus.Status.FAILED;
        } else if (result != null) {
            statusDescription = (String)StringUtils.defaultIfBlank((CharSequence)buildDescription, (CharSequence)"Something is wrong with the build of this commit.");
            state = context.sendStopNotificationForAbortBuild() ? (isCloud ? BitbucketBuildStatus.Status.STOPPED : BitbucketBuildStatus.Status.CANCELLED) : BitbucketBuildStatus.Status.FAILED;
        } else {
            statusDescription = (String)StringUtils.defaultIfBlank((CharSequence)buildDescription, (CharSequence)"The build is in progress...");
            state = BitbucketBuildStatus.Status.INPROGRESS;
        }
        if (state != null) {
            String notificationKey = DigestUtils.md5Hex((String)key);
            String notificationParentKey = null;
            if (context.useReadableNotificationIds() && !isCloud) {
                notificationKey = key.replace(' ', '_').toUpperCase();
                notificationParentKey = BitbucketBuildStatusNotifications.getBuildParentKey(build).replace(' ', '_').toUpperCase();
            }
            BitbucketBuildStatus buildStatus = new BitbucketBuildStatus(hash, statusDescription, state, url, notificationKey, name, refName);
            buildStatus.setBuildDuration(build.getDuration());
            buildStatus.setBuildNumber(build.getNumber());
            buildStatus.setParent(notificationParentKey);
            BitbucketBuildStatusNotifications.sendNotification(source, build, buildStatus, client);
            if (result != null) {
                listener.getLogger().println("[Bitbucket] Build result notified");
            }
        } else {
            listener.getLogger().println("[Bitbucket] Skip result notification");
        }
    }

    private static void sendNotification(@NonNull BitbucketSCMSource source, @NonNull Run<?, ?> build, @NonNull BitbucketBuildStatus buildStatus, @NonNull BitbucketApi client) throws IOException {
        EndpointType endpointType = BitbucketEndpointProvider.lookupEndpoint(source.getServerUrl()).map(BitbucketEndpoint::getType).orElseThrow(() -> new BitbucketException("No configured endpoint found for server URL " + source.getServerUrl()));
        BitbucketBuildStatus newBuildStatus = new BitbucketBuildStatus(buildStatus);
        List<BitbucketBuildStatusCustomizer> customizers = ExtensionList.lookup(BitbucketBuildStatusCustomizer.class).stream().filter(n -> n.isApplicable(endpointType)).toList();
        for (BitbucketBuildStatusCustomizer customizer : customizers) {
            customizer.withTraits(source.getTraits());
            customizer.customize(build, newBuildStatus);
            if (buildStatus.equals(newBuildStatus)) continue;
            logger.info("Build status enriched by " + customizer.getClass().getName());
        }
        newBuildStatus.setState(buildStatus.getState());
        newBuildStatus.setKey(buildStatus.getKey());
        newBuildStatus.setRefname(buildStatus.getRefname());
        newBuildStatus.setParent(buildStatus.getParent());
        newBuildStatus.setUrl(buildStatus.getUrl());
        BitbucketBuildStatusNotifier notifier = ExtensionList.lookup(BitbucketBuildStatusNotifier.class).stream().filter(n -> n.isApplicable(endpointType)).findFirst().orElseThrow(() -> new BitbucketException("No notifier found that supports endpoint of type " + endpointType));
        notifier.sendBuildStatus(newBuildStatus, client.adapt(BitbucketAuthenticatedClient.class));
    }

    @CheckForNull
    private static BitbucketSCMSource findBitbucketSCMSource(Run<?, ?> build) {
        BitbucketSCMSource scm;
        SCMSource s = SCMSource.SourceByItem.findSource((Item)build.getParent());
        return s instanceof BitbucketSCMSource ? (scm = (BitbucketSCMSource)s) : null;
    }

    private static void sendNotifications(BitbucketSCMSource source, Run<?, ?> build, TaskListener listener) throws IOException {
        BitbucketApi client;
        Object refName;
        String key;
        BitbucketSCMSourceContext sourceContext = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
        if (sourceContext.notificationsDisabled()) {
            listener.getLogger().println("[Bitbucket] Notification is disabled by configuration");
            return;
        }
        SCMRevision rev = SCMRevisionAction.getRevision((SCMSource)source, build);
        if (rev == null) {
            return;
        }
        String hash = BitbucketBuildStatusNotifications.getHash(rev);
        if (hash == null) {
            return;
        }
        boolean shareBuildKeyBetweenBranchAndPR = sourceContext.filters().stream().anyMatch(BranchDiscoveryTrait.ExcludeOriginPRBranchesSCMHeadFilter.class::isInstance);
        if (rev instanceof PullRequestSCMRevision) {
            listener.getLogger().println("[Bitbucket] Notifying pull request build result");
            head = (PullRequestSCMHead)rev.getHead();
            key = BitbucketBuildStatusNotifications.getBuildKey(build, head.getOriginName(), shareBuildKeyBetweenBranchAndPR);
            if (BitbucketApiUtils.isCloud(source.getServerUrl())) {
                refName = head.getBranchName();
                client = source.buildBitbucketClient((PullRequestSCMHead)head);
            } else {
                client = source.buildBitbucketClient();
                refName = "refs/heads/" + head.getBranchName();
            }
        } else {
            listener.getLogger().println("[Bitbucket] Notifying commit build result");
            head = rev.getHead();
            key = BitbucketBuildStatusNotifications.getBuildKey(build, head.getName(), shareBuildKeyBetweenBranchAndPR);
            client = source.buildBitbucketClient();
            refName = BitbucketApiUtils.isCloud(client) ? head.getName() : (rev instanceof BitbucketTagSCMRevision || head instanceof BitbucketTagSCMHead ? "refs/tags/" + head.getName() : "refs/heads/" + head.getName());
        }
        try (BitbucketApi bitbucketApi = client;){
            BitbucketBuildStatusNotifications.createStatus(build, listener, client, key, hash, (String)refName);
        }
    }

    @CheckForNull
    private static String getHash(@CheckForNull SCMRevision revision) {
        if (revision instanceof PullRequestSCMRevision) {
            PullRequestSCMRevision prRevision = (PullRequestSCMRevision)revision;
            revision = prRevision.getPull();
        }
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            AbstractGitSCMSource.SCMRevisionImpl scmRevision = (AbstractGitSCMSource.SCMRevisionImpl)revision;
            return scmRevision.getHash();
        }
        return null;
    }

    private static String getBuildKey(@NonNull Run<?, ?> build, String branch, boolean shareBuildKeyBetweenBranchAndPR) {
        String key;
        if (shareBuildKeyBetweenBranchAndPR) {
            String folderName = build.getParent().getParent().getFullName();
            key = String.format("%s/%s", folderName, branch);
        } else {
            key = build.getParent().getFullName();
        }
        return key;
    }

    private static String getBuildParentKey(@NonNull Run<?, ?> build) {
        return build.getParent().getParent().getFullName();
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, TaskListener listener) {
            BitbucketSCMSource source = BitbucketBuildStatusNotifications.findBitbucketSCMSource(build);
            if (source == null) {
                return;
            }
            try {
                BitbucketBuildStatusNotifications.sendNotifications(source, build, listener);
            }
            catch (IOException e) {
                e.printStackTrace(listener.error("Could not send notifications"));
            }
        }
    }

    @Extension
    public static class JobCheckoutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            boolean hasCompletedCheckoutBefore;
            BitbucketSCMSource source = BitbucketBuildStatusNotifications.findBitbucketSCMSource(build);
            if (source == null) {
                return;
            }
            SCMRevision r = SCMRevisionAction.getRevision((SCMSource)source, build);
            if (r == null) {
                return;
            }
            boolean bl = hasCompletedCheckoutBefore = build.getAction(FirstCheckoutCompletedInvisibleAction.class) != null;
            if (!hasCompletedCheckoutBefore) {
                build.addAction((Action)new FirstCheckoutCompletedInvisibleAction());
                try {
                    BitbucketBuildStatusNotifications.sendNotifications(source, build, listener);
                }
                catch (IOException e) {
                    e.printStackTrace(listener.error("Could not send notifications"));
                }
            }
        }
    }
}

