/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.util;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Item;
import hudson.util.FormFillFailure;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.hc.core5.http.HttpHost;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class BitbucketApiUtils {
    private static final Logger logger = Logger.getLogger(BitbucketApiUtils.class.getName());

    public static boolean isCloud(BitbucketApi client) {
        return client instanceof BitbucketCloudApiClient;
    }

    public static boolean isCloud(@NonNull String serverURL) {
        try {
            return "bitbucket.org".equalsIgnoreCase(new URL(serverURL).getHost());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static ListBoxModel getFromBitbucket(SCMSourceOwner context, String serverURL, String credentialsId, String repoOwner, String repository, BitbucketSupplier<ListBoxModel> listBoxModelSupplier) throws FormFillFailure {
        ListBoxModel listBoxModel;
        block13: {
            if ((repoOwner = Util.fixEmptyAndTrim((String)repoOwner)) == null) {
                return new ListBoxModel();
            }
            if (context == null && !Jenkins.get().hasPermission(Jenkins.MANAGE) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new ListBoxModel();
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            serverURL = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(BitbucketEndpointConfiguration.get().getDefaultEndpoint()).getServerURL();
            StandardCredentials credentials = BitbucketCredentialsUtils.lookupCredentials((Item)context, serverURL, credentialsId, StandardCredentials.class);
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(serverURL), (Credentials)credentials);
            BitbucketApi bitbucket = BitbucketApiFactory.newInstance(serverURL, authenticator, repoOwner, null, repository);
            try {
                listBoxModel = listBoxModelSupplier.get(bitbucket);
                if (bitbucket == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (bitbucket != null) {
                        try {
                            bitbucket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FormFillFailure e) {
                    throw e;
                }
                catch (IOException | InterruptedException e) {
                    BitbucketRequestException bbe = BitbucketApiUtils.unwrap(e);
                    if (bbe != null && bbe.getHttpCode() == 401) {
                        throw FormFillFailure.error((String)(credentials == null ? Messages.BitbucketSCMSource_UnauthorizedAnonymous(repoOwner) : Messages.BitbucketSCMSource_UnauthorizedOwner(repoOwner))).withSelectionCleared();
                    }
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    throw FormFillFailure.error((String)e.getMessage());
                }
            }
            bitbucket.close();
        }
        return listBoxModel;
    }

    public static BitbucketRequestException unwrap(Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (cause instanceof BitbucketRequestException) {
                BitbucketRequestException bbException = (BitbucketRequestException)cause;
                return bbException;
            }
            if (cause == cause.getCause()) break;
        }
        return null;
    }

    public static HttpHost toHttpHost(String url) {
        try {
            URL tmp = new URL(url);
            String schema = tmp.getProtocol() == null ? "http" : tmp.getProtocol();
            return new HttpHost(schema, tmp.getHost(), tmp.getPort());
        }
        catch (MalformedURLException tmp) {
            try {
                return HttpHost.create((String)url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid URL " + url, e);
            }
        }
    }

    public static interface BitbucketSupplier<T> {
        public T get(BitbucketApi var1) throws IOException, InterruptedException;
    }
}

