/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractBitbucketWebhookConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWebhookManager<T extends AbstractBitbucketWebhookConfiguration>
implements BitbucketWebhookManager {
    protected T configuration;
    protected String callbackURL;

    @Override
    public void setCallbackURL(String callbackURL, BitbucketEndpoint endpoint) {
        this.callbackURL = callbackURL;
    }

    @Override
    public void apply(BitbucketWebhookConfiguration configuration) {
        this.configuration = (AbstractBitbucketWebhookConfiguration)configuration;
    }

    @Nullable
    protected String buildCacheKey(@NonNull BitbucketAuthenticatedClient client) {
        if (StringUtils.isNotBlank((CharSequence)client.getRepositoryName())) {
            return StringUtils.upperCase((String)client.getRepositoryOwner()) + "::" + client.getRepositoryName();
        }
        return null;
    }

    protected boolean isCacheEnabled(@NonNull BitbucketAuthenticatedClient client) {
        return ((AbstractBitbucketWebhookConfiguration)this.configuration).isEnableCache() && StringUtils.isNotBlank((CharSequence)client.getRepositoryName());
    }

    @Nullable
    protected String getEndpointJenkinsRootURL() {
        return (String)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> ((AbstractBitbucketWebhookConfiguration)this.configuration).getEndpointJenkinsRootURL(), () -> BitbucketWebhookConfiguration.getDefaultJenkinsRootURL()});
    }
}

