/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerAPIClient;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import org.apache.commons.lang3.StringUtils;

@Extension(ordinal=-1000.0)
public class BitbucketServerApiFactory
extends BitbucketApiFactory {
    @Override
    protected boolean isMatch(@Nullable String serverUrl) {
        return serverUrl != null && !"https://bitbucket.org".equals(serverUrl);
    }

    @Override
    @NonNull
    protected BitbucketApi create(@Nullable String serverURL, @Nullable BitbucketAuthenticator authenticator, @NonNull String owner, @CheckForNull String projectKey, @CheckForNull String repository) {
        if (StringUtils.isBlank((CharSequence)serverURL)) {
            throw new IllegalArgumentException("serverUrl is required");
        }
        return new BitbucketServerAPIClient(serverURL, owner, repository, authenticator, false);
    }
}

