/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.BitbucketServerPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.BitbucketServerPushEvent;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BitbucketServerWebhookPayload {
    private static final Logger LOGGER = Logger.getLogger(BitbucketServerWebhookPayload.class.getName());

    @CheckForNull
    public static BitbucketPushEvent pushEventFromPayload(@NonNull String payload) {
        try {
            return JsonParser.toJava(payload, BitbucketServerPushEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return null;
        }
    }

    @CheckForNull
    public static BitbucketPullRequestEvent pullRequestEventFromPayload(@NonNull String payload) {
        try {
            return JsonParser.toJava(payload, BitbucketServerPullRequestEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return null;
        }
    }
}

