/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.CredentialsSelectHelper;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import hudson.Extension;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Extension
public class ListCredentialsContextResolversCommand
extends BaseCredentialsCLICommand {
    public String getShortDescription() {
        return Messages.ListCredentialsContextResolversCommand_ShortDescription();
    }

    protected int run() throws Exception {
        Map<String, CredentialsSelectHelper.ContextResolver> resolversByName = CredentialsSelectHelper.getResolversByName();
        int maxNameLen = 0;
        int maxDisplayLen = 0;
        for (Map.Entry<String, CredentialsSelectHelper.ContextResolver> entry : resolversByName.entrySet()) {
            maxNameLen = Math.max(maxNameLen, entry.getKey().length());
            maxDisplayLen = Math.max(maxDisplayLen, CredentialsSelectHelper.ContextResolver.displayName(entry.getValue()).length());
        }
        this.stdout.println(StringUtils.rightPad((String)"Name", (int)maxNameLen) + " Resolves");
        this.stdout.println(StringUtils.repeat((String)"=", (int)maxNameLen) + " " + StringUtils.repeat((String)"=", (int)maxDisplayLen));
        for (Map.Entry<String, CredentialsSelectHelper.ContextResolver> entry : resolversByName.entrySet()) {
            this.stdout.println(StringUtils.rightPad((String)entry.getKey(), (int)maxNameLen) + " " + CredentialsSelectHelper.ContextResolver.displayName(entry.getValue()));
        }
        return 0;
    }
}

