/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gwt.GenericCause;
import org.jenkinsci.plugins.gwt.GenericHeaderVariable;
import org.jenkinsci.plugins.gwt.GenericRequestVariable;
import org.jenkinsci.plugins.gwt.GenericTriggerResults;
import org.jenkinsci.plugins.gwt.GenericVariable;
import org.jenkinsci.plugins.gwt.ParameterActionUtil;
import org.jenkinsci.plugins.gwt.Renderer;
import org.jenkinsci.plugins.gwt.global.CredentialsHelper;
import org.jenkinsci.plugins.gwt.resolvers.VariablesResolver;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GenericTrigger
extends Trigger<Job<?, ?>> {
    public static final String HEADER_DRY_RUN = "gwt-dry-run";
    private List<GenericVariable> genericVariables = Lists.newArrayList();
    private String regexpFilterText;
    private String regexpFilterExpression;
    private List<GenericRequestVariable> genericRequestVariables = Lists.newArrayList();
    private List<GenericHeaderVariable> genericHeaderVariables = Lists.newArrayList();
    private boolean printPostContent;
    private boolean printContributedVariables;
    private String causeString;
    private String token;
    private String tokenCredentialId;
    private boolean silentResponse;
    private boolean overrideQuietPeriod;
    private boolean shouldNotFlattern;
    private boolean allowSeveralTriggersPerBuild;
    @Extension
    public static final GenericDescriptor DESCRIPTOR = new GenericDescriptor();

    @DataBoundConstructor
    public GenericTrigger(List<GenericVariable> genericVariables, List<GenericRequestVariable> genericRequestVariables, List<GenericHeaderVariable> genericHeaderVariables) {
        this.genericVariables = genericVariables;
        this.genericRequestVariables = genericRequestVariables;
        this.genericHeaderVariables = genericHeaderVariables;
    }

    @DataBoundSetter
    public void setRegexpFilterText(String regexpFilterText) {
        this.regexpFilterText = regexpFilterText;
    }

    @DataBoundSetter
    public void setRegexpFilterExpression(String regexpFilterExpression) {
        this.regexpFilterExpression = regexpFilterExpression;
    }

    @DataBoundSetter
    public void setCauseString(String causeString) {
        this.causeString = causeString;
    }

    public String getCauseString() {
        return this.causeString;
    }

    @DataBoundSetter
    public void setPrintContributedVariables(boolean printContributedVariables) {
        this.printContributedVariables = printContributedVariables;
    }

    @DataBoundSetter
    public void setPrintPostContent(boolean printPostContent) {
        this.printPostContent = printPostContent;
    }

    @DataBoundSetter
    public void setSilentResponse(boolean silentResponse) {
        this.silentResponse = silentResponse;
    }

    @DataBoundSetter
    public void setOverrideQuietPeriod(boolean overrideQuietPeriod) {
        this.overrideQuietPeriod = overrideQuietPeriod;
    }

    public boolean getOverrideQuietPeriod() {
        return this.overrideQuietPeriod;
    }

    @Deprecated
    @DataBoundSetter
    public void setShouldNotFlattern(boolean shouldNotFlattern) {
        this.shouldNotFlattern = shouldNotFlattern;
    }

    @Deprecated
    public boolean isShouldNotFlattern() {
        return this.shouldNotFlattern;
    }

    @DataBoundSetter
    public void setShouldNotFlatten(boolean shouldNotFlatten) {
        this.shouldNotFlattern = shouldNotFlatten;
    }

    public boolean isShouldNotFlatten() {
        return this.shouldNotFlattern;
    }

    public boolean isSilentResponse() {
        return this.silentResponse;
    }

    public boolean isPrintContributedVariables() {
        return this.printContributedVariables;
    }

    public boolean isPrintPostContent() {
        return this.printPostContent;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = tokenCredentialId;
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setAllowSeveralTriggersPerBuild(boolean allowSeveralTriggersPerBuild) {
        this.allowSeveralTriggersPerBuild = allowSeveralTriggersPerBuild;
    }

    public boolean getAllowSeveralTriggersPerBuild() {
        return this.allowSeveralTriggersPerBuild;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT", "NP_NULL_ON_SOME_PATH"})
    public GenericTriggerResults trigger(Map<String, List<String>> headers, Map<String, String[]> parameterMap, String postContent, int quietPeriod) {
        Map<String, String> resolvedVariables = new VariablesResolver(headers, parameterMap, postContent, this.genericVariables, this.genericRequestVariables, this.genericHeaderVariables, this.shouldNotFlattern).getVariables();
        String renderedRegexpFilterText = Renderer.renderText(this.regexpFilterText, resolvedVariables);
        boolean isMatching = Renderer.isMatching(renderedRegexpFilterText, this.regexpFilterExpression);
        String url = null;
        long id = 0L;
        boolean triggered = false;
        if (isMatching) {
            String cause = Renderer.renderText(this.causeString, resolvedVariables);
            GenericCause genericCause = new GenericCause(postContent, resolvedVariables, this.printContributedVariables, this.printPostContent, cause);
            ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)((Job)this.job).getProperty(ParametersDefinitionProperty.class);
            ParametersAction parameters = ParameterActionUtil.createParameterAction(parametersDefinitionProperty, resolvedVariables, this.allowSeveralTriggersPerBuild);
            if (GenericTrigger.isDryRun(headers)) {
                url = ((Job)this.job).getAbsoluteUrl();
                triggered = true;
            } else {
                this.retrieveScheduleJob((Job)this.job);
                Queue.Item item = ParameterizedJobMixIn.scheduleBuild2((Job)((Job)this.job), (int)quietPeriod, (Action[])new Action[]{new CauseAction((Cause)genericCause), parameters});
                if (item != null) {
                    url = item.getUrl();
                    id = item.getId();
                    triggered = true;
                }
            }
        }
        return new GenericTriggerResults(url, id, triggered, resolvedVariables, renderedRegexpFilterText, this.regexpFilterExpression);
    }

    static boolean isDryRun(Map<String, List<String>> headers) {
        if (headers == null) {
            return false;
        }
        List<String> dryRunHeaders = headers.get(HEADER_DRY_RUN);
        if (dryRunHeaders == null) {
            return false;
        }
        for (String dryRunHeader : dryRunHeaders) {
            if (!dryRunHeader.equalsIgnoreCase("true")) continue;
            return true;
        }
        return false;
    }

    private ParameterizedJobMixIn<?, ?> retrieveScheduleJob(final Job<?, ?> job) {
        return new ParameterizedJobMixIn(){

            protected Job<?, ?> asJob() {
                return job;
            }
        };
    }

    public List<GenericVariable> getGenericVariables() {
        return this.genericVariables;
    }

    public String getRegexpFilterExpression() {
        return this.regexpFilterExpression;
    }

    public List<GenericRequestVariable> getGenericRequestVariables() {
        return this.genericRequestVariables;
    }

    public List<GenericHeaderVariable> getGenericHeaderVariables() {
        return this.genericHeaderVariables;
    }

    public String getRegexpFilterText() {
        return this.regexpFilterText;
    }

    public String toString() {
        return "GenericTrigger [genericVariables=" + String.valueOf(this.genericVariables) + ", regexpFilterText=" + this.regexpFilterText + ", regexpFilterExpression=" + this.regexpFilterExpression + ", genericRequestVariables=" + String.valueOf(this.genericRequestVariables) + ", genericHeaderVariables=" + String.valueOf(this.genericHeaderVariables) + "]";
    }

    @Symbol(value={"GenericTrigger"})
    public static class GenericDescriptor
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return Job.class.isAssignableFrom(item.getClass());
        }

        public String getDisplayName() {
            return "Generic Webhook Trigger";
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return CredentialsHelper.doFillCredentialsIdItems(item, credentialsId);
        }

        public FormValidation doCheckTokenCredentialIdItems(@QueryParameter String value) {
            return CredentialsHelper.doCheckFillCredentialsId(value);
        }
    }
}

