/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.LineIterator;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitChangeLogParser
extends ChangeLogParser {
    private boolean authorOrCommitter;
    private boolean showEntireCommitSummaryInChanges;
    private static int THRESHOLD = 1000;

    @Deprecated
    public GitChangeLogParser(boolean authorOrCommitter) {
        this(null, authorOrCommitter);
    }

    public GitChangeLogParser(GitClient git, boolean authorOrCommitter) {
        this.authorOrCommitter = authorOrCommitter;
        this.showEntireCommitSummaryInChanges = GitChangeSet.isShowEntireCommitSummaryInChanges() || !(git instanceof CliGitAPIImpl);
    }

    public List<GitChangeSet> parse(@NonNull InputStream changelog) throws IOException {
        try (InputStreamReader r = new InputStreamReader(changelog, StandardCharsets.UTF_8);){
            List<GitChangeSet> list;
            try (LineIterator it = new LineIterator((Reader)r);){
                list = this.parse((Iterator<String>)it);
            }
            return list;
        }
    }

    public List<GitChangeSet> parse(@NonNull List<String> changelog) {
        return this.parse(changelog.iterator());
    }

    public GitChangeSetList parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException {
        GitChangeSetList gitChangeSetList;
        block8: {
            Stream<String> lineStream = Files.lines(changelogFile.toPath(), StandardCharsets.UTF_8);
            try {
                gitChangeSetList = new GitChangeSetList(build, browser, this.parse(lineStream.iterator()));
                if (lineStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lineStream != null) {
                        try {
                            lineStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidPathException e) {
                    throw new IOException(e);
                }
            }
            lineStream.close();
        }
        return gitChangeSetList;
    }

    private List<GitChangeSet> parse(Iterator<String> changelog) {
        LinkedHashSet<GitChangeSet> r = new LinkedHashSet<GitChangeSet>();
        ArrayList<String> lines = null;
        while (changelog.hasNext()) {
            String line = changelog.next();
            if (line.startsWith("commit ")) {
                if (lines != null) {
                    r.add(this.parseCommit(lines, this.authorOrCommitter));
                }
                lines = new ArrayList<String>();
            }
            if (lines == null || lines.size() >= THRESHOLD) continue;
            lines.add(line);
        }
        if (lines != null) {
            r.add(this.parseCommit(lines, this.authorOrCommitter));
        }
        return new ArrayList<GitChangeSet>(r);
    }

    private GitChangeSet parseCommit(List<String> lines, boolean authorOrCommitter) {
        return new GitChangeSet(lines, authorOrCommitter, this.showEntireCommitSummaryInChanges);
    }
}

