/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.extension;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousVersionRestClient;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import hudson.plugins.jira.extension.ExtendedVersion;
import hudson.plugins.jira.extension.ExtendedVersionInput;
import hudson.plugins.jira.extension.ExtendedVersionInputJsonGenerator;
import hudson.plugins.jira.extension.ExtendedVersionJsonParser;
import hudson.plugins.jira.extension.ExtendedVersionRestClient;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class ExtendedAsynchronousVersionRestClient
extends AsynchronousVersionRestClient
implements ExtendedVersionRestClient {
    private final URI versionRootUri;

    ExtendedAsynchronousVersionRestClient(URI baseUri, HttpClient client) {
        super(baseUri, client);
        this.versionRootUri = UriBuilder.fromUri((URI)baseUri).path("version").build(new Object[0]);
    }

    @Override
    public Promise<ExtendedVersion> getExtendedVersion(URI versionUri) {
        return this.getAndParse(versionUri, (JsonParser)new ExtendedVersionJsonParser());
    }

    @Override
    public Promise<ExtendedVersion> createExtendedVersion(ExtendedVersionInput versionInput) {
        return this.postAndParse(this.versionRootUri, (Object)versionInput, new ExtendedVersionInputJsonGenerator(), new ExtendedVersionJsonParser());
    }

    @Override
    public Promise<ExtendedVersion> updateExtendedVersion(URI versionUri, ExtendedVersionInput versionInput) {
        return this.putAndParse(versionUri, (Object)versionInput, new ExtendedVersionInputJsonGenerator(), new ExtendedVersionJsonParser());
    }
}

