/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.User;
import hudson.model.listeners.ItemListener;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.AbstractAuthorizationPropertyConverter;
import org.jenkinsci.plugins.matrixauth.AmbiguityMonitor;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.AuthorizationProperty;
import org.jenkinsci.plugins.matrixauth.AuthorizationPropertyDescriptor;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritParentStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.GET;

public class AuthorizationMatrixProperty
extends JobProperty<Job<?, ?>>
implements AuthorizationProperty<JobProperty<?>> {
    private final transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<PermissionEntry>> grantedPermissions = new HashMap<Permission, Set<PermissionEntry>>();
    private final Set<String> groupSids = Collections.synchronizedSet(new HashSet());
    @Deprecated
    private transient Boolean blocksInheritance;
    private InheritanceStrategy inheritanceStrategy = new InheritParentStrategy();
    private static final Logger LOGGER = Logger.getLogger(AuthorizationMatrixProperty.class.getName());

    private AuthorizationMatrixProperty() {
    }

    public AuthorizationMatrixProperty(Map<Permission, Set<PermissionEntry>> grantedPermissions, InheritanceStrategy inheritanceStrategy) {
        this.inheritanceStrategy = inheritanceStrategy;
        grantedPermissions.forEach((key, value) -> {
            this.grantedPermissions.put((Permission)key, new HashSet(value));
            value.forEach(entry -> {
                if (entry.getType() != AuthorizationType.USER) {
                    this.recordGroup(entry.getSid());
                }
            });
        });
    }

    @Deprecated
    public AuthorizationMatrixProperty(Map<Permission, Set<String>> grantedPermissions) {
        for (Map.Entry<Permission, Set<String>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), e.getValue().stream().map(sid -> new PermissionEntry(AuthorizationType.EITHER, (String)sid)).collect(Collectors.toSet()));
        }
    }

    @Restricted(value={DoNotUse.class})
    @DataBoundConstructor
    public AuthorizationMatrixProperty(List<AuthorizationProperty.DslEntry> entries) {
        this.setEntries(entries);
    }

    public List<String> getPermissions() {
        ArrayList<String> permissions = new ArrayList<String>();
        TreeMap<Permission, Set<PermissionEntry>> map = new TreeMap<Permission, Set<PermissionEntry>>(Comparator.comparing(Permission::getId));
        map.putAll(this.grantedPermissions);
        for (Map.Entry entry : map.entrySet()) {
            String permission = ((Permission)entry.getKey()).getId();
            TreeSet<PermissionEntry> permissionEntries = new TreeSet<PermissionEntry>(new AuthorizationContainer.PermissionEntryComparator());
            permissionEntries.addAll((Collection)entry.getValue());
            for (PermissionEntry e : permissionEntries) {
                permissions.add(e.getType().toPrefix() + permission + ":" + e.getSid());
            }
        }
        return permissions;
    }

    @Override
    public Set<String> getGroups() {
        return this.groupSids;
    }

    @Override
    public void recordGroup(String sid) {
        this.groupSids.add(sid);
    }

    @Override
    public Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries() {
        return this.grantedPermissions;
    }

    @Override
    public Permission getEditingPermission() {
        return Item.CONFIGURE;
    }

    @Override
    @Restricted(value={DoNotUse.class})
    public List<AuthorizationProperty.DslEntry> getEntries() {
        return AuthorizationProperty.super.getEntries();
    }

    public SidACL getACL() {
        return this.acl;
    }

    @Override
    @DataBoundSetter
    public void setInheritanceStrategy(InheritanceStrategy inheritanceStrategy) {
        this.inheritanceStrategy = inheritanceStrategy;
    }

    @Override
    public InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    protected void setOwner(Job<?, ?> owner) {
        super.setOwner(owner);
        AmbiguityMonitor.JobContributor.update(owner);
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixProperty.this.hasPermission(this.toString(sid), p, sid instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class ItemListenerImpl
    extends ItemListener {
        public void onCreated(Item item) {
            AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
            if (authorizationStrategy instanceof ProjectMatrixAuthorizationStrategy) {
                ProjectMatrixAuthorizationStrategy strategy = (ProjectMatrixAuthorizationStrategy)authorizationStrategy;
                if (item instanceof Job) {
                    User current;
                    String sid;
                    boolean propIsNew;
                    Job job = (Job)item;
                    AuthorizationMatrixProperty prop = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
                    boolean bl = propIsNew = prop == null;
                    if (propIsNew) {
                        prop = new AuthorizationMatrixProperty();
                    }
                    String string = sid = (current = User.current()) == null ? "anonymous" : current.getId();
                    if (!strategy.getACL(job).hasPermission2(Jenkins.getAuthentication2(), Item.READ)) {
                        prop.add(Item.READ, new PermissionEntry(AuthorizationType.USER, sid));
                    }
                    if (!strategy.getACL(job).hasPermission2(Jenkins.getAuthentication2(), Item.CONFIGURE)) {
                        prop.add(Item.CONFIGURE, new PermissionEntry(AuthorizationType.USER, sid));
                    }
                    if (prop.getGrantedPermissionEntries().size() > 0) {
                        try {
                            if (propIsNew) {
                                job.addProperty((JobProperty)prop);
                            } else {
                                job.save();
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, "Failed to grant creator permissions on job " + item.getFullName(), ex);
                        }
                    }
                }
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    public static final class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AuthorizationMatrixProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixProperty.class;
        }

        @Override
        public AuthorizationMatrixProperty create() {
            return new AuthorizationMatrixProperty();
        }
    }

    @Extension
    @Symbol(value={"authorizationMatrix"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor
    implements AuthorizationPropertyDescriptor<AuthorizationMatrixProperty> {
        @Override
        public AuthorizationMatrixProperty create() {
            return new AuthorizationMatrixProperty();
        }

        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.ITEM;
        }

        public JobProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (JobProperty)this.createNewInstance(req, formData, true);
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return this.isApplicable();
        }

        @GET
        public FormValidation doCheckName(@AncestorInPath Job<?, ?> project, @QueryParameter String value) {
            return this.doCheckName_(value, (AccessControlled)project, Item.CONFIGURE);
        }
    }
}

