/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AdministrativeMonitor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import jenkins.util.SystemProperties;
import org.jenkinsci.plugins.matrixauth.AuthorizationContainer;
import org.jenkinsci.plugins.matrixauth.AuthorizationMatrixNodeProperty;
import org.jenkinsci.plugins.matrixauth.AuthorizationType;
import org.jenkinsci.plugins.matrixauth.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class AmbiguityMonitor
extends AdministrativeMonitor {
    public static final Logger LOGGER = Logger.getLogger(AmbiguityMonitor.class.getName());
    private static boolean DISABLE = SystemProperties.getBoolean((String)(AmbiguityMonitor.class.getName() + ".DISABLE"));

    public List<Contributor> getContributors() {
        return ExtensionList.lookup(Contributor.class);
    }

    public String getDisplayName() {
        return Messages.AmbiguityMonitor_DisplayName();
    }

    public boolean isSecurity() {
        return true;
    }

    public boolean isActivated() {
        if (DISABLE) {
            return false;
        }
        List<Contributor> contributors = this.getContributors();
        for (Contributor contributor : contributors) {
            if (!contributor.hasAmbiguousEntries()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAmbiguousEntries(AuthorizationContainer<?> container) {
        if (container == null) {
            return false;
        }
        return container.getAllPermissionEntries().stream().anyMatch(e -> e.getType() == AuthorizationType.EITHER);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
    public static void recordAgents() {
        LOGGER.log(Level.FINE, () -> "Recording nodes");
        Jenkins.get().getNodes().forEach(NodeContributor::record);
    }

    public static boolean isGatheringData() {
        return !DISABLE;
    }

    public static interface Contributor
    extends ExtensionPoint {
        public boolean hasAmbiguousEntries();
    }

    @Extension
    public static class JobSaveableListenerImpl
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (!AmbiguityMonitor.isGatheringData()) {
                return;
            }
            try {
                if (o instanceof Job) {
                    LOGGER.log(Level.FINEST, () -> "Recording update to Saveable " + o + " stored in " + file);
                    JobContributor.update((Job)o);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex, () -> "Exception while updating status for " + o);
            }
        }
    }

    @Extension
    public static class JobContributor
    implements Contributor {
        public final Map<String, Boolean> activeJobs = Collections.synchronizedMap(new TreeMap());

        @Override
        public boolean hasAmbiguousEntries() {
            return Jenkins.get().getAuthorizationStrategy() instanceof ProjectMatrixAuthorizationStrategy && this.activeJobs.values().stream().anyMatch(v -> v);
        }

        public static void update(Job<?, ?> job) {
            if (!DISABLE) {
                boolean value = AmbiguityMonitor.hasAmbiguousEntries((AuthorizationContainer)job.getProperty(AuthorizationMatrixProperty.class));
                LOGGER.log(Level.FINE, () -> "Recording job " + job + " as having ambiguous entries? " + value);
                ((JobContributor)ExtensionList.lookupSingleton(JobContributor.class)).activeJobs.put(job.getFullName(), value);
            }
        }

        public static void remove(String jobName) {
            if (!DISABLE) {
                LOGGER.log(Level.FINE, () -> "Removing job " + jobName);
                ((JobContributor)ExtensionList.lookupSingleton(JobContributor.class)).activeJobs.remove(jobName);
            }
        }

        public List<Item> getEntries() {
            return this.activeJobs.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(v -> Jenkins.get().getItemByFullName(v)).filter(Objects::nonNull).sorted(Comparator.comparing(Item::getFullDisplayName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        }

        @Extension
        public static class JobListenerImpl
        extends ItemListener {
            public void onCreated(Item item) {
                if (item instanceof Job) {
                    JobContributor.update((Job)item);
                }
            }

            public void onLocationChanged(Item item, String oldFullName, String newFullName) {
                if (AmbiguityMonitor.isGatheringData() && item instanceof Job) {
                    JobContributor.remove(oldFullName);
                    JobContributor.update((Job)item);
                }
            }

            public void onDeleted(Item item) {
                if (!DISABLE && item instanceof Job) {
                    JobContributor.remove(item.getFullName());
                }
            }
        }
    }

    @Extension
    public static class NodeContributor
    implements Contributor {
        public final Map<String, Boolean> activeNodes = Collections.synchronizedMap(new TreeMap());

        @Override
        public boolean hasAmbiguousEntries() {
            return Jenkins.get().getAuthorizationStrategy() instanceof ProjectMatrixAuthorizationStrategy && this.activeNodes.values().stream().anyMatch(v -> v);
        }

        public static void record(Node node) {
            if (!DISABLE) {
                boolean value = AmbiguityMonitor.hasAmbiguousEntries((AuthorizationContainer)node.getNodeProperty(AuthorizationMatrixNodeProperty.class));
                LOGGER.log(Level.FINE, () -> "Recording node " + node + " as having ambiguous entries? " + value);
                ((NodeContributor)ExtensionList.lookupSingleton(NodeContributor.class)).activeNodes.put(node.getNodeName(), value);
            }
        }

        public static void remove(String nodeName) {
            if (!DISABLE) {
                LOGGER.log(Level.FINE, () -> "Removing node " + nodeName);
                ((NodeContributor)ExtensionList.lookupSingleton(NodeContributor.class)).activeNodes.remove(nodeName);
            }
        }

        @Extension
        public static class NodeListenerImpl
        extends NodeListener {
            protected void onCreated(@NonNull Node node) {
                NodeContributor.record(node);
            }

            protected void onUpdated(Node oldOne, Node newOne) {
                NodeContributor.record(newOne);
            }

            protected void onDeleted(@NonNull Node node) {
                if (!DISABLE) {
                    NodeContributor.remove(node.getNodeName());
                }
            }
        }
    }

    @Extension(ordinal=10.0)
    public static class GlobalConfigurationContributor
    implements Contributor {
        @Override
        public boolean hasAmbiguousEntries() {
            AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
            if (authorizationStrategy instanceof GlobalMatrixAuthorizationStrategy) {
                return AmbiguityMonitor.hasAmbiguousEntries((GlobalMatrixAuthorizationStrategy)authorizationStrategy);
            }
            return false;
        }
    }
}

