/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.CauseOfInterruption;

public final class DownstreamFailureCause
extends CauseOfInterruption {
    private static final long serialVersionUID = 1L;
    private final String id;

    DownstreamFailureCause(Run<?, ?> downstream) {
        this.id = downstream.getExternalizableId();
    }

    @CheckForNull
    public Run<?, ?> getDownstreamBuild() {
        return Run.fromExternalizableId((String)this.id);
    }

    public void print(TaskListener listener) {
        Run<?, ?> downstream = this.getDownstreamBuild();
        Object description = downstream != null ? ModelHyperlinkNote.encodeTo((String)("/" + downstream.getUrl()), (String)downstream.getFullDisplayName()) + " completed with status " + downstream.getResult() + " (propagate: false to ignore)" : "Downstream build was not stable (propagate: false to ignore)";
        listener.getLogger().println((String)description);
    }

    public String getShortDescription() {
        Run<?, ?> downstream = this.getDownstreamBuild();
        if (downstream != null) {
            return downstream.getFullDisplayName() + " completed with status " + downstream.getResult() + " (propagate: false to ignore)";
        }
        return "Downstream build was not stable (propagate: false to ignore)";
    }
}

