/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.build.Messages;
import org.jenkinsci.plugins.workflow.support.steps.build.WaitForBuildStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class WaitForBuildStep
extends Step {
    private final String runId;
    private boolean propagate = false;

    @DataBoundConstructor
    public WaitForBuildStep(String runId) {
        this.runId = runId;
    }

    public String getRunId() {
        return this.runId;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    @DataBoundSetter
    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WaitForBuildStepExecution(this, context);
    }

    public FormValidation doCheckRunId(@AncestorInPath ItemGroup<?> context, @QueryParameter String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.warning((String)Messages.WaitForBuildStep_no_run_configured());
        }
        Run run = Run.fromExternalizableId((String)value);
        if (run == null) {
            return FormValidation.error((String)Messages.WaitForBuildStep_cannot_find(value));
        }
        return FormValidation.ok();
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "waitForBuild";
        }

        @NonNull
        public String getDisplayName() {
            return "Wait for build to complete";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, FlowNode.class, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

