/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.WaitForBuildAction;
import org.jenkinsci.plugins.workflow.support.steps.build.WaitForBuildStep;

public class WaitForBuildStepExecution
extends AbstractStepExecutionImpl {
    private static final long serialVersionUID = 1L;
    private final transient WaitForBuildStep step;

    public WaitForBuildStepExecution(WaitForBuildStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        Run run = Run.fromExternalizableId((String)this.step.getRunId());
        if (run == null) {
            throw new AbortException("No build exists with runId " + this.step.getRunId());
        }
        String runHyperLink = ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName());
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        if (run.isBuilding()) {
            run.addAction((Action)new WaitForBuildAction(this.getContext(), this.step.isPropagate()));
            taskListener.getLogger().println("Waiting for " + runHyperLink + " to complete");
            return false;
        }
        taskListener.getLogger().println(runHyperLink + " is already complete");
        this.getContext().onSuccess(null);
        return true;
    }
}

