/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.model;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractModelObject;
import hudson.model.Run;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.RobotConfig;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.plugins.robot.graph.RobotGraphHelper;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class RobotTestObject
extends AbstractModelObject
implements Serializable {
    private static final long serialVersionUID = -3191755290679194469L;
    private transient RobotBuildAction parentAction;
    private String duplicateSafeName;
    protected transient long duration;
    private String logFile;
    private String reportFile;
    private String id;

    public RobotBuildAction getParentAction() {
        return this.parentAction;
    }

    public void setParentAction(RobotBuildAction parentAction) {
        this.parentAction = parentAction;
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract RobotTestObject getParent();

    public String getId() {
        return this.id != null ? this.id : "";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFileName) {
        this.logFile = logFileName;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFileName) {
        this.reportFile = reportFileName;
    }

    public boolean getHasLog() {
        return this.logFile != null && !this.logFile.isEmpty();
    }

    public boolean getHasReport() {
        return this.reportFile != null && !this.reportFile.isEmpty();
    }

    public String getRelativePackageName(RobotTestObject thisObject) {
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        StringBuilder sb = new StringBuilder(name);
        String parentPackage = this.getRelativeParent(thisObject);
        if (!"".equals(parentPackage)) {
            sb.insert(0, parentPackage);
        }
        return sb.toString();
    }

    public String getRelativeParent(RobotTestObject thisObject) {
        String parentPackage;
        StringBuilder sb = new StringBuilder();
        RobotTestObject parent = this.getParent();
        if (parent != null && !parent.equals(thisObject) && StringUtils.isNotBlank((String)(parentPackage = parent.getRelativePackageName(thisObject)))) {
            sb.insert(0, ".");
            sb.insert(0, parentPackage);
        }
        return sb.toString();
    }

    public String getRelativeId(RobotTestObject thisObject) {
        String parentId;
        StringBuilder sb = new StringBuilder(this.urlEncode(this.getDuplicateSafeName()));
        RobotTestObject parent = this.getParent();
        if (parent != null && !parent.equals(thisObject) && StringUtils.isNotBlank((String)(parentId = parent.getRelativeId(thisObject)))) {
            sb.insert(0, "/");
            sb.insert(0, parentId);
        }
        return sb.toString();
    }

    public String urlEncode(String name) {
        return Util.rawEncode((String)name);
    }

    public Run<?, ?> getOwner() {
        return this.getParentAction() == null ? null : this.getParentAction().getOwner();
    }

    public RobotTestObject getResultInBuild(AbstractBuild<?, ?> build) {
        this.parentAction = (RobotBuildAction)build.getAction(RobotBuildAction.class);
        String id = this.getRelativeId(this.getParentAction().getResult());
        return this.parentAction == null ? null : this.parentAction.findObjectById(id);
    }

    public String getDuplicateSafeName() {
        if (this.duplicateSafeName != null) {
            return this.duplicateSafeName;
        }
        return this.getName();
    }

    public void setDuplicateSafeName(String name) {
        this.duplicateSafeName = name;
    }

    protected String getOldFormatName() {
        return this.getName().replaceAll("[/\\ :;#?]", "_");
    }

    protected boolean isNeedToGenerate(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return false;
        }
        Calendar t = this.getOwner().getTimestamp();
        return !req.checkIfModified(t, rsp);
    }

    public long getDuration() {
        return this.duration;
    }

    public String getHumanReadableDuration() {
        return DurationFormatUtils.formatDurationHMS((long)this.getDuration());
    }

    public String getDurationDiff(RobotTestObject comparable) {
        long duration;
        long diff = duration = this.getDuration();
        if (comparable != null) {
            diff = duration - comparable.getDuration();
        }
        if (diff == 0L) {
            return "\u00b10";
        }
        if (diff > 0L) {
            return "+" + DurationFormatUtils.formatDurationHMS((long)Math.abs(diff));
        }
        return "-" + DurationFormatUtils.formatDurationHMS((long)Math.abs(diff));
    }

    public abstract RobotTestObject getPreviousResult();

    public abstract int getFailed();

    public abstract int getPassed();

    public abstract int getSkipped();

    public void doGraph(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (!this.isNeedToGenerate(req, rsp)) {
            return;
        }
        String label = this.parentAction.getxAxisLabel();
        String labelFormat = StringUtils.isBlank((String)label) ? RobotConfig.getInstance().getXAxisLabelFormat() : label;
        RobotGraph g = RobotGraphHelper.createTestResultsGraphForTestObject(this, Boolean.parseBoolean(req.getParameter("zoomSignificant")), false, Boolean.parseBoolean(req.getParameter("hd")), Boolean.parseBoolean(req.getParameter("failedOnly")), labelFormat, Integer.parseInt(req.getParameter("maxBuildsToShow")));
        g.doPng(req, rsp);
    }

    public void doDurationGraph(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (!this.isNeedToGenerate(req, rsp)) {
            return;
        }
        String label = this.parentAction.getxAxisLabel();
        String labelFormat = StringUtils.isBlank((String)label) ? RobotConfig.getInstance().getXAxisLabelFormat() : label;
        RobotGraph g = RobotGraphHelper.createDurationGraphForTestObject(this, req.hasParameter("hd"), Integer.parseInt(req.getParameter("maxBuildsToShow")), labelFormat, req.hasParameter("preview"));
        g.doPng(req, rsp);
    }
}

