/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.stashNotifier;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.google.inject.Injector;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.stashNotifier.BuildStatusUriFactory;
import org.jenkinsci.plugins.stashNotifier.HttpNotifier;
import org.jenkinsci.plugins.stashNotifier.HttpNotifierSelector;
import org.jenkinsci.plugins.stashNotifier.NotificationContext;
import org.jenkinsci.plugins.stashNotifier.NotificationResult;
import org.jenkinsci.plugins.stashNotifier.NotificationSettings;
import org.jenkinsci.plugins.stashNotifier.SelectionContext;
import org.jenkinsci.plugins.stashNotifier.StashBuildState;
import org.jenkinsci.plugins.stashNotifier.StashCredentialMatcher;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StashNotifier
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(StashNotifier.class);
    public static final int MAX_FIELD_LENGTH = 255;
    public static final int MAX_URL_FIELD_LENGTH = 450;
    private String stashServerBaseUrl;
    private String credentialsId;
    private boolean ignoreUnverifiedSSLPeer;
    private String commitSha1;
    private StashBuildState buildStatus;
    private String buildName;
    private String buildUrl;
    private boolean includeBuildNumberInKey;
    private String projectKey;
    private boolean prependParentProjectKey;
    private boolean disableInprogressNotification;
    private boolean considerUnstableAsSuccess;
    private JenkinsLocationConfiguration globalConfig;
    private transient HttpNotifierSelector httpNotifierSelector;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    StashNotifier(String stashServerBaseUrl, String credentialsId, boolean ignoreUnverifiedSSLPeer, String commitSha1, String buildStatus, String buildName, String buildUrl, boolean includeBuildNumberInKey, String projectKey, boolean prependParentProjectKey, boolean disableInprogressNotification, boolean considerUnstableAsSuccess, JenkinsLocationConfiguration globalConfig) {
        this.globalConfig = globalConfig;
        this.setStashServerBaseUrl(stashServerBaseUrl);
        this.setCredentialsId(credentialsId);
        this.setIgnoreUnverifiedSSLPeer(ignoreUnverifiedSSLPeer);
        this.setCommitSha1(commitSha1);
        this.setBuildStatus(buildStatus);
        this.setBuildName(buildName);
        this.setBuildUrl(buildUrl);
        this.setIncludeBuildNumberInKey(includeBuildNumberInKey);
        this.setProjectKey(projectKey);
        this.setPrependParentProjectKey(prependParentProjectKey);
        this.setDisableInprogressNotification(disableInprogressNotification);
        this.setConsiderUnstableAsSuccess(considerUnstableAsSuccess);
    }

    @DataBoundConstructor
    public StashNotifier() {
        this.globalConfig = JenkinsLocationConfiguration.get();
    }

    public String getStashServerBaseUrl() {
        return this.stashServerBaseUrl;
    }

    @DataBoundSetter
    public void setStashServerBaseUrl(String stashServerBaseUrl) {
        this.stashServerBaseUrl = StringUtils.stripEnd((String)stashServerBaseUrl, (String)"/");
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public boolean isIgnoreUnverifiedSSLPeer() {
        return this.ignoreUnverifiedSSLPeer;
    }

    @DataBoundSetter
    public void setIgnoreUnverifiedSSLPeer(boolean ignoreUnverifiedSSLPeer) {
        this.ignoreUnverifiedSSLPeer = ignoreUnverifiedSSLPeer;
    }

    public String getCommitSha1() {
        return this.commitSha1;
    }

    @DataBoundSetter
    public void setCommitSha1(String commitSha1) {
        this.commitSha1 = commitSha1;
    }

    public StashBuildState getBuildStatus() {
        return this.buildStatus;
    }

    @DataBoundSetter
    public void setBuildStatus(Object buildStatus) {
        if (buildStatus instanceof StashBuildState) {
            this.buildStatus = (StashBuildState)((Object)buildStatus);
        } else if (buildStatus instanceof String) {
            try {
                this.buildStatus = StashBuildState.valueOf((String)buildStatus);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getBuildName() {
        return this.buildName;
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    @DataBoundSetter
    public void setBuildUrl(String buildUrl) {
        this.buildUrl = buildUrl;
    }

    public boolean isIncludeBuildNumberInKey() {
        return this.includeBuildNumberInKey;
    }

    @DataBoundSetter
    public void setIncludeBuildNumberInKey(boolean includeBuildNumberInKey) {
        this.includeBuildNumberInKey = includeBuildNumberInKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    @DataBoundSetter
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isPrependParentProjectKey() {
        return this.prependParentProjectKey;
    }

    @DataBoundSetter
    public void setPrependParentProjectKey(boolean prependParentProjectKey) {
        this.prependParentProjectKey = prependParentProjectKey;
    }

    public boolean isDisableInprogressNotification() {
        return this.disableInprogressNotification;
    }

    @DataBoundSetter
    public void setDisableInprogressNotification(boolean disableInprogressNotification) {
        this.disableInprogressNotification = disableInprogressNotification;
    }

    public boolean isConsiderUnstableAsSuccess() {
        return this.considerUnstableAsSuccess;
    }

    @DataBoundSetter
    public void setConsiderUnstableAsSuccess(boolean considerUnstableAsSuccess) {
        this.considerUnstableAsSuccess = considerUnstableAsSuccess;
    }

    @Inject
    void setHttpNotifierSelector(HttpNotifierSelector httpNotifierSelector) {
        this.httpNotifierSelector = httpNotifierSelector;
    }

    HttpNotifierSelector getHttpNotifierSelector() {
        Jenkins jenkins;
        Injector injector;
        if (this.httpNotifierSelector == null && (injector = (jenkins = Jenkins.get()).getInjector()) != null) {
            injector.injectMembers((Object)this);
        }
        return this.httpNotifierSelector;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return this.disableInprogressNotification || this.processJenkinsEvent((Run<?, ?>)build, null, (TaskListener)listener, StashBuildState.INPROGRESS);
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return this.perform((Run<?, ?>)build, (TaskListener)listener, this.disableInprogressNotification);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull EnvVars env, @NonNull TaskListener listener) {
        if (!this.perform(run, listener, false)) {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean perform(Run<?, ?> run, TaskListener listener, boolean disableInProgress) {
        StashBuildState state;
        PrintStream logger = listener.getLogger();
        Result buildResult = run.getResult();
        if (buildResult == null && disableInProgress) {
            return true;
        }
        if (buildResult == null) {
            state = StashBuildState.INPROGRESS;
        } else if (buildResult == Result.SUCCESS) {
            state = StashBuildState.SUCCESSFUL;
        } else if (buildResult == Result.UNSTABLE && this.considerUnstableAsSuccess) {
            logger.println("UNSTABLE reported to Bitbucket as SUCCESSFUL");
            state = StashBuildState.SUCCESSFUL;
        } else {
            if (buildResult == Result.ABORTED && disableInProgress) {
                logger.println("ABORTED");
                return true;
            }
            if (buildResult.equals(Result.NOT_BUILT)) {
                logger.println("NOT BUILT");
                return true;
            }
            state = StashBuildState.FAILED;
        }
        return this.processJenkinsEvent(run, null, listener, state);
    }

    private String getRootUrl() {
        Jenkins instance = Jenkins.get();
        return instance.getRootUrl() != null ? instance.getRootUrl() : this.globalConfig.getUrl();
    }

    private boolean processJenkinsEvent(Run<?, ?> run, FilePath workspace, TaskListener listener, StashBuildState state) {
        PrintStream logger = listener.getLogger();
        if (this.getRootUrl() == null) {
            logger.println("Cannot notify Bitbucket! (Jenkins Root URL not configured)");
            return true;
        }
        Collection<String> commitSha1s = this.lookupCommitSha1s(run, workspace, listener);
        for (String commitSha1 : commitSha1s) {
            try {
                NotificationResult result = this.notifyStash(logger, run, commitSha1, listener, state);
                if (result.indicatesSuccess) {
                    logger.println("Notified Bitbucket for commit with id " + commitSha1);
                    continue;
                }
                logger.println("Failed to notify Bitbucket for commit " + commitSha1 + " (" + result.message + ")");
            }
            catch (Exception e) {
                logger.println("Caught exception while notifying Bitbucket with id " + commitSha1);
                LOGGER.error("{} failed to notify Bitbucket for {}", new Object[]{StashNotifier.idOf(run), commitSha1, e});
            }
        }
        if (commitSha1s.isEmpty()) {
            logger.println("found no commit info");
        }
        return true;
    }

    protected Collection<String> lookupCommitSha1s(Run run, FilePath workspace, TaskListener listener) {
        if (this.commitSha1 != null && this.commitSha1.trim().length() > 0) {
            PrintStream logger = listener.getLogger();
            try {
                if (run instanceof AbstractBuild) {
                    return Collections.singletonList(TokenMacro.expandAll((AbstractBuild)((AbstractBuild)run), (TaskListener)listener, (String)this.commitSha1));
                }
                return Collections.singletonList(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.commitSha1));
            }
            catch (IOException | InterruptedException | MacroEvaluationException e) {
                logger.println("Unable to expand commit SHA value");
                LOGGER.error("{} unable to expand commit SHA value", (Object)StashNotifier.idOf(run), (Object)e);
                return Collections.emptyList();
            }
        }
        HashSet<String> sha1s = new HashSet<String>();
        for (BuildData buildData : run.getActions(BuildData.class)) {
            String markedSha1;
            Revision lastBuiltRevision = buildData.getLastBuiltRevision();
            if (lastBuiltRevision == null) continue;
            String lastBuiltSha1 = lastBuiltRevision.getSha1String();
            if (!lastBuiltSha1.isEmpty()) {
                sha1s.add(lastBuiltSha1);
            }
            if ((markedSha1 = buildData.lastBuild.getMarked().getSha1String()).isEmpty()) continue;
            sha1s.add(markedSha1);
        }
        return sha1s;
    }

    @Deprecated
    protected CloseableHttpClient getHttpClient(PrintStream logger, Run<?, ?> run, String stashServer) throws Exception {
        boolean ignoreUnverifiedSSL;
        DescriptorImpl globalSettings = this.getDescriptor();
        int timeoutInMilliseconds = 60000;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).setCookieSpec("standard");
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setDefaultRequestConfig(requestBuilder.build());
        URL url = new URL(stashServer);
        boolean bl = ignoreUnverifiedSSL = this.ignoreUnverifiedSSLPeer || globalSettings.isIgnoreUnverifiedSsl();
        if (url.getProtocol().equals("https") && ignoreUnverifiedSSL) {
            try {
                SSLContext sslContext = this.buildSslContext(ignoreUnverifiedSSL, null);
                SSLConnectionSocketFactory sslConnSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnSocketFactory);
                Registry registry = RegistryBuilder.create().register("https", (Object)sslConnSocketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
                BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
                clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            }
            catch (NoSuchAlgorithmException nsae) {
                logger.println("Could not establish SSL context");
                LOGGER.error("{} could not establish SSL context", (Object)StashNotifier.idOf(run), (Object)nsae);
            }
            catch (KeyManagementException | KeyStoreException e) {
                logger.println("Could not initialize SSL context");
                LOGGER.error("{} could not initialize SSL context", (Object)StashNotifier.idOf(run), (Object)e);
            }
        }
        this.configureProxy(clientBuilder, url);
        return clientBuilder.build();
    }

    @Deprecated
    private SSLContext buildSslContext(boolean ignoreUnverifiedSSL, Credentials credentials) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder contextBuilder = SSLContexts.custom();
        contextBuilder.setProtocol("TLS");
        if (credentials instanceof CertificateCredentials) {
            contextBuilder.loadKeyMaterial(((CertificateCredentials)credentials).getKeyStore(), ((CertificateCredentials)credentials).getPassword().getPlainText().toCharArray());
        }
        if (ignoreUnverifiedSSL) {
            contextBuilder.loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE);
        }
        return contextBuilder.build();
    }

    @Deprecated
    private void configureProxy(HttpClientBuilder builder, URL url) {
        Jenkins jenkins = Jenkins.get();
        ProxyConfiguration proxyConfig = jenkins.proxy;
        if (proxyConfig == null) {
            return;
        }
        Proxy proxy = proxyConfig.createProxy(url.getHost());
        if (proxy == null || proxy.type() != Proxy.Type.HTTP) {
            return;
        }
        SocketAddress addr = proxy.address();
        if (!(addr instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress proxyAddr = (InetSocketAddress)addr;
        HttpHost proxyHost = new HttpHost(proxyAddr.getAddress().getHostAddress(), proxyAddr.getPort());
        builder.setProxy(proxyHost);
        String proxyUser = proxyConfig.getUserName();
        if (proxyUser != null) {
            String proxyPass = proxyConfig.getPassword();
            BasicCredentialsProvider cred = new BasicCredentialsProvider();
            cred.setCredentials(new AuthScope(proxyHost), (org.apache.http.auth.Credentials)new org.apache.http.auth.UsernamePasswordCredentials(proxyUser, proxyPass));
            builder.setDefaultCredentialsProvider((org.apache.http.client.CredentialsProvider)cred).setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected NotificationResult notifyStash(PrintStream logger, Run<?, ?> run, String commitSha1, TaskListener listener, StashBuildState state) {
        StashBuildState buildStatus = this.getPushedBuildStatus(state);
        JSONObject payload = this.createNotificationPayload(run, buildStatus, listener);
        String stashURL = this.expandStashURL(run, listener);
        logger.println("Notifying Bitbucket at \"" + stashURL + "\"");
        UsernamePasswordCredentials usernamePasswordCredentials = this.getCredentials(UsernamePasswordCredentials.class, (Item)run.getParent());
        StringCredentials stringCredentials = this.getCredentials(StringCredentials.class, (Item)run.getParent());
        URI uri = BuildStatusUriFactory.create(stashURL, commitSha1);
        NotificationSettings settings = new NotificationSettings(this.ignoreUnverifiedSSLPeer || this.getDescriptor().isIgnoreUnverifiedSsl(), (Credentials)(stringCredentials != null ? stringCredentials : usernamePasswordCredentials));
        NotificationContext context = new NotificationContext(logger, run.getExternalizableId());
        HttpNotifier notifier = this.getHttpNotifierSelector().select(new SelectionContext(run.getParent().getFullName()));
        return notifier.send(uri, payload, settings, context);
    }

    private <T extends Credentials> T getCredentials(Class<T> clazz, Item project) {
        Credentials credentials = null;
        if (clazz == CertificateCredentials.class) {
            return null;
        }
        String credentialsId = this.getCredentialsId();
        if (StringUtils.isNotBlank((String)credentialsId) && clazz != null && project != null) {
            credentials = CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(clazz, (Item)project, (Authentication)ACL.SYSTEM, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }
        if (credentials == null) {
            DescriptorImpl descriptor = this.getDescriptor();
            if (StringUtils.isBlank((String)credentialsId) && descriptor != null) {
                credentialsId = descriptor.getCredentialsId();
            }
            if (StringUtils.isNotBlank((String)credentialsId) && clazz != null && project != null) {
                credentials = CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(clazz, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            }
        }
        return (T)credentials;
    }

    protected StashBuildState getPushedBuildStatus(StashBuildState currentBuildStatus) {
        if (this.buildStatus != null) {
            return this.buildStatus;
        }
        return currentBuildStatus;
    }

    protected HttpPost createRequest(HttpEntity stashBuildNotificationEntity, Item project, String commitSha1, String url) throws AuthenticationException {
        HttpPost req = new HttpPost(url + "/rest/build-status/1.0/commits/" + commitSha1);
        UsernamePasswordCredentials usernamePasswordCredentials = this.getCredentials(UsernamePasswordCredentials.class, project);
        if (usernamePasswordCredentials != null) {
            req.addHeader(new BasicScheme().authenticate((org.apache.http.auth.Credentials)new org.apache.http.auth.UsernamePasswordCredentials(usernamePasswordCredentials.getUsername(), usernamePasswordCredentials.getPassword().getPlainText()), (HttpRequest)req, null));
        }
        req.addHeader("Content-Type", "application/json");
        req.setEntity(stashBuildNotificationEntity);
        return req;
    }

    private String expandStashURL(Run<?, ?> run, TaskListener listener) {
        String url = this.stashServerBaseUrl;
        DescriptorImpl descriptor = this.getDescriptor();
        if (url == null || url.isEmpty()) {
            url = descriptor.getStashRootUrl();
        }
        try {
            url = !(run instanceof AbstractBuild) ? TokenMacro.expandAll(run, (FilePath)new FilePath(run.getRootDir()), (TaskListener)listener, (String)url) : TokenMacro.expandAll((AbstractBuild)((AbstractBuild)run), (TaskListener)listener, (String)url);
        }
        catch (IOException | InterruptedException | MacroEvaluationException ex) {
            PrintStream logger = listener.getLogger();
            logger.println("Unable to expand Bitbucket server URL");
            LOGGER.error("{} unable to expand Bitbucket server URL", (Object)StashNotifier.idOf(run), (Object)ex);
        }
        return url;
    }

    @Deprecated
    private HttpEntity newStashBuildNotificationEntity(Run<?, ?> run, StashBuildState state, TaskListener listener) {
        JSONObject json = this.createNotificationPayload(run, state, listener);
        return new StringEntity(json.toString(), "UTF-8");
    }

    private JSONObject createNotificationPayload(Run<?, ?> run, StashBuildState state, TaskListener listener) {
        JSONObject json = new JSONObject();
        json.put("state", (Object)state.name());
        json.put("key", (Object)StashNotifier.abbreviate(this.getBuildKey(run, listener), 255));
        json.put("name", (Object)StashNotifier.abbreviate(this.getBuildName(run), 255));
        json.put("description", (Object)StashNotifier.abbreviate(this.getBuildDescription(run, state), 255));
        json.put("url", (Object)StashNotifier.abbreviate(this.getBuildUrl(run), 450));
        return json;
    }

    private static String abbreviate(String text, int maxWidth) {
        if (text == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (text.length() <= maxWidth) {
            return text;
        }
        return text.substring(0, maxWidth - 3) + "...";
    }

    private String getDefaultBuildKey(Run<?, ?> run) {
        StringBuilder key = new StringBuilder();
        key.append(run.getParent().getName());
        if (this.includeBuildNumberInKey || this.getDescriptor().isIncludeBuildNumberInKey()) {
            key.append('-').append(run.getNumber());
        }
        key.append('-').append(this.getRootUrl());
        if (this.buildName != null && this.buildName.trim().length() > 0) {
            key.append('-').append(this.buildName);
        }
        return key.toString();
    }

    protected String getBuildKey(Run<?, ?> run, TaskListener listener) {
        StringBuilder key;
        block6: {
            key = new StringBuilder();
            if ((this.prependParentProjectKey || this.getDescriptor().isPrependParentProjectKey()) && null != run.getParent().getParent()) {
                key.append(run.getParent().getParent().getFullName()).append('-');
            }
            if (this.projectKey != null && this.projectKey.trim().length() > 0) {
                PrintStream logger = listener.getLogger();
                try {
                    if (!(run instanceof AbstractBuild)) {
                        key.append(TokenMacro.expandAll(run, (FilePath)new FilePath(run.getRootDir()), (TaskListener)listener, (String)this.projectKey));
                        break block6;
                    }
                    key.append(TokenMacro.expandAll((AbstractBuild)((AbstractBuild)run), (TaskListener)listener, (String)this.projectKey));
                }
                catch (IOException | InterruptedException | MacroEvaluationException ioe) {
                    logger.println("Cannot expand build key from parameter. Processing with default build key");
                    LOGGER.error("{} cannot expand build key from parameter - using default", (Object)StashNotifier.idOf(run), (Object)ioe);
                    key.append(this.getDefaultBuildKey(run));
                }
            } else {
                key.append(this.getDefaultBuildKey(run));
            }
        }
        return StringEscapeUtils.escapeJavaScript((String)key.toString());
    }

    private static String idOf(Run<?, ?> run) {
        return run != null ? run.getExternalizableId() : "(absent run)";
    }

    protected String getBuildName(Run<?, ?> run) {
        if (this.buildName != null && this.buildName.trim().length() > 0) {
            return this.buildName;
        }
        return run.getFullDisplayName();
    }

    protected String getBuildUrl(Run<?, ?> run) {
        if (this.buildUrl != null && !this.buildUrl.trim().isEmpty()) {
            return this.buildUrl;
        }
        return DisplayURLProvider.get().getRunURL(run);
    }

    protected String getBuildDescription(Run<?, ?> run, StashBuildState state) {
        String runDescription = run.getDescription();
        if (runDescription != null && runDescription.trim().length() > 0) {
            return runDescription;
        }
        switch (state) {
            case INPROGRESS: {
                return "building on Jenkins @ " + this.getRootUrl();
            }
        }
        return "built by Jenkins @ " + this.getRootUrl();
    }

    @Symbol(value={"notifyBitbucket", "notifyStash"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private boolean considerUnstableAsSuccess;
        private String credentialsId;
        private boolean disableInprogressNotification;
        private boolean ignoreUnverifiedSsl;
        private boolean includeBuildNumberInKey;
        private boolean prependParentProjectKey;
        private String stashRootUrl;

        public DescriptorImpl() {
            this(true);
        }

        protected DescriptorImpl(boolean load) {
            if (load) {
                this.load();
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            Jenkins accessControlled;
            StandardListBoxModel result = new StandardListBoxModel();
            Object object = accessControlled = project == null ? Jenkins.get() : project;
            if (!accessControlled.hasPermission(Item.CONFIGURE)) {
                return result.includeCurrentValue(credentialsId);
            }
            if (project != null) {
                return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, project, StandardCredentials.class, Collections.emptyList(), (CredentialsMatcher)new StashCredentialMatcher()).includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, Collections.emptyList(), (CredentialsMatcher)new StashCredentialMatcher()).includeCurrentValue(credentialsId);
        }

        public boolean isConsiderUnstableAsSuccess() {
            return this.considerUnstableAsSuccess;
        }

        @DataBoundSetter
        public void setConsiderUnstableAsSuccess(boolean considerUnstableAsSuccess) {
            this.considerUnstableAsSuccess = considerUnstableAsSuccess;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        @DataBoundSetter
        public void setCredentialsId(String credentialsId) {
            this.credentialsId = StringUtils.trimToNull((String)credentialsId);
        }

        public boolean isDisableInprogressNotification() {
            return this.disableInprogressNotification;
        }

        @DataBoundSetter
        public void setDisableInprogressNotification(boolean disableInprogressNotification) {
            this.disableInprogressNotification = disableInprogressNotification;
        }

        public boolean isIgnoreUnverifiedSsl() {
            return this.ignoreUnverifiedSsl;
        }

        @DataBoundSetter
        public void setIgnoreUnverifiedSsl(boolean ignoreUnverifiedSsl) {
            this.ignoreUnverifiedSsl = ignoreUnverifiedSsl;
        }

        public boolean isIncludeBuildNumberInKey() {
            return this.includeBuildNumberInKey;
        }

        @DataBoundSetter
        public void setIncludeBuildNumberInKey(boolean includeBuildNumberInKey) {
            this.includeBuildNumberInKey = includeBuildNumberInKey;
        }

        public boolean isPrependParentProjectKey() {
            return this.prependParentProjectKey;
        }

        @DataBoundSetter
        public void setPrependParentProjectKey(boolean prependParentProjectKey) {
            this.prependParentProjectKey = prependParentProjectKey;
        }

        public String getStashRootUrl() {
            return this.stashRootUrl;
        }

        @DataBoundSetter
        public void setStashRootUrl(String stashRootUrl) {
            this.stashRootUrl = StringUtils.trimToNull((String)stashRootUrl);
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String value, @AncestorInPath Item project) {
            if (project != null && StringUtils.isBlank((String)value) && StringUtils.isBlank((String)this.credentialsId)) {
                return FormValidation.error((String)"Please specify the credentials to use");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStashServerBaseUrl(@QueryParameter String value) {
            String url = value;
            if (url != null && !url.trim().isEmpty()) {
                url = url.trim();
            } else {
                String string = url = this.stashRootUrl != null ? this.stashRootUrl.trim() : null;
            }
            if (url == null || url.isEmpty()) {
                return FormValidation.error((String)"Please specify a valid URL here or in the global configuration");
            }
            try {
                new URL(url);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)"Please specify a valid URL here or in the global configuration!");
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Notify Bitbucket Instance";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.considerUnstableAsSuccess = false;
            this.credentialsId = null;
            this.disableInprogressNotification = false;
            this.ignoreUnverifiedSsl = false;
            this.includeBuildNumberInKey = false;
            this.prependParentProjectKey = false;
            this.stashRootUrl = null;
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }
    }
}

