/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="resolve-test-dependencies", requiresDependencyResolution=ResolutionScope.TEST)
@SuppressFBWarnings(value={"REDOS"}, justification="trusted code")
public class TestDependencyMojo
extends AbstractHpiMojo {
    private static final Pattern CORE_REGEX = Pattern.compile("WEB-INF/lib/jenkins-core-([0-9.]+(?:-[0-9a-f.]+)*(?:-(?i)([a-z]+)(-)?([0-9a-f.]+)?)?(?:-(?i)([a-z]+)(-)?([0-9a-f_.]+)?)?(?:-SNAPSHOT)?)[.]jar");
    private static final Pattern PLUGIN_REGEX = Pattern.compile("WEB-INF/plugins/([^/.]+)[.][hj]pi");
    private static final Pattern OVERRIDE_REGEX = Pattern.compile("([^:]+:[^:]+):([^:]+)");
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Parameter(property="overrideVersions")
    private List<String> overrideVersions;
    @Parameter(property="overrideWar")
    private File overrideWar;
    @Parameter(property="useUpperBounds")
    private boolean useUpperBounds;
    @Parameter(property="upperBoundsExcludes")
    private List<String> upperBoundsExcludes;
    private RequireUpperBoundDepsVisitor upperBoundDepsVisitor;

    public void execute() throws MojoExecutionException {
        Set<MavenArtifact> effectiveArtifacts;
        Map<String, String> bundledPlugins;
        Map<String, String> overrides;
        Map<String, String> map = overrides = this.overrideVersions != null ? TestDependencyMojo.parseOverrides(this.overrideVersions) : Map.of();
        if (!overrides.isEmpty()) {
            this.getLog().info((CharSequence)String.format("Applying %d overrides.", overrides.size()));
        }
        if (overrides.containsKey(String.format("%s:%s", this.project.getGroupId(), this.project.getArtifactId()))) {
            throw new MojoExecutionException("Cannot override self");
        }
        Map<String, String> map2 = bundledPlugins = this.overrideWar != null ? this.scanWar(this.overrideWar) : Map.of();
        if (!bundledPlugins.isEmpty()) {
            this.getLog().info((CharSequence)String.format("Scanned contents of %s with %d bundled plugins", this.overrideWar, bundledPlugins.size()));
        }
        HashSet intersection = new HashSet(bundledPlugins.keySet());
        intersection.retainAll(overrides.keySet());
        for (String override : intersection) {
            if (((String)bundledPlugins.get(override)).equals(overrides.get(override))) {
                overrides.remove(override);
                continue;
            }
            throw new MojoExecutionException(String.format("Failed to override %s: conflict between %s in overrideVersions and %s in overrideWar", override, overrides.get(override), bundledPlugins.get(override)));
        }
        HashMap<String, String> additions = new HashMap<String, String>();
        HashMap<String, String> deletions = new HashMap<String, String>();
        HashMap<String, String> updates = new HashMap<String, String>();
        if (overrides.isEmpty() && this.overrideWar == null) {
            effectiveArtifacts = this.getProjectArtfacts();
        } else {
            Iterator<Object> node;
            for (String goal : this.session.getGoals()) {
                if (!goal.contains("deploy")) continue;
                throw new MojoExecutionException("Cannot override dependencies when doing a release");
            }
            MavenProject shadow = this.project.clone();
            HashMap<String, String> originalResolution = new HashMap<String, String>();
            for (Artifact artifact : shadow.getArtifacts()) {
                originalResolution.put(TestDependencyMojo.toKey(artifact), artifact.getVersion());
            }
            TestDependencyMojo.applyOverrides(overrides, bundledPlugins, false, shadow, this.getLog());
            if (this.useUpperBounds) {
                boolean converged = false;
                int i = 0;
                Map<String, String> upperBounds = null;
                while (!converged) {
                    if (i++ > 10) {
                        throw new MojoExecutionException("Failed to iterate to convergence during upper bounds analysis: " + String.valueOf(upperBounds));
                    }
                    try {
                        RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
                        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
                        List dependencies = shadow.getDependencies().stream().filter(d -> !d.isOptional()).filter(d -> !List.of("test", "provided").contains(d.getScope())).map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
                        List managedDependencies = Optional.ofNullable(shadow.getDependencyManagement()).map(DependencyManagement::getDependencies).map(list -> list.stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList())).orElse(null);
                        CollectRequest collectRequest = new CollectRequest(dependencies, managedDependencies, shadow.getRemoteProjectRepositories());
                        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)shadow.getArtifact()));
                        node = this.repositorySystem.collectDependencies(repositorySystemSession, collectRequest).getRoot();
                    }
                    catch (DependencyCollectionException dependencyCollectionException) {
                        throw new MojoExecutionException("Failed to analyze dependency tree for useUpperBounds", (Exception)((Object)dependencyCollectionException));
                    }
                    this.upperBoundDepsVisitor = new RequireUpperBoundDepsVisitor();
                    node.accept(this.upperBoundDepsVisitor);
                    String string = String.format("%s:%s", shadow.getGroupId(), shadow.getArtifactId());
                    upperBounds = this.upperBoundDepsVisitor.upperBounds(this.upperBoundsExcludes, string);
                    if (upperBounds.isEmpty()) {
                        converged = true;
                        continue;
                    }
                    Set<Artifact> resolved = this.resolveDependencies(shadow);
                    shadow.setArtifacts(resolved);
                    TestDependencyMojo.applyOverrides(upperBounds, Map.of(), true, shadow, this.getLog());
                }
            } else if (!this.upperBoundsExcludes.isEmpty()) {
                throw new MojoExecutionException("Cannot provide upper bounds excludes when not using upper bounds");
            }
            Set<Artifact> resolved = this.resolveDependencies(shadow);
            HashMap<String, String> newResolution = new HashMap<String, String>();
            HashSet<Artifact> self = new HashSet<Artifact>();
            node = resolved.iterator();
            while (node.hasNext()) {
                Artifact artifact = (Artifact)node.next();
                if (artifact.getGroupId().equals(this.project.getGroupId()) && artifact.getArtifactId().equals(this.project.getArtifactId())) {
                    self.add(artifact);
                    continue;
                }
                newResolution.put(TestDependencyMojo.toKey(artifact), artifact.getVersion());
            }
            resolved.removeAll(self);
            effectiveArtifacts = this.wrap(new Artifacts((Collection<? extends Artifact>)resolved));
            for (Map.Entry entry : newResolution.entrySet()) {
                if (originalResolution.containsKey(entry.getKey())) {
                    String originalVersion = (String)originalResolution.get(entry.getKey());
                    String newVersion = (String)entry.getValue();
                    if (newVersion.equals(originalVersion)) continue;
                    updates.put((String)entry.getKey(), newVersion);
                    continue;
                }
                additions.put((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : originalResolution.entrySet()) {
                if (newResolution.containsKey(entry.getKey())) continue;
                deletions.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.getLog().info((CharSequence)("After resolving, additions: " + String.valueOf(additions)));
            this.getLog().info((CharSequence)("After resolving, deletions: " + String.valueOf(deletions)));
            this.getLog().info((CharSequence)("After resolving, updates: " + String.valueOf(updates)));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"New dependency tree:");
                MavenSession shadowSession = this.session.clone();
                shadowSession.setCurrentProject(shadow);
                shadow.setArtifacts((Set)resolved);
                MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin")), (String)MojoExecutor.goal((String)"tree"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"scope"), (String)"test")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)shadow, (MavenSession)shadowSession, (BuildPluginManager)this.pluginManager));
            }
        }
        this.copyTestDependencies(effectiveArtifacts);
        if (!(additions.isEmpty() && deletions.isEmpty() && updates.isEmpty())) {
            LinkedList<String> additionalClasspathElements = new LinkedList<String>();
            TreeMap<String, String> includes = new TreeMap<String, String>();
            includes.putAll(additions);
            includes.putAll(updates);
            for (Map.Entry entry : includes.entrySet()) {
                String key = (String)entry.getKey();
                String[] groupArt = key.split(":");
                String string = groupArt[0];
                String artifactId = groupArt[1];
                String version = (String)entry.getValue();
                boolean found = false;
                for (MavenArtifact a : effectiveArtifacts) {
                    if (!a.getGroupId().equals(string) || !a.getArtifactId().equals(artifactId)) continue;
                    if (!a.getVersion().equals(version)) {
                        throw new AssertionError((Object)"should never happen");
                    }
                    found = true;
                    if (!a.getArtifactHandler().isAddedToClasspath()) continue;
                    additionalClasspathElements.add(a.getFile().getAbsolutePath());
                }
                if (found) continue;
                throw new MojoExecutionException("could not find dependency " + key);
            }
            TreeSet<String> classpathDependencyExcludes = new TreeSet<String>();
            classpathDependencyExcludes.addAll(deletions.keySet());
            classpathDependencyExcludes.addAll(updates.keySet());
            Properties properties = this.project.getProperties();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Replacing POM-defined classpath elements %s with %s", classpathDependencyExcludes, additionalClasspathElements));
            }
            TestDependencyMojo.appendEntries("maven.test.additionalClasspath", additionalClasspathElements, properties);
            TestDependencyMojo.appendEntries("maven.test.dependency.excludes", classpathDependencyExcludes, properties);
        }
    }

    private void copyTestDependencies(Set<MavenArtifact> mavenArtifacts) throws MojoExecutionException {
        List artifactResults;
        ArtifactRequest artifactRequest;
        File testDir = new File(this.project.getBuild().getTestOutputDirectory(), "test-dependencies");
        try {
            Files.createDirectories(testDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(testDir) + "'", (Exception)e);
        }
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        List remoteRepositories = RepositoryUtils.toRepos((List)buildingRequest.getRemoteRepositories());
        ArrayList<ArtifactRequest> artifactRequests = new ArrayList<ArtifactRequest>();
        for (MavenArtifact mavenArtifact : mavenArtifacts) {
            ArtifactDescriptorResult descriptorResult;
            ArtifactDescriptorRequest descriptorRequest;
            String artifactId;
            if (!mavenArtifact.isPlugin(this.getLog())) continue;
            try {
                artifactId = mavenArtifact.getActualArtifactId();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to resolve " + mavenArtifact.getId(), (Exception)e);
            }
            if (artifactId == null) {
                this.getLog().debug((CharSequence)("Skipping null artifactID with classifier " + mavenArtifact.getClassifier()));
                continue;
            }
            try {
                descriptorRequest = new ArtifactDescriptorRequest(RepositoryUtils.toArtifact((Artifact)mavenArtifact.getHpi().artifact), remoteRepositories, null);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to resolve " + mavenArtifact.getId(), (Exception)e);
            }
            try {
                descriptorResult = this.repositorySystem.readArtifactDescriptor(buildingRequest.getRepositorySession(), descriptorRequest);
            }
            catch (ArtifactDescriptorException e) {
                throw new MojoExecutionException("Failed to read artifact descriptor for " + mavenArtifact.getId(), (Exception)((Object)e));
            }
            artifactRequest = new ArtifactRequest(descriptorResult.getArtifact(), remoteRepositories, null);
            artifactRequests.add(artifactRequest);
        }
        try {
            artifactResults = this.repositorySystem.resolveArtifacts(buildingRequest.getRepositorySession(), artifactRequests);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve artifacts: " + artifactRequests.stream().map(ArtifactRequest::getArtifact).map(Object::toString).collect(Collectors.joining(", ")), (Exception)((Object)e));
        }
        artifactRequests = new ArrayList();
        LinkedHashMap<CallSite, Artifact> artifactMap = new LinkedHashMap<CallSite, Artifact>();
        for (ArtifactResult artifactResult : artifactResults) {
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifactResult.getArtifact());
            artifactMap.put((CallSite)((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId())), artifact);
            if (!artifact.getFile().isDirectory()) continue;
            artifactRequest = new ArtifactRequest(RepositoryUtils.toArtifact((Artifact)artifact), remoteRepositories, null);
            artifactRequests.add(artifactRequest);
        }
        if (!artifactRequests.isEmpty() && buildingRequest.getRepositorySession() instanceof DefaultRepositorySystemSession) {
            DefaultRepositorySystemSession oldRepositorySession = (DefaultRepositorySystemSession)buildingRequest.getRepositorySession();
            DefaultRepositorySystemSession newRepositorySession = new DefaultRepositorySystemSession((RepositorySystemSession)oldRepositorySession);
            newRepositorySession.setWorkspaceReader(null);
            newRepositorySession.setReadOnly();
            try {
                artifactResults = this.repositorySystem.resolveArtifacts((RepositorySystemSession)newRepositorySession, artifactRequests);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failed to resolve artifacts: " + artifactRequests.stream().map(ArtifactRequest::getArtifact).map(Object::toString).collect(Collectors.joining(", ")), (Exception)((Object)e));
            }
            for (ArtifactResult artifactResult : artifactResults) {
                Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifactResult.getArtifact());
                artifactMap.put((CallSite)((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId())), artifact);
            }
        }
        try (BufferedWriter w = Files.newBufferedWriter(testDir.toPath().resolve("index"), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Artifact artifact : artifactMap.values()) {
                this.getLog().debug((CharSequence)("Copying " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + " as a test dependency"));
                File dst = new File(testDir, artifact.getArtifactId() + ".hpi");
                FileUtils.copyFile((File)artifact.getFile(), (File)dst);
                w.write(artifact.getArtifactId());
                w.newLine();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy dependency plugins", (Exception)e);
        }
    }

    private static void appendEntries(String property, Collection<String> additions, Properties properties) {
        String existing = properties.getProperty(property);
        ArrayList<String> newEntries = new ArrayList<String>();
        if (existing != null && !existing.isEmpty()) {
            for (String entry : existing.split(",")) {
                if ((entry = entry.trim()).isEmpty()) continue;
                newEntries.add(entry);
            }
        }
        newEntries.addAll(additions);
        properties.setProperty(property, String.join((CharSequence)",", newEntries));
    }

    private Map<String, String> scanWar(File war) throws MojoExecutionException {
        HashMap<String, String> overrides = new HashMap<String, String>();
        try (JarFile jf = new JarFile(war);){
            Enumeration<JarEntry> entries = jf.entries();
            String coreVersion = null;
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                Matcher m = CORE_REGEX.matcher(name);
                if (m.matches()) {
                    if (coreVersion != null) {
                        throw new MojoExecutionException("More than 1 jenkins-core JAR in " + String.valueOf(war));
                    }
                    coreVersion = m.group(1);
                }
                if (!(m = PLUGIN_REGEX.matcher(name)).matches()) continue;
                InputStream is = jf.getInputStream(entry);
                try (JarInputStream jis = new JarInputStream(is);){
                    Manifest manifest = jis.getManifest();
                    String groupId = manifest.getMainAttributes().getValue("Group-Id");
                    if (groupId == null) {
                        throw new IllegalArgumentException("Failed to determine group ID for " + name);
                    }
                    String artifactId = manifest.getMainAttributes().getValue("Short-Name");
                    if (artifactId == null) {
                        throw new IllegalArgumentException("Failed to determine artifact ID for " + name);
                    }
                    String version = manifest.getMainAttributes().getValue("Plugin-Version");
                    if (version == null) {
                        throw new IllegalArgumentException("Failed to determine version for " + name);
                    }
                    if ((version = version.replaceFirst(" [(].+[)]$", "")).endsWith("-SNAPSHOT")) {
                        this.getLog().warn((CharSequence)("WAR contains a SNAPSHOT of " + groupId + ":" + artifactId + "; build will not be fully repeatable"));
                    }
                    String key = String.format("%s:%s", groupId, artifactId);
                    String self = String.format("%s:%s", this.project.getGroupId(), this.project.getArtifactId());
                    if (key.equals(self)) continue;
                    overrides.put(key, version);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if (coreVersion == null) {
                throw new MojoExecutionException("no jenkins-core.jar in " + String.valueOf(war));
            }
            String jenkinsVersion = this.session.getSystemProperties().getProperty("jenkins.version");
            if (jenkinsVersion == null) {
                jenkinsVersion = this.project.getProperties().getProperty("jenkins.version");
            }
            if (jenkinsVersion == null) {
                throw new MojoExecutionException("jenkins.version must be set when using overrideWar");
            }
            if (!jenkinsVersion.equals(coreVersion)) {
                throw new MojoExecutionException("jenkins.version must match the version specified by overrideWar: " + coreVersion);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to scan " + String.valueOf(war), (Exception)e);
        }
        return overrides;
    }

    private static Map<String, String> parseOverrides(List<String> overrideVersions) throws MojoExecutionException {
        HashMap<String, String> overrides = new HashMap<String, String>();
        for (String override : overrideVersions) {
            Matcher m = OVERRIDE_REGEX.matcher(override);
            if (!m.matches()) {
                throw new MojoExecutionException("illegal override: " + override);
            }
            overrides.put(m.group(1), m.group(2));
        }
        return overrides;
    }

    private static void applyOverrides(Map<String, String> overrides, Map<String, String> bundledPlugins, boolean upperBounds, MavenProject project, Log log) throws MojoExecutionException {
        Iterator key;
        HashSet<Object> appliedOverrides = new HashSet<Object>();
        HashSet<Object> appliedBundledPlugins = new HashSet<Object>();
        for (Dependency dependency : project.getDependencies()) {
            key = TestDependencyMojo.toKey(dependency);
            if (TestDependencyMojo.updateDependency(dependency, overrides, "direct dependency", log)) {
                appliedOverrides.add(key);
            }
            if (!TestDependencyMojo.updateDependency(dependency, bundledPlugins, "direct dependency", log)) continue;
            appliedBundledPlugins.add(key);
        }
        if (project.getDependencyManagement() != null) {
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                key = TestDependencyMojo.toKey(dependency);
                if (TestDependencyMojo.updateDependency(dependency, overrides, "dependency management entry", log)) {
                    appliedOverrides.add(key);
                }
                if (!TestDependencyMojo.updateDependency(dependency, bundledPlugins, "dependency management entry", log)) continue;
                appliedBundledPlugins.add(key);
            }
        }
        HashSet<String> unappliedOverrides = new HashSet<String>(overrides.keySet());
        unappliedOverrides.removeAll(appliedOverrides);
        HashSet<String> overrideAdditions = new HashSet<String>();
        for (Artifact artifact : project.getArtifacts()) {
            String key2 = TestDependencyMojo.toKey(artifact);
            if (!unappliedOverrides.contains(key2)) continue;
            String version = overrides.get(key2);
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(version);
            dependency.setScope(artifact.getScope());
            dependency.setType(artifact.getType());
            dependency.setClassifier(artifact.getClassifier());
            if (dependency.getGroupId().equals(project.getGroupId()) && dependency.getArtifactId().equals(project.getArtifactId())) {
                throw new MojoExecutionException("Cannot add self to dependency management section");
            }
            DependencyManagement dm = project.getDependencyManagement();
            if (dm == null) {
                throw new MojoExecutionException(String.format("Failed to add dependency management entry %s:%s because the project does not have a dependency management section", key2, version));
            }
            log.info((CharSequence)String.format("Adding dependency management entry %s:%s", key2, dependency.getVersion()));
            dm.addDependency(dependency);
            overrideAdditions.add(key2);
        }
        unappliedOverrides.removeAll(overrideAdditions);
        if (!unappliedOverrides.isEmpty()) {
            if (upperBounds) {
                for (String key3 : unappliedOverrides) {
                    String[] groupArt = key3.split(":");
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(groupArt[0]);
                    dependency.setArtifactId(groupArt[1]);
                    dependency.setVersion(overrides.get(key3));
                    if (dependency.getGroupId().equals(project.getGroupId()) && dependency.getArtifactId().equals(project.getArtifactId())) {
                        throw new MojoExecutionException("Cannot add self to dependency management section");
                    }
                    DependencyManagement dm = project.getDependencyManagement();
                    if (dm == null) {
                        dm = new DependencyManagement();
                        project.getModel().setDependencyManagement(dm);
                    }
                    log.info((CharSequence)String.format("Adding dependency management entry %s:%s", key3, dependency.getVersion()));
                    dm.addDependency(dependency);
                    overrideAdditions.add(key3);
                }
            } else {
                throw new MojoExecutionException("Failed to apply the following overrides: " + String.valueOf(unappliedOverrides));
            }
        }
        HashSet<String> unappliedBundledPlugins = new HashSet<String>(bundledPlugins.keySet());
        unappliedBundledPlugins.removeAll(appliedBundledPlugins);
        for (String key2 : unappliedBundledPlugins) {
            String[] groupArt = key2.split(":");
            String groupId = groupArt[0];
            String artifactId = groupArt[1];
            String version = bundledPlugins.get(key2);
            Dependency dependency = new Dependency();
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
            dependency.setVersion(version);
            if (dependency.getGroupId().equals(project.getGroupId()) && dependency.getArtifactId().equals(project.getArtifactId())) {
                throw new MojoExecutionException("Cannot add self as dependency management entry");
            }
            log.info((CharSequence)String.format("Adding dependency management entry %s:%s", key2, version));
            project.getDependencyManagement().getDependencies().add(dependency);
        }
        log.debug((CharSequence)("adjusted dependencies: " + String.valueOf(project.getDependencies())));
        if (project.getDependencyManagement() != null) {
            log.debug((CharSequence)("adjusted dependency management: " + String.valueOf(project.getDependencyManagement().getDependencies())));
        }
        project.setDependencyArtifacts(null);
        project.setArtifacts(null);
    }

    private static boolean updateDependency(Dependency dependency, Map<String, String> overrides, String type, Log log) {
        String key = TestDependencyMojo.toKey(dependency);
        String overrideVersion = overrides.get(key);
        if (overrideVersion != null) {
            String classifier = dependency.getClassifier();
            log.info((CharSequence)String.format("Updating %s %s%s from %s to %s", type, key, classifier != null ? ":" + classifier : "", dependency.getVersion(), overrideVersion));
            dependency.setVersion(overrideVersion);
            return true;
        }
        return false;
    }

    private Set<Artifact> resolveDependencies(MavenProject project) throws MojoExecutionException {
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, this.session.getRepositorySession());
            DependencyResolutionResult result = this.dependenciesResolver.resolve((DependencyResolutionRequest)request);
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
                RepositoryUtils.toArtifacts(artifacts, (Collection)result.getDependencyGraph().getChildren(), List.of(project.getArtifact().getId()), (DependencyFilter)request.getResolutionFilter());
            }
            return artifacts;
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Unable to resolve dependencies", (Exception)((Object)e));
        }
    }

    private String buildErrorMessage(List<DependencyNode> conflict) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Require upper bound dependencies error for ").append(TestDependencyMojo.getFullArtifactName(conflict.get(0), false)).append(" paths to dependency are:").append(System.lineSeparator());
        if (conflict.size() > 0) {
            errorMessage.append((CharSequence)this.buildTreeString(conflict.get(0)));
        }
        for (DependencyNode node : conflict.subList(1, conflict.size())) {
            errorMessage.append("and").append(System.lineSeparator());
            errorMessage.append((CharSequence)this.buildTreeString(node));
        }
        return errorMessage.toString();
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        DependencyNode currentNode = node;
        while (currentNode != null) {
            StringBuilder line = new StringBuilder(TestDependencyMojo.getFullArtifactName(currentNode, false));
            if (DependencyManagerUtils.getPremanagedVersion((DependencyNode)currentNode) != null) {
                line.append(" (managed) <-- ");
                line.append(TestDependencyMojo.getFullArtifactName(currentNode, true));
            }
            loc.add(line.toString());
            currentNode = this.upperBoundDepsVisitor.getParent(currentNode);
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            builder.append("  ".repeat(i));
            builder.append("+-").append((String)loc.get(i));
            builder.append(System.lineSeparator());
        }
        return builder;
    }

    private static String getFullArtifactName(DependencyNode node, boolean usePremanaged) {
        String scope;
        Artifact artifact = TestDependencyMojo.toArtifact(node);
        String version = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node);
        if (!usePremanaged || version == null) {
            version = artifact.getBaseVersion();
        }
        String result = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + version;
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            result = result + ":" + classifier;
        }
        if ((scope = artifact.getScope()) != null && !"compile".equals(scope)) {
            result = result + " [" + scope + "]";
        }
        return result;
    }

    private static Artifact toArtifact(DependencyNode node) {
        Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)node.getArtifact());
        Optional.ofNullable(node.getDependency()).ifPresent(dependency -> {
            Optional.ofNullable(dependency.getScope()).ifPresent(arg_0 -> ((Artifact)artifact).setScope(arg_0));
            artifact.setOptional(dependency.isOptional());
        });
        return artifact;
    }

    private static String toKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private static String toKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId();
    }

    private class RequireUpperBoundDepsVisitor
    implements DependencyVisitor,
    ParentNodeProvider {
        private final ParentsVisitor parentsVisitor = new ParentsVisitor();
        private final Map<String, List<DependencyNodeHopCountPair>> keyToPairsMap = new HashMap<String, List<DependencyNodeHopCountPair>>();

        private RequireUpperBoundDepsVisitor() {
        }

        public boolean visitEnter(DependencyNode node) {
            this.parentsVisitor.visitEnter(node);
            DependencyNodeHopCountPair pair = new DependencyNodeHopCountPair(node, this);
            String key = pair.constructKey();
            this.keyToPairsMap.computeIfAbsent(key, k1 -> new ArrayList()).add(pair);
            this.keyToPairsMap.get(key).sort(DependencyNodeHopCountPair::compareTo);
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return this.parentsVisitor.visitLeave(node);
        }

        public Map<String, String> upperBounds(List<String> upperBoundsExcludes, String self) {
            HashMap<String, String> r = new HashMap<String, String>();
            for (List<DependencyNodeHopCountPair> pairs : this.keyToPairsMap.values()) {
                DependencyNodeHopCountPair resolvedPair = pairs.get(0);
                ArtifactVersion resolvedVersion = resolvedPair.extractArtifactVersion(false);
                for (DependencyNodeHopCountPair pair : pairs) {
                    Artifact artifact;
                    String key;
                    ArtifactVersion version = pair.extractArtifactVersion(true);
                    if (resolvedVersion.compareTo((Object)version) >= 0 || (key = TestDependencyMojo.toKey(artifact = TestDependencyMojo.toArtifact(resolvedPair.node))).equals(self) || r.containsKey(key) && new ComparableVersion(version.toString()).compareTo(new ComparableVersion((String)r.get(key))) <= 1) continue;
                    if (upperBoundsExcludes.contains(key)) {
                        TestDependencyMojo.this.getLog().info((CharSequence)("Ignoring requireUpperBoundDeps in " + key));
                        continue;
                    }
                    TestDependencyMojo.this.getLog().info((CharSequence)TestDependencyMojo.this.buildErrorMessage(pairs.stream().map(DependencyNodeHopCountPair::getNode).collect(Collectors.toList())).trim());
                    TestDependencyMojo.this.getLog().info((CharSequence)String.format("for %s, upper bounds forces an upgrade from %s to %s", key, resolvedVersion, version));
                    r.put(key, version.toString());
                }
            }
            return r;
        }

        @Override
        public DependencyNode getParent(DependencyNode node) {
            return this.parentsVisitor.getParent(node);
        }
    }

    private static class ParentsVisitor
    implements DependencyVisitor,
    ParentNodeProvider {
        private final Map<DependencyNode, DependencyNode> parents = new HashMap<DependencyNode, DependencyNode>();
        private final Stack<DependencyNode> parentStack = new Stack();

        private ParentsVisitor() {
        }

        @Override
        public DependencyNode getParent(DependencyNode node) {
            return this.parents.get(node);
        }

        public boolean visitEnter(DependencyNode node) {
            this.parents.put(node, this.parentStack.isEmpty() ? null : this.parentStack.peek());
            this.parentStack.push(node);
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.parentStack.pop();
            return true;
        }
    }

    private static interface ParentNodeProvider {
        public DependencyNode getParent(DependencyNode var1);
    }

    private static class DependencyNodeHopCountPair
    implements Comparable<DependencyNodeHopCountPair> {
        private final DependencyNode node;
        private int hopCount;
        private final ParentNodeProvider parentNodeProvider;

        private DependencyNodeHopCountPair(DependencyNode node, ParentNodeProvider parentNodeProvider) {
            this.parentNodeProvider = parentNodeProvider;
            this.node = node;
            this.countHops();
        }

        private void countHops() {
            this.hopCount = 0;
            DependencyNode parent = this.parentNodeProvider.getParent(this.node);
            while (parent != null) {
                ++this.hopCount;
                parent = this.parentNodeProvider.getParent(parent);
            }
        }

        private String constructKey() {
            Artifact artifact = TestDependencyMojo.toArtifact(this.node);
            return TestDependencyMojo.toKey(artifact);
        }

        public DependencyNode getNode() {
            return this.node;
        }

        private ArtifactVersion extractArtifactVersion(boolean usePremanagedVersion) {
            if (usePremanagedVersion && DependencyManagerUtils.getPremanagedVersion((DependencyNode)this.node) != null) {
                return new DefaultArtifactVersion(DependencyManagerUtils.getPremanagedVersion((DependencyNode)this.node));
            }
            Artifact artifact = TestDependencyMojo.toArtifact(this.node);
            String version = artifact.getBaseVersion();
            if (version != null) {
                return new DefaultArtifactVersion(version);
            }
            try {
                return artifact.getSelectedVersion();
            }
            catch (OverConstrainedVersionException e) {
                throw new RuntimeException("Version ranges problem with " + String.valueOf(this.node.getArtifact()), e);
            }
        }

        public int getHopCount() {
            return this.hopCount;
        }

        @Override
        public int compareTo(DependencyNodeHopCountPair other) {
            return Integer.compare(this.hopCount, other.getHopCount());
        }
    }
}

