/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.util.ListBoxModel;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.utils.Comparator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class BranchConditional
extends DeclarativeStageConditional<BranchConditional> {
    @Deprecated
    private transient String compare;
    private String pattern;
    private String comparator;

    @DataBoundConstructor
    public BranchConditional(String pattern) {
        this.pattern = pattern;
    }

    @Deprecated
    public String getCompare() {
        return this.compare;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected Object readResolve() throws IOException {
        if (this.compare != null) {
            this.pattern = this.compare;
        }
        return this;
    }

    public String getComparator() {
        return this.comparator;
    }

    @DataBoundSetter
    public void setComparator(String comparator) {
        Comparator c = Comparator.get(comparator, null);
        this.comparator = c != null ? c.name() : null;
    }

    public boolean branchMatches(String toCompare, String actualBranch) {
        if (StringUtils.isEmpty((CharSequence)actualBranch) && StringUtils.isEmpty((CharSequence)toCompare)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)actualBranch) || StringUtils.isEmpty((CharSequence)toCompare)) {
            return false;
        }
        Comparator c = Comparator.get(this.comparator, Comparator.GLOB);
        return c.compare(toCompare, actualBranch);
    }

    @Extension
    @Symbol(value={"branch"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<BranchConditional> {
        @NonNull
        public String getDisplayName() {
            return "Execute the stage if the current branch matches a pattern";
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }

        public ListBoxModel doFillComparatorItems() {
            return Comparator.getSelectOptions(true, Comparator.GLOB);
        }
    }
}

