/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.ListBoxModel;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.Messages;
import org.jvnet.localizer.Localizable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Comparator {
    GLOB(Messages._Comparator_GLOB_DisplayName()){

        @Override
        public boolean compare(@NonNull String pattern, String actual) {
            return this.compare(pattern, actual, false);
        }

        @Override
        public boolean compare(@NonNull String pattern, String actual, boolean caseSensitive) {
            actual = (String)StringUtils.defaultIfBlank((CharSequence)actual, (CharSequence)"");
            String safeCompare = pattern.replace('/', File.separatorChar);
            String safeName = actual.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeCompare, (String)safeName, (boolean)caseSensitive);
        }
    }
    ,
    REGEXP(Messages._Comparator_REGEXP_DisplayName()){

        @Override
        public boolean compare(@NonNull String pattern, String actual) {
            actual = (String)StringUtils.defaultIfBlank((CharSequence)actual, (CharSequence)"");
            return actual.matches(pattern);
        }

        @Override
        public boolean compare(@NonNull String pattern, String actual, boolean caseSensitive) {
            return this.compare(pattern, actual);
        }
    }
    ,
    EQUALS(Messages._Comparator_EQUALS_DisplayName()){

        @Override
        public boolean compare(@NonNull String pattern, String actual) {
            actual = (String)StringUtils.defaultIfBlank((CharSequence)actual, (CharSequence)"");
            return actual.equals(pattern);
        }

        @Override
        public boolean compare(@NonNull String pattern, String actual, boolean caseSensitive) {
            return this.compare(pattern, actual);
        }
    };

    private final Localizable displayName;

    private Comparator(Localizable displayName) {
        this.displayName = displayName;
    }

    public Localizable getDisplayName() {
        return this.displayName;
    }

    public abstract boolean compare(String var1, String var2, boolean var3);

    public abstract boolean compare(String var1, String var2);

    public static Comparator get(String name, Comparator defaultValue) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return defaultValue;
        }
        for (Comparator comparator : Comparator.values()) {
            if (!name.equalsIgnoreCase(comparator.name())) continue;
            return comparator;
        }
        return defaultValue;
    }

    public static ListBoxModel getSelectOptions(boolean emptySelection, Comparator top) {
        ListBoxModel model = new ListBoxModel();
        if (emptySelection) {
            model.add("");
        }
        if (top != null) {
            model.add(top.getDisplayName().toString(), top.name());
        }
        for (Comparator comparator : Comparator.values()) {
            if (comparator == top) continue;
            model.add(comparator.getDisplayName().toString(), comparator.name());
        }
        return model;
    }
}

