/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.scripting.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.templates.standard.ScriptTemplateWithArgs;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.KotlinType;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptCompilationKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptEvaluationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.SourceCode;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptCompilationConfigurationFromLegacyTemplate;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptEvaluationConfigurationFromHostConfiguration;
import org.jetbrains.kotlin.buildtools.internal.scripting.host.ConfigurationFromTemplateKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.host.ScriptingHostConfiguration;
import org.jetbrains.kotlin.buildtools.internal.scripting.jvm.JvmScriptingHostConfigurationKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\b&\u0018\u0000 A2\u00020\u0001:\u0005=>?@AB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J\n\u0010<\u001a\u00020\u0015H\u0096\u0080\u0004R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0012\u0010\u001c\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0014\u0010$\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010%R\u0014\u0010.\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010%R\u0012\u00100\u001a\u000201X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020\u001505X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020\u001509X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition;", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/UserDataHolderBase;", "<init>", "()V", "hostConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/ScriptingHostConfiguration;", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "compilationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptCompilationConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "evaluationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptEvaluationConfiguration;", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "isScript", "", "script", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/SourceCode;", "fileExtension", "", "getFileExtension", "()Ljava/lang/String;", "name", "getName", "defaultClassName", "getDefaultClassName", "definitionId", "getDefinitionId", "contextClassLoader", "Ljava/lang/ClassLoader;", "getContextClassLoader", "()Ljava/lang/ClassLoader;", "platform", "getPlatform", "isDefault", "()Z", "order", "", "getOrder", "()I", "setOrder", "(I)V", "canAutoReloadScriptConfigurationsBeSwitchedOff", "getCanAutoReloadScriptConfigurationsBeSwitchedOff", "canDefinitionBeSwitchedOff", "getCanDefinitionBeSwitchedOff", "baseClassType", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/KotlinType;", "getBaseClassType", "()Lkotlin/script/experimental/api/KotlinType;", "compilerOptions", "", "getCompilerOptions", "()Ljava/lang/Iterable;", "annotationsForSamWithReceivers", "", "getAnnotationsForSamWithReceivers", "()Ljava/util/List;", "toString", "FromConfigurationsBase", "FromConfigurations", "FromNewDefinition", "FromTemplate", "Companion", "kotlin-scripting-compiler-impl"})
public abstract class ScriptDefinition
extends UserDataHolderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String defaultClassName;
    private final boolean isDefault;
    private int order = Integer.MAX_VALUE;

    public ScriptDefinition() {
        this.defaultClassName = "Script";
    }

    @NotNull
    public abstract ScriptingHostConfiguration getHostConfiguration();

    @NotNull
    public abstract ScriptCompilationConfiguration getCompilationConfiguration();

    @Nullable
    public abstract ScriptEvaluationConfiguration getEvaluationConfiguration();

    public abstract boolean isScript(@NotNull SourceCode var1);

    @NotNull
    public abstract String getFileExtension();

    @NotNull
    public abstract String getName();

    @NotNull
    public String getDefaultClassName() {
        return this.defaultClassName;
    }

    @NotNull
    public abstract String getDefinitionId();

    @Nullable
    public abstract ClassLoader getContextClassLoader();

    @NotNull
    public String getPlatform() {
        return "JVM";
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int n) {
        this.order = n;
    }

    public boolean getCanAutoReloadScriptConfigurationsBeSwitchedOff() {
        return true;
    }

    public boolean getCanDefinitionBeSwitchedOff() {
        return true;
    }

    @NotNull
    public abstract KotlinType getBaseClassType();

    @NotNull
    public abstract Iterable<String> getCompilerOptions();

    @NotNull
    public abstract List<String> getAnnotationsForSamWithReceivers();

    @NotNull
    public String toString() {
        return "ScriptDefinition(" + this.getName() + ')';
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$Companion;", "", "<init>", "()V", "getDefault", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromConfigurations;", "hostConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/ScriptingHostConfiguration;", "kotlin-scripting-compiler-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FromConfigurations getDefault(@NotNull ScriptingHostConfiguration hostConfiguration) {
            Intrinsics.checkNotNullParameter((Object)hostConfiguration, (String)"hostConfiguration");
            ScriptCompilationConfigurationFromLegacyTemplate scriptCompilationConfigurationFromLegacyTemplate = new ScriptCompilationConfigurationFromLegacyTemplate(hostConfiguration, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(ScriptTemplateWithArgs.class));
            ScriptEvaluationConfigurationFromHostConfiguration scriptEvaluationConfigurationFromHostConfiguration = new ScriptEvaluationConfigurationFromHostConfiguration(hostConfiguration);
            return new FromConfigurations(hostConfiguration, scriptCompilationConfigurationFromLegacyTemplate, scriptEvaluationConfigurationFromHostConfiguration){
                private final boolean isDefault;
                {
                    this.isDefault = true;
                }

                public boolean isDefault() {
                    return this.isDefault;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromConfigurations;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromConfigurationsBase;", "hostConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/ScriptingHostConfiguration;", "compilationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptCompilationConfiguration;", "evaluationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptEvaluationConfiguration;", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/script/experimental/api/ScriptCompilationConfiguration;Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;)V", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "kotlin-scripting-compiler-impl"})
    public static class FromConfigurations
    extends FromConfigurationsBase {
        @NotNull
        private final ScriptingHostConfiguration hostConfiguration;
        @NotNull
        private final ScriptCompilationConfiguration compilationConfiguration;
        @Nullable
        private final ScriptEvaluationConfiguration evaluationConfiguration;

        public FromConfigurations(@NotNull ScriptingHostConfiguration hostConfiguration, @NotNull ScriptCompilationConfiguration compilationConfiguration, @Nullable ScriptEvaluationConfiguration evaluationConfiguration) {
            Intrinsics.checkNotNullParameter((Object)hostConfiguration, (String)"hostConfiguration");
            Intrinsics.checkNotNullParameter((Object)compilationConfiguration, (String)"compilationConfiguration");
            this.hostConfiguration = hostConfiguration;
            this.compilationConfiguration = compilationConfiguration;
            this.evaluationConfiguration = evaluationConfiguration;
        }

        @Override
        @NotNull
        public ScriptingHostConfiguration getHostConfiguration() {
            return this.hostConfiguration;
        }

        @Override
        @NotNull
        public ScriptCompilationConfiguration getCompilationConfiguration() {
            return this.compilationConfiguration;
        }

        @Override
        @Nullable
        public ScriptEvaluationConfiguration getEvaluationConfiguration() {
            return this.evaluationConfiguration;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010,\u001a\u00020\u000e2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0082\u0004J\n\u0010/\u001a\u000200H\u0096\u0080\u0004R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\t\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromConfigurationsBase;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition;", "<init>", "()V", "filePathPattern", "", "getFilePathPattern", "()Ljava/lang/String;", "filePathPattern$delegate", "Lkotlin/Lazy;", "fileNamePattern", "getFileNamePattern", "fileNamePattern$delegate", "isScript", "", "script", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/SourceCode;", "fileExtension", "getFileExtension", "name", "getName", "defaultClassName", "getDefaultClassName", "definitionId", "getDefinitionId", "contextClassLoader", "Ljava/lang/ClassLoader;", "getContextClassLoader", "()Ljava/lang/ClassLoader;", "contextClassLoader$delegate", "platform", "getPlatform", "baseClassType", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/KotlinType;", "getBaseClassType", "()Lkotlin/script/experimental/api/KotlinType;", "compilerOptions", "", "getCompilerOptions", "()Ljava/lang/Iterable;", "annotationsForSamWithReceivers", "", "getAnnotationsForSamWithReceivers", "()Ljava/util/List;", "equals", "other", "", "hashCode", "", "kotlin-scripting-compiler-impl"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1#2:158\n1586#3:159\n1661#3,3:160\n*S KotlinDebug\n*F\n+ 1 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurationsBase\n*L\n105#1:159\n105#1:160,3\n*E\n"})
    public static abstract class FromConfigurationsBase
    extends ScriptDefinition {
        @NotNull
        private final Lazy filePathPattern$delegate = LazyKt.lazy(() -> FromConfigurationsBase.filePathPattern_delegate$lambda$0(this));
        @NotNull
        private final Lazy fileNamePattern$delegate = LazyKt.lazy(() -> FromConfigurationsBase.fileNamePattern_delegate$lambda$0(this));
        @NotNull
        private final Lazy contextClassLoader$delegate = LazyKt.lazy(() -> FromConfigurationsBase.contextClassLoader_delegate$lambda$0(this));

        @Nullable
        public final String getFilePathPattern() {
            Lazy lazy = this.filePathPattern$delegate;
            return (String)lazy.getValue();
        }

        @Nullable
        public final String getFileNamePattern() {
            Lazy lazy = this.fileNamePattern$delegate;
            return (String)lazy.getValue();
        }

        @Override
        public boolean isScript(@NotNull SourceCode script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            String extension = '.' + this.getFileExtension();
            String string = script.getLocationId();
            if (string == null) {
                return false;
            }
            String location = string;
            String string2 = FileUtilRt.toSystemIndependentName((String)location);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            String systemIndependentName = string2;
            String string3 = script.getName();
            if (!(string3 != null ? StringsKt.endsWith$default((String)string3, (String)extension, (boolean)false, (int)2, null) : false) && !StringsKt.endsWith$default((String)location, (String)extension, (boolean)false, (int)2, null)) {
                return false;
            }
            if (this.getFilePathPattern() != null) {
                String string4 = this.getFilePathPattern();
                Intrinsics.checkNotNull((Object)string4);
                return new Regex(string4).matches((CharSequence)systemIndependentName);
            }
            if (this.getFileNamePattern() != null) {
                String string5 = this.getFileNamePattern();
                Intrinsics.checkNotNull((Object)string5);
                return new Regex(string5).matches((CharSequence)StringsKt.substringAfterLast$default((String)systemIndependentName, (char)'/', null, (int)2, null));
            }
            return true;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            String string = this.getCompilationConfiguration().get(ScriptCompilationKt.getFileExtension(ScriptCompilationConfiguration.Companion));
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string;
            block4: {
                block3: {
                    String string2;
                    string = this.getCompilationConfiguration().get(ScriptCompilationKt.getDisplayName(ScriptCompilationConfiguration.Companion));
                    if (string == null) break block3;
                    String it = string2 = string;
                    boolean bl = false;
                    string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                    if (string != null) break block4;
                }
                KotlinType kotlinType = this.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
                Intrinsics.checkNotNull((Object)kotlinType);
                string = StringsKt.substringAfterLast$default((String)kotlinType.getTypeName(), (char)'.', null, (int)2, null);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDefaultClassName() {
            String string = this.getCompilationConfiguration().get(ScriptCompilationKt.getDefaultIdentifier(ScriptCompilationConfiguration.Companion));
            if (string == null) {
                string = super.getDefaultClassName();
            }
            return string;
        }

        @Override
        @NotNull
        public String getDefinitionId() {
            KotlinType kotlinType = this.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
            Intrinsics.checkNotNull((Object)kotlinType);
            return kotlinType.getTypeName();
        }

        @Override
        @Nullable
        public ClassLoader getContextClassLoader() {
            Lazy lazy = this.contextClassLoader$delegate;
            return (ClassLoader)lazy.getValue();
        }

        @Override
        @NotNull
        public String getPlatform() {
            String string = this.getCompilationConfiguration().get(ScriptCompilationConfigurationFromDefinitionKt.getPlatform(ScriptCompilationConfiguration.Companion));
            if (string == null) {
                string = super.getPlatform();
            }
            return string;
        }

        @Override
        @NotNull
        public KotlinType getBaseClassType() {
            KotlinType kotlinType = this.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
            Intrinsics.checkNotNull((Object)kotlinType);
            return kotlinType;
        }

        @Override
        @NotNull
        public Iterable<String> getCompilerOptions() {
            List list = this.getCompilationConfiguration().get(ScriptCompilationKt.getCompilerOptions(ScriptCompilationConfiguration.Companion));
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getAnnotationsForSamWithReceivers() {
            void $this$mapTo$iv$iv;
            List list = this.getCompilationConfiguration().get(ScriptCompilationConfigurationFromDefinitionKt.getAnnotationsForSamWithReceivers(ScriptCompilationConfiguration.Companion));
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTypeName());
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof FromConfigurationsBase)) return false;
            FromConfigurationsBase fromConfigurationsBase = (FromConfigurationsBase)((Object)other);
            if (fromConfigurationsBase == null) return false;
            FromConfigurationsBase it = fromConfigurationsBase;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.getCompilationConfiguration(), (Object)it.getCompilationConfiguration())) return false;
            if (!Intrinsics.areEqual((Object)this.getEvaluationConfiguration(), (Object)it.getEvaluationConfiguration())) return false;
            return true;
        }

        public int hashCode() {
            ScriptEvaluationConfiguration scriptEvaluationConfiguration = this.getEvaluationConfiguration();
            return this.getCompilationConfiguration().hashCode() + 37 * (scriptEvaluationConfiguration != null ? scriptEvaluationConfiguration.hashCode() : 0);
        }

        private static final String filePathPattern_delegate$lambda$0(FromConfigurationsBase this$0) {
            String string;
            String string2 = this$0.getCompilationConfiguration().get(ScriptCompilationKt.getFilePathPattern(ScriptCompilationConfiguration.Companion));
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        private static final String fileNamePattern_delegate$lambda$0(FromConfigurationsBase this$0) {
            String string;
            String string2 = this$0.getCompilationConfiguration().get(ScriptCompilationKt.getFileNamePattern(ScriptCompilationConfiguration.Companion));
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        private static final ClassLoader contextClassLoader_delegate$lambda$0(FromConfigurationsBase this$0) {
            Object object = this$0.getCompilationConfiguration().get(ScriptCompilationKt.getBaseClass(ScriptCompilationConfiguration.Companion));
            if (object == null || (object = ((KotlinType)object).getFromClass()) == null || (object = JvmClassMappingKt.getJavaClass(object)) == null || (object = ((Class)object).getClassLoader()) == null) {
                object = this$0.getHostConfiguration().get(JvmScriptingHostConfigurationKt.getBaseClassLoader(JvmScriptingHostConfigurationKt.getJvm(ScriptingHostConfiguration.Companion)));
            }
            return object;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromNewDefinition;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromConfigurationsBase;", "baseHostConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/ScriptingHostConfiguration;", "definition", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/ScriptDefinition;", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/script/experimental/host/ScriptDefinition;)V", "hostConfiguration", "getHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "compilationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptCompilationConfiguration;", "getCompilationConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "evaluationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptEvaluationConfiguration;", "getEvaluationConfiguration", "()Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "kotlin-scripting-compiler-impl"})
    public static class FromNewDefinition
    extends FromConfigurationsBase {
        @NotNull
        private final ScriptingHostConfiguration baseHostConfiguration;
        @NotNull
        private final org.jetbrains.kotlin.buildtools.internal.scripting.host.ScriptDefinition definition;

        public FromNewDefinition(@NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull org.jetbrains.kotlin.buildtools.internal.scripting.host.ScriptDefinition definition) {
            Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            this.baseHostConfiguration = baseHostConfiguration;
            this.definition = definition;
        }

        @Override
        @NotNull
        public ScriptingHostConfiguration getHostConfiguration() {
            ScriptingHostConfiguration scriptingHostConfiguration = this.definition.getCompilationConfiguration().get(ScriptCompilationKt.getHostConfiguration(ScriptCompilationConfiguration.Companion));
            if (scriptingHostConfiguration == null) {
                scriptingHostConfiguration = this.baseHostConfiguration;
            }
            return scriptingHostConfiguration;
        }

        @Override
        @NotNull
        public ScriptCompilationConfiguration getCompilationConfiguration() {
            return this.definition.getCompilationConfiguration();
        }

        @Override
        @NotNull
        public ScriptEvaluationConfiguration getEvaluationConfiguration() {
            return this.definition.getEvaluationConfiguration();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromTemplate;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptDefinition$FromNewDefinition;", "baseHostConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/host/ScriptingHostConfiguration;", "template", "Lkotlin/reflect/KClass;", "contextClass", "<init>", "(Lkotlin/script/experimental/host/ScriptingHostConfiguration;Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;)V", "kotlin-scripting-compiler-impl"})
    public static class FromTemplate
    extends FromNewDefinition {
        public FromTemplate(@NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull KClass<?> template, @NotNull KClass<?> contextClass) {
            Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
            Intrinsics.checkNotNullParameter(template, (String)"template");
            Intrinsics.checkNotNullParameter(contextClass, (String)"contextClass");
            super(baseHostConfiguration, ConfigurationFromTemplateKt.createScriptDefinitionFromTemplate$default(new KotlinType(template, false, 2, null), baseHostConfiguration, contextClass, null, null, 24, null));
        }

        public /* synthetic */ FromTemplate(ScriptingHostConfiguration scriptingHostConfiguration, KClass kClass, KClass kClass2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                kClass2 = Reflection.getOrCreateKotlinClass(ScriptCompilationConfiguration.class);
            }
            this(scriptingHostConfiguration, kClass, kClass2);
        }
    }
}

