/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.lang.reflect.Field;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;

public class Usage {
    public static final String BAT_DELIMITER_CHARACTERS_NOTE = "Note: on Windows, arguments that contain delimiter characters (whitespace, =, ;, ,) need to be surrounded with double quotes (\").";

    @NotNull
    public static <A extends CommonCompilerArguments> String render(@NotNull CLICompiler<A> compiler, @NotNull A arguments) {
        if (compiler == null) {
            Usage.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            Usage.$$$reportNull$$$0(1);
        }
        boolean extraHelp = arguments.getExtraHelp();
        StringBuilder sb = new StringBuilder();
        Usage.appendln(sb, "Usage: " + compiler.executableScriptFileName() + " <options> <source files>");
        Usage.appendln(sb, "where " + (extraHelp ? "advanced" : "possible") + " options include:");
        for (Class<?> klass = arguments.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                Usage.fieldUsage(sb, field, extraHelp);
            }
        }
        if (extraHelp) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, "Advanced options are non-standard and may be changed or removed without any notice.");
        } else {
            Usage.renderOptionJUsage(sb);
            Usage.renderArgfileUsage(sb);
        }
        if (SystemInfo.isWindows) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, BAT_DELIMITER_CHARACTERS_NOTE);
        }
        if (!extraHelp) {
            Usage.appendln(sb, "");
            Usage.appendln(sb, "For details, see https://kotl.in/cli");
        }
        String string = sb.toString();
        if (string == null) {
            Usage.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void fieldUsage(@NotNull StringBuilder sb, @NotNull Field field, boolean extraHelp) {
        Argument argument;
        if (sb == null) {
            Usage.$$$reportNull$$$0(3);
        }
        if (field == null) {
            Usage.$$$reportNull$$$0(4);
        }
        if ((argument = field.getAnnotation(Argument.class)) == null) {
            return;
        }
        if (ParseCommandLineArgumentsKt.isInternal(argument)) {
            return;
        }
        if (extraHelp != ParseCommandLineArgumentsKt.isAdvanced(argument)) {
            return;
        }
        int startLength = sb.length();
        sb.append("  ");
        sb.append(argument.value());
        if (!argument.shortName().isEmpty()) {
            sb.append(" (");
            sb.append(argument.shortName());
            sb.append(")");
        }
        if (!argument.valueDescription().isEmpty()) {
            sb.append(ParseCommandLineArgumentsKt.isAdvanced(argument) ? "=" : " ");
            sb.append(argument.valueDescription());
        }
        int margin = startLength + 29 - 1;
        if (sb.length() >= margin + 5) {
            sb.append("\n");
            margin += sb.length() - startLength;
        }
        while (sb.length() < margin) {
            sb.append(" ");
        }
        sb.append(" ");
        Usage.appendln(sb, argument.description().replace("\n", "\n" + StringsKt.repeat((CharSequence)" ", (int)29)));
    }

    private static void renderOptionJUsage(@NotNull StringBuilder sb) {
        if (sb == null) {
            Usage.$$$reportNull$$$0(5);
        }
        int descriptionStart = sb.length() + 29;
        sb.append("  -J<option>");
        while (sb.length() < descriptionStart) {
            sb.append(" ");
        }
        Usage.appendln(sb, "Pass an option directly to JVM.");
    }

    private static void renderArgfileUsage(@NotNull StringBuilder sb) {
        if (sb == null) {
            Usage.$$$reportNull$$$0(6);
        }
        int descriptionStart = sb.length() + 29;
        sb.append("  ");
        sb.append("@");
        sb.append("<argfile>");
        while (sb.length() < descriptionStart) {
            sb.append(" ");
        }
        Usage.appendln(sb, "Read compiler arguments and file paths from the given file.");
    }

    private static void appendln(@NotNull StringBuilder sb, @NotNull String string) {
        if (sb == null) {
            Usage.$$$reportNull$$$0(7);
        }
        if (string == null) {
            Usage.$$$reportNull$$$0(8);
        }
        sb.append(string);
        sb.append('\n');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/Usage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fieldUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderOptionJUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderArgfileUsage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendln";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

