/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ClassDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H$J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000fJ\u001c\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u000fH\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "Lorg/jetbrains/kotlin/com/intellij/psi/compiled/ClsStubBuilder;", "<init>", "()V", "supportedFileType", "Lorg/jetbrains/kotlin/com/intellij/openapi/fileTypes/FileType;", "getSupportedFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "expectedBinaryVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getExpectedBinaryVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "readFile", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "virtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "content", "", "hasMetadata", "", "isSupported", "file", "hasStub", "readFileSafely", "buildFileStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStub;", "Lorg/jetbrains/kotlin/com/intellij/util/indexing/FileContent;", "createCallableSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "filename", "", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "original", "FileWithMetadata", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder\n+ 2 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilderKt\n+ 3 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,157:1\n144#2,13:158\n144#2,13:171\n118#3,11:184\n57#3:195\n129#3,3:196\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder\n*L\n52#1:158,13\n54#1:171,13\n60#1:184,11\n60#1:195\n60#1:196,3\n*E\n"})
public abstract class KotlinMetadataStubBuilder
extends ClsStubBuilder {
    @NotNull
    protected abstract FileType getSupportedFileType();

    @NotNull
    protected abstract BinaryVersion getExpectedBinaryVersion();

    @Nullable
    protected abstract FileWithMetadata readFile(@NotNull VirtualFile var1, @Nullable byte[] var2);

    protected boolean hasMetadata(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.readFile(virtualFile, null) != null;
    }

    public final boolean isSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileType supportedType = this.getSupportedFileType();
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)supportedType.getDefaultExtension()) || Intrinsics.areEqual((Object)file.getFileType(), (Object)supportedType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasStub(@NotNull VirtualFile file) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isSupported(file)) return false;
        VirtualFile $this$readSafely$iv = file;
        boolean $i$f$readSafely = false;
        try {
            Boolean bl2;
            if ($this$readSafely$iv.isValid()) {
                boolean bl3 = false;
                bl2 = this.hasMetadata(file);
            } else {
                bl2 = null;
            }
            bl = bl2;
        }
        catch (IOException iOException) {
            bl = null;
        }
        if (!Intrinsics.areEqual(bl, (Object)true)) return false;
        return true;
    }

    @Nullable
    public final FileWithMetadata readFileSafely(@NotNull VirtualFile file, @Nullable byte[] content) {
        FileWithMetadata fileWithMetadata;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile $this$readSafely$iv = file;
        boolean $i$f$readSafely = false;
        try {
            FileWithMetadata fileWithMetadata2;
            if ($this$readSafely$iv.isValid()) {
                boolean bl = false;
                fileWithMetadata2 = this.readFile(file, content);
            } else {
                fileWithMetadata2 = null;
            }
            fileWithMetadata = fileWithMetadata2;
        }
        catch (IOException iOException) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    public static /* synthetic */ FileWithMetadata readFileSafely$default(KotlinMetadataStubBuilder kotlinMetadataStubBuilder, VirtualFile virtualFile, byte[] byArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readFileSafely");
        }
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        return kotlinMetadataStubBuilder.readFileSafely(virtualFile, byArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final PsiFileStub<?> buildFileStub(@NotNull FileContent content) {
        PsiFileStub psiFileStub;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        boolean condition$iv = this.isSupported(virtualFile2);
        String attachmentName$iv = "info.txt";
        boolean $i$f$requireWithAttachment = false;
        if (!condition$iv) {
            void $this$requireWithAttachment_u24lambda_u240$iv;
            void $this$buildAttachment$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean $i$a$-requireWithAttachment$default-KotlinMetadataStubBuilder$buildFileStub$32 = false;
            String string = "Unexpected file type";
            KotlinIllegalArgumentExceptionWithAttachments exception$iv = new KotlinIllegalArgumentExceptionWithAttachments(string);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv;
            String name$iv$iv = attachmentName$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String $i$a$-requireWithAttachment$default-KotlinMetadataStubBuilder$buildFileStub$32 = name$iv$iv;
            void var13_24 = $this$buildAttachment$iv$iv;
            boolean bl = false;
            void $this$buildFileStub_u24lambda_u241 = $this$requireWithAttachment_u24lambda_u240$iv;
            boolean bl2 = false;
            ExceptionAttachementBuilderUtilsKt.withVirtualFileEntry((ExceptionAttachmentBuilder)$this$buildFileStub_u24lambda_u241, "file", virtualFile2);
            var13_24.withAttachment($i$a$-requireWithAttachment$default-KotlinMetadataStubBuilder$buildFileStub$32, exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
        FileWithMetadata fileWithMetadata = this.readFileSafely(virtualFile2, content.getContent());
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata file = fileWithMetadata;
        FileWithMetadata fileWithMetadata2 = file;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            psiFileStub = ClsStubBuildingKt.createIncompatibleAbiVersionFileStub(IncompatibleAbiVersionKt.createIncompatibleMetadataVersionDecompiledText(this.getExpectedBinaryVersion(), ((FileWithMetadata.Incompatible)file).getVersion()));
        } else if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            ProtoBuf.Package packageProto = ((FileWithMetadata.Compatible)file).getProto().getPackage();
            FqName packageFqName = ((FileWithMetadata.Compatible)file).getPackageFqName();
            NameResolverImpl nameResolver = ((FileWithMetadata.Compatible)file).getNameResolver();
            SerializerExtensionProtocol protocol = ((FileWithMetadata.Compatible)file).getSerializerProtocol();
            ClsStubBuilderComponents components = new ClsStubBuilderComponents(this.classDataFinder(new ProtoBasedClassDataFinder(((FileWithMetadata.Compatible)file).getProto(), nameResolver, ((FileWithMetadata.Compatible)file).getVersion(), null, 8, null), virtualFile2), new AnnotationLoaderForStubBuilderImpl(protocol), virtualFile2, protocol, null, null, 48, null);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"getTypeTable(...)");
            ClsStubBuilderContext context2 = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            StubElement stubElement = fileStub;
            NameResolver nameResolver3 = context2.getNameResolver();
            TypeTable typeTable2 = context2.getTypeTable();
            FileWithMetadata.Compatible compatible = (FileWithMetadata.Compatible)file;
            String string = content.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, nameResolver3, typeTable2, this.createCallableSource(compatible, string));
            Intrinsics.checkNotNull((Object)packageProto);
            CallableClsStubBuilderKt.createPackageDeclarationsStubs(stubElement, context2, package_, packageProto);
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file).getClassesToDecompile()) {
                ClassClsStubBuilderKt.createClassStub(fileStub, classProto, nameResolver, NameResolverUtilKt.getClassId(nameResolver, classProto.getFqName()), null, context2);
            }
            psiFileStub = fileStub;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiFileStub;
    }

    @Nullable
    protected SourceElement createCallableSource(@NotNull FileWithMetadata.Compatible file, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return null;
    }

    @NotNull
    protected ClassDataFinder classDataFinder(@NotNull ClassDataFinder original, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return original;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "", "<init>", "()V", "Incompatible", "Compatible", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "decompiler-to-file-stubs"})
    public static abstract class FileWithMetadata {
        private FileWithMetadata() {
        }

        public /* synthetic */ FileWithMetadata(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "version", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getSerializerProtocol", "()Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "classesToDecompile", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getClassesToDecompile", "()Ljava/util/List;", "decompiler-to-file-stubs"})
        @SourceDebugExtension(value={"SMAP\nKotlinMetadataStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n776#2:158\n872#2,2:159\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible\n*L\n136#1:158\n136#1:159,2\n*E\n"})
        public static class Compatible
        extends FileWithMetadata {
            @NotNull
            private final ProtoBuf.PackageFragment proto;
            @NotNull
            private final BinaryVersion version;
            @NotNull
            private final SerializerExtensionProtocol serializerProtocol;
            @NotNull
            private final NameResolverImpl nameResolver;

            public Compatible(@NotNull ProtoBuf.PackageFragment proto, @NotNull BinaryVersion version2, @NotNull SerializerExtensionProtocol serializerProtocol) {
                Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
                super(null);
                this.proto = proto;
                this.version = version2;
                this.serializerProtocol = serializerProtocol;
                ProtoBuf.StringTable stringTable2 = this.proto.getStrings();
                Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"getStrings(...)");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getQualifiedNames(...)");
                this.nameResolver = new NameResolverImpl(stringTable2, qualifiedNameTable);
            }

            @NotNull
            public final ProtoBuf.PackageFragment getProto() {
                return this.proto;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }

            @NotNull
            public final SerializerExtensionProtocol getSerializerProtocol() {
                return this.serializerProtocol;
            }

            @NotNull
            public final NameResolverImpl getNameResolver() {
                return this.nameResolver;
            }

            @NotNull
            public FqName getPackageFqName() {
                Integer n2 = this.proto.getPackage().getExtension(this.serializerProtocol.getPackageFqName());
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getExtension(...)");
                return new FqName(this.nameResolver.getPackageFqName(((Number)n2).intValue()));
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<ProtoBuf.Class> getClassesToDecompile() {
                void $this$filterTo$iv$iv;
                List<ProtoBuf.Class> list = this.proto.getClass_List();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getClass_List(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProtoBuf.Class proto = (ProtoBuf.Class)element$iv$iv;
                    boolean bl = false;
                    ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, proto.getFqName());
                    if (!(!classId.isNestedClass() && !ClassDeserializer.Companion.getBLACK_LIST().contains(classId))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "version", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "decompiler-to-file-stubs"})
        public static final class Incompatible
        extends FileWithMetadata {
            @NotNull
            private final BinaryVersion version;

            public Incompatible(@NotNull BinaryVersion version2) {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                super(null);
                this.version = version2;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }
        }
    }
}

