/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DefaultArgumentFunctionFactory;
import org.jetbrains.kotlin.backend.common.lower.DefaultArgumentStubGeneratorKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B5\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0014J3\u0010\"\u001a\u00020#\"\b\b\u0001\u0010$*\u00020!2\u0006\u0010%\u001a\u0002H$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H$0'H\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020#2\u0006\u0010%\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020#2\u0006\u0010%\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020#2\u0006\u0010%\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020#2\u0006\u0010%\u001a\u000204H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020!H\u0002J*\u00106\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0006\u0012\u0004\u0018\u00010#07*\u0002092\u0006\u0010%\u001a\u00020!2\u0006\u0010:\u001a\u00020,H\u0014J\"\u0010;\u001a\u0004\u0018\u00010#2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u000208H\u0014J \u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020,H\u0014J\u0010\u0010E\u001a\u00020\t2\u0006\u0010D\u001a\u00020,H\u0014J\u0010\u0010F\u001a\u00020\t2\u0006\u0010D\u001a\u00020,H\u0014J\u0016\u0010G\u001a\u00020\u001b2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020J0IH\u0002J\f\u0010K\u001a\u00020\t*\u000208H\u0004R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u000b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/DefaultParameterInjector;", "TContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "factory", "Lorg/jetbrains/kotlin/backend/common/lower/DefaultArgumentFunctionFactory;", "skipInline", "", "skipExternalMethods", "forceSetOverrideSymbols", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/DefaultArgumentFunctionFactory;ZZZ)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getFactory", "()Lorg/jetbrains/kotlin/backend/common/lower/DefaultArgumentFunctionFactory;", "getSkipInline", "()Z", "getSkipExternalMethods", "getForceSetOverrideSymbols", "declarationStack", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "shouldReplaceWithSyntheticFunction", "functionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionAccessExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "T", "expression", "builder", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "needsTypeArgumentOffset", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "createStubFunction", "argumentsForCall", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "stubFunction", "nullConst", "startOffset", "", "endOffset", "irParameter", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "defaultArgumentStubVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "function", "useConstructorMarker", "isStatic", "log", "msg", "Lkotlin/Function0;", "", "canHaveDefaultValue", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nDefaultArgumentStubGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultArgumentStubGenerator.kt\norg/jetbrains/kotlin/backend/common/lower/DefaultParameterInjector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,526:1\n1806#2,3:527\n1914#2,2:530\n1833#2,4:547\n379#3,13:532\n133#4,2:545\n*S KotlinDebug\n*F\n+ 1 DefaultArgumentStubGenerator.kt\norg/jetbrains/kotlin/backend/common/lower/DefaultParameterInjector\n*L\n251#1:527,3\n262#1:530,2\n374#1:547,4\n268#1:532,13\n268#1:545,2\n*E\n"})
public class DefaultParameterInjector<TContext extends CommonBackendContext>
extends IrElementTransformerVoid
implements BodyLoweringPass {
    @NotNull
    private final TContext context;
    @NotNull
    private final DefaultArgumentFunctionFactory factory;
    private final boolean skipInline;
    private final boolean skipExternalMethods;
    private final boolean forceSetOverrideSymbols;
    @NotNull
    private final List<IrDeclaration> declarationStack;

    public DefaultParameterInjector(@NotNull TContext context2, @NotNull DefaultArgumentFunctionFactory factory, boolean skipInline, boolean skipExternalMethods, boolean forceSetOverrideSymbols) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.context = context2;
        this.factory = factory;
        this.skipInline = skipInline;
        this.skipExternalMethods = skipExternalMethods;
        this.forceSetOverrideSymbols = forceSetOverrideSymbols;
        this.declarationStack = new ArrayList();
    }

    public /* synthetic */ DefaultParameterInjector(CommonBackendContext commonBackendContext, DefaultArgumentFunctionFactory defaultArgumentFunctionFactory, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = true;
        }
        this(commonBackendContext, defaultArgumentFunctionFactory, bl, bl2, bl3);
    }

    @NotNull
    protected final TContext getContext() {
        return this.context;
    }

    @NotNull
    protected final DefaultArgumentFunctionFactory getFactory() {
        return this.factory;
    }

    protected final boolean getSkipInline() {
        return this.skipInline;
    }

    protected final boolean getSkipExternalMethods() {
        return this.skipExternalMethods;
    }

    protected final boolean getForceSetOverrideSymbols() {
        return this.forceSetOverrideSymbols;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        UtilsKt.push(this.declarationStack, container);
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
        UtilsKt.pop(this.declarationStack);
    }

    protected boolean shouldReplaceWithSyntheticFunction(@NotNull IrFunctionAccessExpression functionAccess) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)functionAccess, (String)"functionAccess");
            Iterable $this$any$iv = functionAccess.getArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrExpression it = (IrExpression)element$iv;
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends IrFunctionAccessExpression> IrExpression visitFunctionAccessExpression(T expression2, Function1<? super IrFunctionSymbol, ? extends T> builder) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        if (!this.shouldReplaceWithSyntheticFunction(expression2)) {
            return expression2;
        }
        IrFunctionSymbol irFunctionSymbol = this.createStubFunction(expression2);
        if (irFunctionSymbol == null) {
            return expression2;
        }
        IrFunctionSymbol symbol = irFunctionSymbol;
        int n2 = ((Collection)expression2.getTypeArguments()).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.log((Function0<String>)((Function0)() -> DefaultParameterInjector.visitFunctionAccessExpression$lambda$0(symbol, i2, expression2)));
        }
        IrFunction stubFunction = symbol.getOwner();
        Iterable $this$forEach$iv = stubFunction.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrTypeParameter it = (IrTypeParameter)element$iv;
            boolean bl = false;
            this.log((Function0<String>)((Function0)() -> DefaultParameterInjector.visitFunctionAccessExpression$lambda$1$0(stubFunction, it)));
        }
        IrFunction declaration = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrDeclaration currentDeclaration = (IrDeclaration)CollectionsKt.last(this.declarationStack);
        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder((LoweringContext)this.context, currentDeclaration.getSymbol(), ((IrElement)expression2).getStartOffset(), ((IrElement)expression2).getEndOffset());
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$visitFunctionAccessExpression_u24lambda_u242 = this_$iv$iv;
        boolean bl = false;
        Object object = builder.invoke((Object)symbol);
        IrFunctionAccessExpression $this$visitFunctionAccessExpression_u24lambda_u242_u240 = (IrFunctionAccessExpression)object;
        boolean bl2 = false;
        int offset = this.needsTypeArgumentOffset(declaration) ? IrUtilsKt.getParentAsClass(declaration).getTypeParameters().size() : 0;
        int n3 = ((Collection)$this$visitFunctionAccessExpression_u24lambda_u242_u240.getTypeArguments()).size();
        for (int i3 = 0; i3 < n3; ++i3) {
            $this$visitFunctionAccessExpression_u24lambda_u242_u240.getTypeArguments().set(i3, expression2.getTypeArguments().get(i3 + offset));
        }
        Map<IrValueParameter, IrExpression> parameter2arguments = this.argumentsForCall((IrBlockBuilder)$this$visitFunctionAccessExpression_u24lambda_u242, expression2, stubFunction);
        for (Map.Entry<IrValueParameter, IrExpression> entry : parameter2arguments.entrySet()) {
            IrValueParameter parameter = entry.getKey();
            IrExpression argument = entry.getValue();
            this.log((Function0<String>)((Function0)() -> DefaultParameterInjector.visitFunctionAccessExpression$lambda$2$0$0(parameter, argument)));
            if (argument == null) continue;
            $this$visitFunctionAccessExpression_u24lambda_u242_u240.getArguments().set(parameter.getIndexInParameters(), argument);
        }
        IrFunctionAccessExpression newCall = (IrFunctionAccessExpression)object;
        $this$visitFunctionAccessExpression_u24lambda_u242.unaryPlus(IrUtilsKt.irCastIfNeeded((IrBuilderWithScope)$this$visitFunctionAccessExpression_u24lambda_u242, newCall, ((IrExpression)expression2).getType()));
        return IrUtilsKt.unwrapBlock((IrContainerExpression)this_$iv$iv.doBuild());
    }

    private final boolean needsTypeArgumentOffset(IrFunction declaration) {
        return this.isStatic(declaration) && IrDeclarationsKt.isMultiFieldValueClass(IrUtilsKt.getParentAsClass(declaration)) && declaration instanceof IrSimpleFunction;
    }

    @Override
    @NotNull
    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        return this.visitFunctionAccessExpression((IrFunctionAccessExpression)expression2, arg_0 -> DefaultParameterInjector.visitDelegatingConstructorCall$lambda$0(expression2, arg_0));
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        return this.visitFunctionAccessExpression((IrFunctionAccessExpression)expression2, arg_0 -> DefaultParameterInjector.visitConstructorCall$lambda$0(expression2, arg_0));
    }

    @Override
    @NotNull
    public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        return this.visitFunctionAccessExpression((IrFunctionAccessExpression)expression2, arg_0 -> DefaultParameterInjector.visitEnumConstructorCall$lambda$0(expression2, arg_0));
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        IrSimpleFunction declaration = (IrSimpleFunction)expression2.getSymbol().getOwner();
        int typeParametersToRemove = this.needsTypeArgumentOffset(declaration) ? IrUtilsKt.getParentAsClass(declaration).getTypeParameters().size() : 0;
        IrCall $this$visitCall_u24lambda_u240 = expression2;
        boolean bl = false;
        return this.visitFunctionAccessExpression((IrFunctionAccessExpression)expression2, arg_0 -> DefaultParameterInjector.visitCall$lambda$0$0($this$visitCall_u24lambda_u240, typeParametersToRemove, arg_0));
    }

    private final IrFunctionSymbol createStubFunction(IrFunctionAccessExpression expression2) {
        IrFunction irFunction;
        IrFunction declaration;
        block3: {
            block2: {
                declaration = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
                IrFunction baseFunction = this.factory.findBaseFunctionWithDefaultArgumentsFor(declaration, this.skipInline, this.skipExternalMethods);
                irFunction = baseFunction;
                if (irFunction == null) break block2;
                IrFunction it = irFunction;
                boolean bl = false;
                IrFunction irFunction2 = this.factory.generateDefaultsFunction(it, this.skipInline, this.skipExternalMethods, this.forceSetOverrideSymbols, this.defaultArgumentStubVisibility(declaration), this.useConstructorMarker(declaration), IrUtilsKt.copyAnnotations(baseFunction));
                irFunction = irFunction2;
                if (irFunction2 != null) break block3;
            }
            return null;
        }
        IrFunction stubFunction = irFunction;
        this.log((Function0<String>)((Function0)() -> DefaultParameterInjector.createStubFunction$lambda$1(declaration, stubFunction)));
        return stubFunction.getSymbol();
    }

    @NotNull
    protected Map<IrValueParameter, IrExpression> argumentsForCall(@NotNull IrBlockBuilder $this$argumentsForCall, @NotNull IrFunctionAccessExpression expression2, @NotNull IrFunction stubFunction) {
        Map map;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$argumentsForCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)stubFunction, (String)"stubFunction");
        int startOffset = expression2.getStartOffset();
        int endOffset = expression2.getEndOffset();
        IrFunction declaration = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        Iterable $this$count$iv = declaration.getParameters();
        int $i$f$count = 0;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!this.canHaveDefaultValue(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int defaultableParametersSize = n2;
        int[] maskValues = new int[(defaultableParametersSize + 31) / 32];
        $i$f$count = stubFunction.getParameters().size() - (declaration.getParameters().size() + maskValues.length);
        int n3 = 0 <= $i$f$count ? ($i$f$count < 2 ? 1 : 0) : ($i$f$count = 0);
        if (_Assertions.ENABLED && $i$f$count == 0) {
            boolean bl = false;
            String string = "argument count mismatch: expected " + defaultableParametersSize + " arguments + " + maskValues.length + " masks + optional handler/marker, got " + stubFunction.getParameters().size() + " total in " + RenderIrElementKt.render$default(stubFunction, null, 1, null);
            throw new AssertionError((Object)string);
        }
        int sourceParameterIndex = 0;
        sourceParameterIndex = -1;
        Map $this$argumentsForCall_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (IrValueParameter parameter : stubFunction.getParameters()) {
            IrExpression irExpression;
            if (this.canHaveDefaultValue(parameter)) {
                ++sourceParameterIndex;
            }
            if (sourceParameterIndex >= defaultableParametersSize + maskValues.length) {
                irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, parameter.getType());
            } else if (sourceParameterIndex >= defaultableParametersSize) {
                irExpression = IrConstImpl.Companion.int(startOffset, endOffset, parameter.getType(), maskValues[sourceParameterIndex - defaultableParametersSize]);
            } else {
                IrExpression valueArgument = (IrExpression)expression2.getArguments().get(parameter.getIndexInParameters());
                if (valueArgument == null) {
                    maskValues[sourceParameterIndex / 32] = maskValues[sourceParameterIndex / 32] | 1 << sourceParameterIndex % 32;
                }
                if ((irExpression = valueArgument) == null) {
                    IrCompositeImpl irCompositeImpl;
                    if (this.nullConst(startOffset, endOffset, parameter) != null) {
                        IrExpression it;
                        boolean bl2 = false;
                        irCompositeImpl = new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), parameter.getType(), IrStatementOrigin.Companion.getDEFAULT_VALUE(), CollectionsKt.listOf((Object)it));
                    } else {
                        irCompositeImpl = null;
                    }
                    irExpression = irCompositeImpl;
                }
            }
            IrExpression newArgument = irExpression;
            $this$argumentsForCall_u24lambda_u242.put(parameter, newArgument);
        }
        return MapsKt.build((Map)map);
    }

    @Nullable
    protected IrExpression nullConst(int startOffset, int endOffset, @NotNull IrValueParameter irParameter) {
        Intrinsics.checkNotNullParameter((Object)irParameter, (String)"irParameter");
        return irParameter.getVarargElementType() != null ? null : this.nullConst(startOffset, endOffset, irParameter.getType());
    }

    @NotNull
    protected IrExpression nullConst(int startOffset, int endOffset, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return IrUtilsKt.defaultValueForType(IrConstImpl.Companion, startOffset, endOffset, type);
    }

    @NotNull
    protected DescriptorVisibility defaultArgumentStubVisibility(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2.getVisibility();
    }

    protected boolean useConstructorMarker(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return function2 instanceof IrConstructor;
    }

    protected boolean isStatic(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return false;
    }

    private final void log(Function0<String> msg) {
        ((LoggingContext)this.context).log((Function0<String>)((Function0)() -> DefaultParameterInjector.log$lambda$0(msg)));
    }

    protected final boolean canHaveDefaultValue(@NotNull IrValueParameter $this$canHaveDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveDefaultValue, (String)"<this>");
        return DefaultArgumentStubGeneratorKt.access$canHaveDefaultValue($this$canHaveDefaultValue);
    }

    private static final String visitFunctionAccessExpression$lambda$1$0(IrFunction $stubFunction, IrTypeParameter $it) {
        return $stubFunction + '[' + $it.getIndex() + "] : " + $it;
    }

    private static final String visitFunctionAccessExpression$lambda$2$0$0(IrValueParameter $parameter, IrExpression $argument) {
        return "call::params@$" + $parameter.getIndexInParameters() + '/' + $parameter.getName() + ": " + IrUtilsKt.ir2string($argument);
    }

    private static final String visitFunctionAccessExpression$lambda$0(IrFunctionSymbol $symbol, int $i, IrFunctionAccessExpression $expression) {
        return $symbol + '[' + $i + "]: " + $expression.getTypeArguments().get($i);
    }

    private static final IrDelegatingConstructorCall visitDelegatingConstructorCall$lambda$0(IrDelegatingConstructorCall $expression, IrFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u240_u240 = $expression;
        boolean bl = false;
        return BuildersKt.IrDelegatingConstructorCallImpl$default($this$visitDelegatingConstructorCall_u24lambda_u240_u240.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u240_u240.getEndOffset(), $this$visitDelegatingConstructorCall_u24lambda_u240_u240.getType(), (IrConstructorSymbol)it, $this$visitDelegatingConstructorCall_u24lambda_u240_u240.getTypeArguments().size(), null, 32, null);
    }

    private static final IrConstructorCall visitConstructorCall$lambda$0(IrConstructorCall $expression, IrFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrConstructorCall $this$visitConstructorCall_u24lambda_u240_u240 = $expression;
        boolean bl = false;
        return BuildersKt.fromSymbolOwner(IrConstructorCallImpl.Companion, $this$visitConstructorCall_u24lambda_u240_u240.getStartOffset(), $this$visitConstructorCall_u24lambda_u240_u240.getEndOffset(), $this$visitConstructorCall_u24lambda_u240_u240.getType(), (IrConstructorSymbol)it, IrStatementOrigin.Companion.getDEFAULT_DISPATCH_CALL());
    }

    private static final IrEnumConstructorCall visitEnumConstructorCall$lambda$0(IrEnumConstructorCall $expression, IrFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrEnumConstructorCall $this$visitEnumConstructorCall_u24lambda_u240_u240 = $expression;
        boolean bl = false;
        return BuildersKt.IrEnumConstructorCallImpl$default($this$visitEnumConstructorCall_u24lambda_u240_u240.getStartOffset(), $this$visitEnumConstructorCall_u24lambda_u240_u240.getEndOffset(), $this$visitEnumConstructorCall_u24lambda_u240_u240.getType(), (IrConstructorSymbol)it, $this$visitEnumConstructorCall_u24lambda_u240_u240.getTypeArguments().size(), null, 32, null);
    }

    private static final IrCall visitCall$lambda$0$0(IrCall $this_with, int $typeParametersToRemove, IrFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildersKt.IrCallImpl($this_with.getStartOffset(), $this_with.getEndOffset(), ((IrSimpleFunction)((IrSimpleFunctionSymbol)it).getOwner()).getReturnType(), (IrSimpleFunctionSymbol)it, $this_with.getTypeArguments().size() - $typeParametersToRemove, IrStatementOrigin.Companion.getDEFAULT_DISPATCH_CALL(), $this_with.getSuperQualifierSymbol());
    }

    private static final String createStubFunction$lambda$1(IrFunction $declaration, IrFunction $stubFunction) {
        return $declaration + " -> " + $stubFunction;
    }

    private static final String log$lambda$0(Function0 $msg) {
        return "DEFAULT-INJECTOR: " + (String)$msg.invoke();
    }
}

