/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.SourceMapsInfo;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.wasm.ir.debug.DebugData;
import org.jetbrains.kotlin.wasm.ir.debug.DebugInformationGenerator;
import org.jetbrains.kotlin.wasm.ir.debug.DebugSection;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocationMapping;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u0012H\u0016J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/utils/SourceMapGenerator;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationGenerator;", "baseFileName", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "sourceMapFileName", "sourceLocationMappings", "", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocationMapping;", "addSourceLocation", "", "location", "generateDebugInformation", "", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugSection;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformation;", "generate", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nSourceMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapGenerator.kt\norg/jetbrains/kotlin/backend/wasm/utils/SourceMapGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class SourceMapGenerator
implements DebugInformationGenerator {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final String sourceMapFileName;
    @NotNull
    private final List<SourceLocationMapping> sourceLocationMappings;

    public SourceMapGenerator(@NotNull String baseFileName, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.sourceMapFileName = baseFileName + ".map";
        this.sourceLocationMappings = new ArrayList();
    }

    @Override
    public void addSourceLocation(@NotNull SourceLocationMapping location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.sourceLocationMappings.add(location);
    }

    @Override
    @NotNull
    public List<DebugSection> generateDebugInformation() {
        return CollectionsKt.listOf((Object)new DebugSection("sourceMappingURL", DebugData.StringData.box-impl(DebugData.StringData.constructor-impl(this.sourceMapFileName))));
    }

    @Nullable
    public final String generate() {
        SourceMap3Builder sourceMap3Builder;
        SourceMapsInfo sourceMapsInfo = SourceMapsInfo.Companion.from(this.configuration);
        if (sourceMapsInfo == null) {
            return null;
        }
        SourceMapsInfo sourceMapsInfo2 = sourceMapsInfo;
        SourceMap3Builder $this$generate_u24lambda_u241 = sourceMap3Builder = new SourceMap3Builder(null, (Function0<Integer>)((Function0)SourceMapGenerator::generate$lambda$0), sourceMapsInfo2.getSourceMapPrefix());
        boolean bl = false;
        SourceMap3Builder.addIgnoredSource$default($this$generate_u24lambda_u241, SourceLocation.IgnoredLocation.INSTANCE.getFile(), null, null, 6, null);
        SourceMap3Builder sourceMapBuilder2 = sourceMap3Builder;
        SourceFilePathResolver pathResolver = SourceFilePathResolver.Companion.create(sourceMapsInfo2.getSourceRoots(), sourceMapsInfo2.getSourceMapPrefix(), sourceMapsInfo2.getOutputDir(), sourceMapsInfo2.getIncludeUnavailableSourcesIntoSourceMap());
        SourceLocation prev = null;
        int prevGeneratedLine = 0;
        int offsetExpectedNextLocation = -1;
        for (SourceLocationMapping mapping : this.sourceLocationMappings) {
            SourceLocation sourceLocation;
            SourceLocation sourceLocation2;
            SourceLocation.DefinedLocation generatedLocation = mapping.getGeneratedLocation();
            SourceLocation it = sourceLocation2 = mapping.getSourceLocation();
            boolean bl2 = false;
            SourceLocation sourceLocation3 = sourceLocation = !Intrinsics.areEqual((Object)it, prev) || prevGeneratedLine != generatedLocation.getLine() ? sourceLocation2 : null;
            if (sourceLocation == null) {
                offsetExpectedNextLocation = -1;
                continue;
            }
            if (!(generatedLocation.getLine() >= prevGeneratedLine)) {
                boolean $i$a$-require-SourceMapGenerator$generate$22 = false;
                String $i$a$-require-SourceMapGenerator$generate$22 = "The order of the mapping is wrong";
                throw new IllegalArgumentException($i$a$-require-SourceMapGenerator$generate$22.toString());
            }
            if (prevGeneratedLine != generatedLocation.getLine()) {
                int n2 = generatedLocation.getLine() - prevGeneratedLine;
                int $i$a$-require-SourceMapGenerator$generate$22 = 0;
                while ($i$a$-require-SourceMapGenerator$generate$22 < n2) {
                    int it2 = $i$a$-require-SourceMapGenerator$generate$22++;
                    boolean bl3 = false;
                    sourceMapBuilder2.newLine();
                }
                prevGeneratedLine = generatedLocation.getLine();
            }
            if (Intrinsics.areEqual((Object)(sourceLocation2 = sourceLocation), (Object)SourceLocation.NoLocation.INSTANCE)) continue;
            if (Intrinsics.areEqual((Object)sourceLocation2, (Object)SourceLocation.NextLocation.INSTANCE)) {
                if (offsetExpectedNextLocation != -1) continue;
                offsetExpectedNextLocation = generatedLocation.getColumn();
                continue;
            }
            if (sourceLocation2 instanceof SourceLocation.WithFileAndLineNumberInformation) {
                String relativePath;
                String string;
                if (sourceLocation instanceof SourceLocation.DefinedLocation) {
                    string = pathResolver.getPathRelativeToSourceRootsIfExists(new File(((SourceLocation.DefinedLocation)sourceLocation).getFile()));
                    if (string == null) {
                        continue;
                    }
                } else {
                    string = relativePath = ((SourceLocation.WithFileAndLineNumberInformation)((Object)sourceLocation)).getFile();
                }
                if (offsetExpectedNextLocation != -1) {
                    SourceMap3Builder.addMapping$default(sourceMapBuilder2, relativePath, ((SourceLocation.WithFileAndLineNumberInformation)((Object)sourceLocation)).getLine(), ((SourceLocation.WithFileAndLineNumberInformation)((Object)sourceLocation)).getColumn(), offsetExpectedNextLocation, null, null, null, 112, null);
                    offsetExpectedNextLocation = -1;
                }
                SourceMap3Builder.addMapping$default(sourceMapBuilder2, relativePath, ((SourceLocation.WithFileAndLineNumberInformation)((Object)sourceLocation)).getLine(), ((SourceLocation.WithFileAndLineNumberInformation)((Object)sourceLocation)).getColumn(), generatedLocation.getColumn(), null, null, null, 112, null);
                prev = sourceLocation;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return sourceMapBuilder2.build();
    }

    private static final int generate$lambda$0() {
        throw new IllegalStateException("This should not be called for Kotlin/Wasm".toString());
    }
}

