/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeLabel;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.InlinedLocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.util.containers.BidirectionalMap;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\u0006\u0010A\u001a\u00020\u0001H\u0002J\u0018\u0010D\u001a\u00020.2\u0006\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010FJ\f\u0010N\u001a\b\u0012\u0004\u0012\u00020.0IJ\u000e\u0010O\u001a\u00020P2\u0006\u00101\u001a\u000200J\u000e\u0010Q\u001a\u00020P2\u0006\u00106\u001a\u000205J\u000e\u0010R\u001a\u00020P2\u0006\u0010:\u001a\u000200J\u000e\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020\rJ\u0014\u0010Y\u001a\u0004\u0018\u00010\u00142\b\u0010Z\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00030I2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\\\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010]\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\rH\u0016J\u0016\u0010^\u001a\u00020P2\u0006\u0010Z\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0014J\u000e\u0010_\u001a\u00020P2\u0006\u0010`\u001a\u00020.J\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010b\u001a\u00020P2\u0006\u0010T\u001a\u00020cH\u0002J\u0018\u0010d\u001a\u00020P2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010e\u001a\u00020\rH\u0002J\u0006\u0010f\u001a\u00020PJ\b\u0010g\u001a\u00020PH\u0002J\u0014\u0010h\u001a\u00020P*\u00020\r2\u0006\u0010i\u001a\u00020jH\u0002J\b\u0010k\u001a\u00020PH\u0002J\b\u0010l\u001a\u00020PH\u0002J\u0010\u0010m\u001a\u00020\r2\u0006\u0010n\u001a\u00020oH\u0002J\u0010\u0010p\u001a\u00020\r2\u0006\u0010i\u001a\u00020jH\u0002J\b\u0010q\u001a\u00020\u0000H\u0016J\u0012\u0010r\u001a\u0004\u0018\u00010,2\u0006\u0010Z\u001a\u00020\u0003H\u0016J\u0010\u0010s\u001a\u00020P2\u0006\u0010t\u001a\u00020\u0000H\u0002J\u001e\u0010u\u001a\u00020j2\u0006\u0010v\u001a\u00020o2\u0006\u0010w\u001a\u00020o2\u0006\u0010x\u001a\u00020jJ,\u0010y\u001a\u00020j2\u0006\u0010t\u001a\u00020\u00002\b\u0010v\u001a\u0004\u0018\u00010o2\b\u0010w\u001a\u0004\u0018\u00010o2\u0006\u0010z\u001a\u00020jH\u0002J9\u0010{\u001a\u00020P2\u0006\u0010|\u001a\u00020\r2\u0012\u0010}\u001a\u000e\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u00020.0~2\u0013\u0010\u007f\u001a\u000f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020o0\u0080\u0001H\u0002J%\u0010\u0081\u0001\u001a\u00020\r2\u0006\u0010T\u001a\u00020\r2\u0012\u0010}\u001a\u000e\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u00020.0~H\u0002J2\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020o0\u00172\r\u0010-\u001a\t\u0012\u0004\u0012\u00020o0\u0083\u00012\u0012\u0010}\u001a\u000e\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u00020.0~H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0015\u001a*\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00170\u0016j\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001a0\u0016j\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001a`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\r0\u001cj\b\u0012\u0004\u0012\u00020\r`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001f\u001a\u0004\u0018\u00010\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R!\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\r0\u001cj\b\u0012\u0004\u0012\u00020\r`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020,0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00103R\u000e\u0010<\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010=\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\n\"\u0004\b?\u0010@R\u0014\u0010B\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010!R\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\r0I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020\r0I8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010KR\u0014\u0010U\u001a\u00020V8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\u00a8\u0006\u0084\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "correspondingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInlined", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Z)V", "getCorrespondingElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "()Z", "mutableInstructionList", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getMutableInstructionList$cfg", "()Ljava/util/ArrayList;", "instructions", "getInstructions", "elementsToValues", "Lorg/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap;", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "valueUsages", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "mergedValues", "", "sideEffectFree", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "value", "parent", "getParent", "()Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "localDeclarations", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/LocalFunctionDeclarationInstruction;", "getLocalDeclarations", "()Ljava/util/Set;", "localDeclarations$delegate", "Lkotlin/Lazy;", "reachableInstructions", "getReachableInstructions", "()Ljava/util/HashSet;", "representativeInstructions", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstruction;", "labels", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeLabel;", "internalExitInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "exitInstruction", "getExitInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "internalSinkInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "sinkInstruction", "getSinkInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "internalErrorInstruction", "errorInstruction", "getErrorInstruction", "postPrecessed", "containsDoWhile", "getContainsDoWhile", "setContainsDoWhile$cfg", "(Z)V", "pseudocode", "rootPseudocode", "getRootPseudocode", "createLabel", "name", "", "comment", "reversedInstructions", "", "getReversedInstructions", "()Ljava/util/List;", "instructionsIncludingDeadCode", "getInstructionsIncludingDeadCode", "getLabels", "addExitInstruction", "", "addSinkInstruction", "addErrorInstruction", "addInstruction", "instruction", "enterInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "getEnterInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "getElementValue", "element", "getValueElements", "getUsages", "isSideEffectFree", "bindElementToValue", "bindLabel", "label", "getMergedValues", "addMergedValues", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "addValueUsage", "usage", "postProcess", "collectAndCacheReachableInstructions", "processInstruction", "currentPosition", "", "collectReachableInstructions", "markDeadInstructions", "getJumpTarget", "targetLabel", "Lorg/jetbrains/kotlin/cfg/Label;", "getNextPosition", "copy", "instructionForElement", "repeatWhole", "originalPseudocode", "repeatPart", "startLabel", "finishLabel", "labelCount", "repeatInternal", "labelCountArg", "repeatLabelsBindingForInstruction", "originalInstruction", "originalToCopy", "", "originalLabelsForInstruction", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "copyInstruction", "copyLabels", "", "cfg"})
@SourceDebugExtension(value={"SMAP\nPseudocodeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PseudocodeImpl.kt\norg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,456:1\n383#2,7:457\n1914#3,2:464\n1#4:466\n*S KotlinDebug\n*F\n+ 1 PseudocodeImpl.kt\norg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl\n*L\n222#1:457,7\n331#1:464,2\n*E\n"})
public final class PseudocodeImpl
implements Pseudocode {
    @NotNull
    private final KtElement correspondingElement;
    private final boolean isInlined;
    @NotNull
    private final ArrayList<Instruction> mutableInstructionList;
    @NotNull
    private final ArrayList<Instruction> instructions;
    @NotNull
    private final BidirectionalMap<KtElement, PseudoValue> elementsToValues;
    @NotNull
    private final HashMap<PseudoValue, List<Instruction>> valueUsages;
    @NotNull
    private final HashMap<PseudoValue, Set<PseudoValue>> mergedValues;
    @NotNull
    private final HashSet<Instruction> sideEffectFree;
    @Nullable
    private Pseudocode parent;
    @NotNull
    private final Lazy localDeclarations$delegate;
    @NotNull
    private final HashSet<Instruction> reachableInstructions;
    @NotNull
    private final HashMap<KtElement, KtElementInstruction> representativeInstructions;
    @NotNull
    private final ArrayList<PseudocodeLabel> labels;
    @Nullable
    private SubroutineExitInstruction internalExitInstruction;
    @Nullable
    private SubroutineSinkInstruction internalSinkInstruction;
    @Nullable
    private SubroutineExitInstruction internalErrorInstruction;
    private boolean postPrecessed;
    private boolean containsDoWhile;

    public PseudocodeImpl(@NotNull KtElement correspondingElement, boolean isInlined) {
        Intrinsics.checkNotNullParameter((Object)correspondingElement, (String)"correspondingElement");
        this.correspondingElement = correspondingElement;
        this.isInlined = isInlined;
        this.mutableInstructionList = new ArrayList();
        this.instructions = new ArrayList();
        this.elementsToValues = new BidirectionalMap();
        this.valueUsages = new HashMap();
        this.mergedValues = new HashMap();
        this.sideEffectFree = new HashSet();
        this.localDeclarations$delegate = LazyKt.lazy(() -> PseudocodeImpl.localDeclarations_delegate$lambda$0(this));
        this.reachableInstructions = new HashSet();
        this.representativeInstructions = new HashMap();
        this.labels = new ArrayList();
    }

    @Override
    @NotNull
    public KtElement getCorrespondingElement() {
        return this.correspondingElement;
    }

    @Override
    public boolean isInlined() {
        return this.isInlined;
    }

    @NotNull
    public final ArrayList<Instruction> getMutableInstructionList$cfg() {
        return this.mutableInstructionList;
    }

    @NotNull
    public ArrayList<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        Lazy lazy = this.localDeclarations$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final HashSet<Instruction> getReachableInstructions() {
        return this.reachableInstructions;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalExitInstruction;
        if (subroutineExitInstruction == null) {
            throw new AssertionError((Object)"Exit instruction is read before initialization");
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.internalSinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw new AssertionError((Object)"Sink instruction is read before initialization");
        }
        return subroutineSinkInstruction;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getErrorInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalErrorInstruction;
        if (subroutineExitInstruction == null) {
            throw new AssertionError((Object)"Error instruction is read before initialization");
        }
        return subroutineExitInstruction;
    }

    @Override
    public boolean getContainsDoWhile() {
        return this.containsDoWhile;
    }

    public void setContainsDoWhile$cfg(boolean bl) {
        this.containsDoWhile = bl;
    }

    private final Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(Pseudocode pseudocode) {
        LinkedHashSet<Instruction> localDeclarations = new LinkedHashSet<Instruction>();
        Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        Iterator<Instruction> iterator2 = ((PseudocodeImpl)pseudocode).mutableInstructionList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Instruction> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Instruction instruction = iterator3.next();
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations.add(instruction);
            localDeclarations.addAll((Collection)this.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        return localDeclarations;
    }

    @Override
    @NotNull
    public Pseudocode getRootPseudocode() {
        for (Pseudocode parent2 = this.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2.getParent() != null) continue;
            return parent2;
        }
        return this;
    }

    @NotNull
    public final PseudocodeLabel createLabel(@NotNull String name2, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PseudocodeLabel label = new PseudocodeLabel(this, name2, comment);
        this.labels.add(label);
        return label;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet traversedInstructions = new LinkedHashSet();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.isInlined() ? (Instruction)CollectionsKt.last((List)this.getInstructions()) : (Instruction)this.getSinkInstruction(), traversedInstructions, TraversalOrder.BACKWARD, null);
        if (traversedInstructions.size() < ((ArrayList)this.getInstructions()).size()) {
            List simplyReversedInstructions = CollectionsKt.reversed((Iterable)this.getInstructions());
            for (Instruction instruction : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction)) continue;
                PseudocodeTraverserKt.traverseFollowingInstructions(instruction, traversedInstructions, TraversalOrder.BACKWARD, null);
            }
        }
        return CollectionsKt.toList((Iterable)traversedInstructions);
    }

    @Override
    @NotNull
    public List<Instruction> getInstructionsIncludingDeadCode() {
        return this.mutableInstructionList;
    }

    @NotNull
    public final List<PseudocodeLabel> getLabels() {
        return this.labels;
    }

    public final void addExitInstruction(@NotNull SubroutineExitInstruction exitInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)exitInstruction, (String)"exitInstruction");
        this.addInstruction(exitInstruction);
        boolean bl2 = bl = this.internalExitInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Repeated initialization of exit instruction: " + this.internalExitInstruction + " --> " + exitInstruction;
            throw new AssertionError((Object)string);
        }
        this.internalExitInstruction = exitInstruction;
    }

    public final void addSinkInstruction(@NotNull SubroutineSinkInstruction sinkInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sinkInstruction, (String)"sinkInstruction");
        this.addInstruction(sinkInstruction);
        boolean bl2 = bl = this.internalSinkInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Repeated initialization of sink instruction: " + this.internalSinkInstruction + " --> " + sinkInstruction;
            throw new AssertionError((Object)string);
        }
        this.internalSinkInstruction = sinkInstruction;
    }

    public final void addErrorInstruction(@NotNull SubroutineExitInstruction errorInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)errorInstruction, (String)"errorInstruction");
        this.addInstruction(errorInstruction);
        boolean bl2 = bl = this.internalErrorInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Repeated initialization of error instruction: " + this.internalErrorInstruction + " --> " + errorInstruction;
            throw new AssertionError((Object)string);
        }
        this.internalErrorInstruction = errorInstruction;
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        KtElement element;
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof KtElementInstruction && !this.representativeInstructions.containsKey(element = ((KtElementInstruction)instruction).getElement())) {
            ((Map)this.representativeInstructions).put(element, instruction);
        }
        if (instruction instanceof MergeInstruction) {
            this.addMergedValues((MergeInstruction)instruction);
        }
        for (PseudoValue inputValue : instruction.getInputValues()) {
            this.addValueUsage(inputValue, instruction);
            for (PseudoValue mergedValue : this.getMergedValues(inputValue)) {
                this.addValueUsage(mergedValue, instruction);
            }
        }
        if (PseudocodeUtilsKt.calcSideEffectFree(instruction)) {
            this.sideEffectFree.add(instruction);
        }
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        Instruction instruction = this.mutableInstructionList.get(0);
        Intrinsics.checkNotNull((Object)instruction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction");
        return (SubroutineEnterInstruction)instruction;
    }

    @Override
    @Nullable
    public PseudoValue getElementValue(@Nullable KtElement element) {
        return this.elementsToValues.get(element);
    }

    @Override
    @NotNull
    public List<KtElement> getValueElements(@Nullable PseudoValue value2) {
        List list = this.elementsToValues.getKeysByValue(value2);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Instruction> getUsages(@Nullable PseudoValue value2) {
        List list = (List)((Map)this.valueUsages).get(value2);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @Override
    public boolean isSideEffectFree(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        return this.sideEffectFree.contains(instruction);
    }

    public final void bindElementToValue(@NotNull KtElement element, @NotNull PseudoValue value2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.elementsToValues.put(element, value2);
    }

    public final void bindLabel(@NotNull PseudocodeLabel label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)label.getPseudocode());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Attempt to bind label " + label + " to instruction from different pseudocode: \nowner pseudocode = " + label.getPseudocode().mutableInstructionList + ", \nbound pseudocode = " + this.mutableInstructionList;
            throw new AssertionError((Object)string);
        }
        label.setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    private final Set<PseudoValue> getMergedValues(PseudoValue value2) {
        Set set = this.mergedValues.get(value2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void addMergedValues(MergeInstruction instruction) {
        LinkedHashSet<PseudoValue> result2 = new LinkedHashSet<PseudoValue>();
        for (PseudoValue value2 : instruction.getInputValues()) {
            result2.addAll((Collection)this.getMergedValues(value2));
            result2.add(value2);
        }
        this.mergedValues.put(instruction.getOutputValue(), result2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addValueUsage(PseudoValue value2, Instruction usage) {
        Object object;
        void key$iv;
        void $this$getOrPut$iv;
        if (usage instanceof MergeInstruction) {
            return;
        }
        Map map = this.valueUsages;
        PseudoValue pseudoValue = value2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(usage);
    }

    public final void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.getErrorInstruction().setSink(this.getSinkInstruction());
        this.getExitInstruction().setSink(this.getSinkInstruction());
        Iterator iterator2 = ((Iterable)this.mutableInstructionList).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            Instruction instruction = (Instruction)iterator2.next();
            this.processInstruction(instruction, index);
        }
        this.collectAndCacheReachableInstructions();
    }

    private final void collectAndCacheReachableInstructions() {
        this.collectReachableInstructions();
        Iterator<Instruction> iterator2 = this.mutableInstructionList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Instruction> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Instruction instruction = iterator3.next();
            if (!this.reachableInstructions.contains(instruction)) continue;
            ((ArrayList)this.getInstructions()).add(instruction);
        }
        this.markDeadInstructions();
    }

    private final void processInstruction(Instruction $this$processInstruction, int currentPosition) {
        $this$processInstruction.accept(new InstructionVisitor(this, currentPosition){
            final /* synthetic */ PseudocodeImpl this$0;
            final /* synthetic */ int $currentPosition;
            {
                this.this$0 = $receiver;
                this.$currentPosition = $currentPosition;
            }

            public void visitInstructionWithNext(InstructionWithNext instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
            }

            public void visitJump(AbstractJumpInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                instruction.setResolvedTarget(PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel()));
            }

            public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.access$getJumpTarget(this.this$0, targetLabel));
                }
            }

            public void visitConditionalJump(ConditionalJumpInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Instruction nextInstruction = PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition);
                Instruction jumpTarget = PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel());
                if (instruction.getOnTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            public void visitLocalFunctionDeclarationInstruction(LocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Pseudocode pseudocode = instruction.getBody();
                Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                PseudocodeImpl body = (PseudocodeImpl)pseudocode;
                PseudocodeImpl.access$setParent$p(body, this.this$0);
                body.postProcess();
                instruction.setNext(this.this$0.getSinkInstruction());
            }

            public void visitInlinedLocalFunctionDeclarationInstruction(InlinedLocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Pseudocode pseudocode = instruction.getBody();
                Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                PseudocodeImpl body = (PseudocodeImpl)pseudocode;
                PseudocodeImpl.access$setParent$p(body, this.this$0);
                body.postProcess();
                instruction.setNext(((ArrayList)body.getInstructions()).contains(body.getExitInstruction()) ? PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition) : (Instruction)this.this$0.getSinkInstruction());
            }

            public void visitSubroutineExit(SubroutineExitInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            }

            public void visitSubroutineSink(SubroutineSinkInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            }

            public void visitInstruction(Instruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                throw new UnsupportedOperationException(instruction.toString());
            }
        });
    }

    private final void collectReachableInstructions() {
        HashSet<InstructionImpl> reachableFromThisPseudocode = new HashSet<InstructionImpl>();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.getEnterInstruction(), (Set<Instruction>)reachableFromThisPseudocode, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)PseudocodeImpl::collectReachableInstructions$lambda$0));
        if (!this.isInlined()) {
            reachableFromThisPseudocode.add(this.getExitInstruction());
            reachableFromThisPseudocode.add(this.getErrorInstruction());
            reachableFromThisPseudocode.add(this.getSinkInstruction());
        }
        Iterable $this$forEach$iv = reachableFromThisPseudocode;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            Pseudocode pseudocode = it.getOwner();
            Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
            ((PseudocodeImpl)pseudocode).reachableInstructions.add(it);
        }
    }

    private final void markDeadInstructions() {
        HashSet instructionSet = CollectionsKt.toHashSet((Iterable)this.getInstructions());
        Iterator<Instruction> iterator2 = this.mutableInstructionList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Instruction> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Instruction instruction = iterator3.next();
            if (instructionSet.contains(instruction)) continue;
            InstructionImpl instructionImpl = instruction instanceof InstructionImpl ? (InstructionImpl)instruction : null;
            if (instructionImpl != null) {
                instructionImpl.setMarkedAsDead(true);
            }
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                Object object = nextInstruction instanceof InstructionImpl ? (InstructionImpl)nextInstruction : null;
                if (object == null || (object = ((InstructionImpl)object).getPreviousInstructions()) == null) continue;
                object.remove(instruction);
            }
        }
    }

    private final Instruction getJumpTarget(Label targetLabel) {
        return targetLabel.resolveToInstruction();
    }

    private final Instruction getNextPosition(int currentPosition) {
        boolean bl;
        int targetPosition = currentPosition + 1;
        boolean bl2 = bl = targetPosition < this.mutableInstructionList.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            Integer n2 = currentPosition;
            throw new AssertionError(n2);
        }
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        Intrinsics.checkNotNullExpressionValue((Object)instruction, (String)"get(...)");
        return instruction;
    }

    @Override
    @NotNull
    public PseudocodeImpl copy() {
        PseudocodeImpl result2 = new PseudocodeImpl(this.getCorrespondingElement(), this.isInlined());
        result2.repeatWhole(this);
        return result2;
    }

    @Override
    @Nullable
    public KtElementInstruction instructionForElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.representativeInstructions.get(element);
    }

    private final void repeatWhole(PseudocodeImpl originalPseudocode) {
        this.repeatInternal(originalPseudocode, null, null, 0);
        this.parent = originalPseudocode.getParent();
    }

    public final int repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel, int labelCount) {
        Intrinsics.checkNotNullParameter((Object)startLabel, (String)"startLabel");
        Intrinsics.checkNotNullParameter((Object)finishLabel, (String)"finishLabel");
        Pseudocode pseudocode = startLabel.getPseudocode();
        Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        return this.repeatInternal((PseudocodeImpl)pseudocode, startLabel, finishLabel, labelCount);
    }

    private final int repeatInternal(PseudocodeImpl originalPseudocode, Label startLabel, Label finishLabel, int labelCountArg) {
        PseudocodeLabel label;
        int labelCount = labelCountArg;
        Label label2 = startLabel;
        int startIndex = label2 != null ? label2.getTargetInstructionIndex() : 0;
        Label label3 = finishLabel;
        int finishIndex = label3 != null ? label3.getTargetInstructionIndex() : originalPseudocode.mutableInstructionList.size();
        LinkedHashMap<PseudocodeLabel, PseudocodeLabel> originalToCopy = new LinkedHashMap<PseudocodeLabel, PseudocodeLabel>();
        HashMultimap originalLabelsForInstruction = HashMultimap.create();
        Iterator<PseudocodeLabel> iterator2 = originalPseudocode.labels.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<PseudocodeLabel> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            int index = label.getTargetInstructionIndex();
            if (index < 0 || label == startLabel || label == finishLabel) continue;
            boolean bl = startIndex <= index ? index <= finishIndex : false;
            if (!bl) continue;
            originalToCopy.put(label, label.copy(this, labelCount++));
            originalLabelsForInstruction.put(this.getJumpTarget(label), label);
        }
        iterator3 = originalToCopy.values().iterator();
        while (iterator3.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            this.labels.add(label);
        }
        for (int index = startIndex; index < finishIndex; ++index) {
            Instruction originalInstruction;
            Intrinsics.checkNotNullExpressionValue((Object)originalPseudocode.mutableInstructionList.get(index), (String)"get(...)");
            Map map = originalToCopy;
            Intrinsics.checkNotNull(originalLabelsForInstruction);
            this.repeatLabelsBindingForInstruction(originalInstruction, map, originalLabelsForInstruction);
            Instruction copy = this.copyInstruction(originalInstruction, (Map<Label, PseudocodeLabel>)originalToCopy);
            this.addInstruction(copy);
            if (originalInstruction == originalPseudocode.internalErrorInstruction && copy instanceof SubroutineExitInstruction) {
                this.internalErrorInstruction = (SubroutineExitInstruction)copy;
            }
            if (originalInstruction == originalPseudocode.internalExitInstruction && copy instanceof SubroutineExitInstruction) {
                this.internalExitInstruction = (SubroutineExitInstruction)copy;
            }
            if (originalInstruction != originalPseudocode.internalSinkInstruction || !(copy instanceof SubroutineSinkInstruction)) continue;
            this.internalSinkInstruction = (SubroutineSinkInstruction)copy;
        }
        if (finishIndex < originalPseudocode.mutableInstructionList.size()) {
            Instruction instruction = originalPseudocode.mutableInstructionList.get(finishIndex);
            Intrinsics.checkNotNullExpressionValue((Object)instruction, (String)"get(...)");
            Map map = originalToCopy;
            Intrinsics.checkNotNull(originalLabelsForInstruction);
            this.repeatLabelsBindingForInstruction(instruction, map, originalLabelsForInstruction);
        }
        return labelCount;
    }

    private final void repeatLabelsBindingForInstruction(Instruction originalInstruction, Map<Label, PseudocodeLabel> originalToCopy, Multimap<Instruction, Label> originalLabelsForInstruction) {
        for (Label originalLabel : originalLabelsForInstruction.get(originalInstruction)) {
            PseudocodeLabel pseudocodeLabel = originalToCopy.get(originalLabel);
            Intrinsics.checkNotNull((Object)pseudocodeLabel);
            this.bindLabel(pseudocodeLabel);
        }
    }

    private final Instruction copyInstruction(Instruction instruction, Map<Label, PseudocodeLabel> originalToCopy) {
        Label originalTarget;
        PseudocodeLabel item;
        if (instruction instanceof AbstractJumpInstruction && (item = originalToCopy.get(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) != null) {
            return ((AbstractJumpInstruction)instruction).copy(item);
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = this.copyLabels((Collection<? extends Label>)originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        Intrinsics.checkNotNull((Object)instruction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl");
        return ((InstructionImpl)instruction).copy();
    }

    private final List<Label> copyLabels(Collection<? extends Label> labels, Map<Label, PseudocodeLabel> originalToCopy) {
        ArrayList<Label> newLabels = new ArrayList<Label>();
        for (Label label : labels) {
            PseudocodeLabel newLabel;
            PseudocodeLabel pseudocodeLabel = newLabel = originalToCopy.get(label);
            newLabels.add(pseudocodeLabel != null ? (Label)pseudocodeLabel : label);
        }
        return newLabels;
    }

    private static final Set localDeclarations_delegate$lambda$0(PseudocodeImpl this$0) {
        return this$0.getLocalDeclarations(this$0);
    }

    private static final TraverseInstructionResult collectReachableInstructions$lambda$0(Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (instruction instanceof MagicInstruction && ((MagicInstruction)instruction).getKind() == MagicKind.EXHAUSTIVE_WHEN_ELSE) {
            return TraverseInstructionResult.SKIP;
        }
        return TraverseInstructionResult.CONTINUE;
    }

    public static final /* synthetic */ Instruction access$getNextPosition(PseudocodeImpl $this, int currentPosition) {
        return $this.getNextPosition(currentPosition);
    }

    public static final /* synthetic */ Instruction access$getJumpTarget(PseudocodeImpl $this, Label targetLabel) {
        return $this.getJumpTarget(targetLabel);
    }

    public static final /* synthetic */ void access$setParent$p(PseudocodeImpl $this, Pseudocode pseudocode) {
        $this.parent = pseudocode;
    }
}

