/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessor;
import org.jetbrains.kotlin.codegen.inline.Interval;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.SplitPair;
import org.jetbrains.kotlin.codegen.inline.SplittableInterval;
import org.jetbrains.kotlin.com.google.common.collect.LinkedListMultimap;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u0013\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\n2\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J\"\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000.0 2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020$2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201J\u0016\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u000201J)\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000.2\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00107J)\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000.2\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00107J<\u00109\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010 0:2\u0006\u00104\u001a\u00020\n2\u0006\u0010;\u001a\u000201H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RQ\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRQ\u0010\u000e\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "T", "Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;", "", "processor", "Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;", "<init>", "(Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;)V", "intervalStarts", "Lorg/jetbrains/kotlin/com/google/common/collect/LinkedListMultimap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "kotlin.jvm.PlatformType", "getIntervalStarts", "()Lcom/google/common/collect/LinkedListMultimap;", "intervalEnds", "getIntervalEnds", "allIntervals", "Ljava/util/ArrayList;", "getAllIntervals", "()Ljava/util/ArrayList;", "currentIntervals", "", "getCurrentIntervals", "()Ljava/util/Set;", "intersection", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "interval", "other", "Lorg/jetbrains/kotlin/codegen/inline/Interval;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;Lorg/jetbrains/kotlin/codegen/inline/Interval;)Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;", "copyIntervalsForRange", "", "startLabel", "endLabel", "addNewInterval", "", "newInfo", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "remapStartLabel", "oldStart", "remapped", "(Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "remapEndLabel", "oldEnd", "splitCurrentIntervals", "Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "by", "keepStart", "", "splitAndRemoveCurrentIntervals", "processCurrent", "curIns", "directOrder", "split", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;Lorg/jetbrains/kotlin/codegen/inline/Interval;Z)Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "splitAndRemoveIntervalFromCurrents", "getInterval", "", "isOpen", "backend"})
@SourceDebugExtension(value={"SMAP\nCoveringTryCatchNodeProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoveringTryCatchNodeProcessor.kt\norg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1641#2,10:241\n1914#2:251\n1915#2:253\n1651#2:254\n1585#2:255\n1660#2,3:256\n1914#2,2:259\n1914#2:261\n1915#2:263\n1914#2,2:264\n1#3:252\n1#3:262\n*S KotlinDebug\n*F\n+ 1 CoveringTryCatchNodeProcessor.kt\norg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo\n*L\n116#1:241,10\n116#1:251\n116#1:253\n116#1:254\n139#1:255\n139#1:256,3\n143#1:259,2\n147#1:261\n147#1:263\n152#1:264,2\n116#1:252\n*E\n"})
public final class IntervalMetaInfo<T extends SplittableInterval<? extends T>> {
    @NotNull
    private final CoveringTryCatchNodeProcessor processor;
    private final LinkedListMultimap<LabelNode, T> intervalStarts;
    private final LinkedListMultimap<LabelNode, T> intervalEnds;
    @NotNull
    private final ArrayList<T> allIntervals;
    @NotNull
    private final Set<T> currentIntervals;

    public IntervalMetaInfo(@NotNull CoveringTryCatchNodeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.processor = processor;
        this.intervalStarts = LinkedListMultimap.create();
        this.intervalEnds = LinkedListMultimap.create();
        this.allIntervals = new ArrayList();
        this.currentIntervals = new LinkedHashSet();
    }

    public final LinkedListMultimap<LabelNode, T> getIntervalStarts() {
        return this.intervalStarts;
    }

    public final LinkedListMultimap<LabelNode, T> getIntervalEnds() {
        return this.intervalEnds;
    }

    @NotNull
    public final ArrayList<T> getAllIntervals() {
        return this.allIntervals;
    }

    @NotNull
    public final Set<T> getCurrentIntervals() {
        return this.currentIntervals;
    }

    @Nullable
    public final T intersection(@NotNull InsnList instructions, @NotNull T interval, @NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int startIndex = instructions.indexOf(((Interval)interval).getStartLabel());
        int endIndex = instructions.indexOf(((Interval)interval).getEndLabel());
        int otherStartIndex = instructions.indexOf(other.getStartLabel());
        int otherEndIndex = instructions.indexOf(other.getEndLabel());
        int newStartIndex = Math.max(startIndex, otherStartIndex);
        int newEndIndex = Math.min(endIndex, otherEndIndex);
        if (newStartIndex >= newEndIndex) {
            return null;
        }
        LabelNode newStartLabel = startIndex == newStartIndex ? ((Interval)interval).getStartLabel() : other.getStartLabel();
        LabelNode newEndLabel = endIndex == newEndIndex ? ((Interval)interval).getEndLabel() : other.getEndLabel();
        return (T)((SplittableInterval)interval.copyWithNewBounds(new SimpleInterval(newStartLabel, newEndLabel)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> copyIntervalsForRange(@NotNull InsnList instructions, @NotNull LabelNode startLabel, @NotNull LabelNode endLabel) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        Intrinsics.checkNotNullParameter((Object)startLabel, (String)"startLabel");
        Intrinsics.checkNotNullParameter((Object)endLabel, (String)"endLabel");
        SimpleInterval finallyInterval = new SimpleInterval(startLabel, endLabel);
        Iterable $this$mapNotNull$iv = this.allIntervals;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SplittableInterval it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SplittableInterval it = (SplittableInterval)element$iv$iv;
            boolean bl2 = false;
            if (this.intersection(instructions, it, finallyInterval) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void addNewInterval(@NotNull T newInfo) {
        Intrinsics.checkNotNullParameter(newInfo, (String)"newInfo");
        ((Interval)newInfo).verify(this.processor);
        this.intervalStarts.put(((Interval)newInfo).getStartLabel(), newInfo);
        this.intervalEnds.put(((Interval)newInfo).getEndLabel(), newInfo);
        this.allIntervals.add(newInfo);
    }

    private final void remapStartLabel(LabelNode oldStart, T remapped) {
        ((Interval)remapped).verify(this.processor);
        this.intervalStarts.remove(oldStart, remapped);
        this.intervalStarts.put(((Interval)remapped).getStartLabel(), remapped);
    }

    private final void remapEndLabel(LabelNode oldEnd, T remapped) {
        ((Interval)remapped).verify(this.processor);
        this.intervalEnds.remove(oldEnd, remapped);
        this.intervalEnds.put(((Interval)remapped).getEndLabel(), remapped);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SplitPair<T>> splitCurrentIntervals(@NotNull Interval by, boolean keepStart) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Iterable $this$map$iv = this.currentIntervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SplittableInterval splittableInterval = (SplittableInterval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.split(it, by, keepStart));
        }
        return (List)destination$iv$iv;
    }

    public final void splitAndRemoveCurrentIntervals(@NotNull Interval by, boolean keepStart) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.currentIntervals);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SplittableInterval it = (SplittableInterval)element$iv;
            boolean bl = false;
            this.splitAndRemoveIntervalFromCurrents(it, by, keepStart);
        }
    }

    public final void processCurrent(@NotNull LabelNode curIns, boolean directOrder) {
        SplittableInterval it;
        Intrinsics.checkNotNullParameter((Object)curIns, (String)"curIns");
        List<T> list = this.getInterval(curIns, directOrder);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInterval(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SplittableInterval)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean added = this.currentIntervals.add(it);
            if (!_Assertions.ENABLED || added) continue;
            boolean $i$a$-assert-IntervalMetaInfo$processCurrent$1$22 = false;
            String $i$a$-assert-IntervalMetaInfo$processCurrent$1$22 = "Wrong interval structure: " + curIns + ", " + it;
            throw new AssertionError((Object)$i$a$-assert-IntervalMetaInfo$processCurrent$1$22);
        }
        List<T> list2 = this.getInterval(curIns, !directOrder);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInterval(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SplittableInterval)element$iv;
            boolean bl = false;
            boolean removed = this.currentIntervals.remove(it);
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl2 = false;
            String string = "Wrong interval structure: " + curIns + ", " + it;
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final SplitPair<T> split(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        SplitPair split = interval.split(by, keepStart);
        if (!keepStart) {
            this.remapStartLabel(split.getNewPart().getStartLabel(), (SplittableInterval)split.getPatchedPart());
        } else {
            this.remapEndLabel(split.getNewPart().getEndLabel(), (SplittableInterval)split.getPatchedPart());
        }
        this.addNewInterval((SplittableInterval)split.getNewPart());
        return split;
    }

    @NotNull
    public final SplitPair<T> splitAndRemoveIntervalFromCurrents(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        SplitPair<T> splitPair = this.split(interval, by, keepStart);
        boolean removed = this.currentIntervals.remove(splitPair.getPatchedPart());
        if (_Assertions.ENABLED && !removed) {
            boolean bl = false;
            String string = "Wrong interval structure: " + splitPair;
            throw new AssertionError((Object)string);
        }
        return splitPair;
    }

    private final List<T> getInterval(LabelNode curIns, boolean isOpen) {
        return isOpen ? this.intervalStarts.get((Object)curIns) : this.intervalEnds.get((Object)curIns);
    }
}

