/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010 \u001a\u00020\u0012J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010(\u001a\u00020+H\u0002J \u0010,\u001a\u00020\"2\u0006\u0010(\u001a\u00020-2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0002J\b\u0010/\u001a\u00020\"H\u0002J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\u0003H\u0002J\u0010\u00102\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\u00020\u0010*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/InstructionLivenessAnalyzer;", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "visitExceptionHandlers", "", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Z)V", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "getVisitExceptionHandlers", "()Z", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "nInsns", "", "isLive", "", "handlers", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "queued", "queue", "", "top", "indexOf", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getIndexOf", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)I", "analyze", "traverseCfg", "", "localVariableAndTryCatchBlockLabelsAreAlwaysLive", "checkAssertions", "visitOpInsn", "insn", "visitTableSwitchInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitJumpInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "initControlFlowAnalysis", "computeExceptionHandlersForEachInsn", "m", "visitControlFlowEdge", "backend"})
@SourceDebugExtension(value={"SMAP\nInstructionLivenessAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionLivenessAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/common/InstructionLivenessAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1914#2,2:186\n1806#2,3:188\n*S KotlinDebug\n*F\n+ 1 InstructionLivenessAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/common/InstructionLivenessAnalyzer\n*L\n99#1:186,2\n120#1:188,3\n*E\n"})
public final class InstructionLivenessAnalyzer {
    @NotNull
    private final MethodNode method;
    private final boolean visitExceptionHandlers;
    private final InsnList instructions;
    private final int nInsns;
    @NotNull
    private final boolean[] isLive;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    public InstructionLivenessAnalyzer(@NotNull MethodNode method, boolean visitExceptionHandlers) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.method = method;
        this.visitExceptionHandlers = visitExceptionHandlers;
        this.instructions = this.method.instructions;
        this.nInsns = this.instructions.size();
        this.isLive = new boolean[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    public /* synthetic */ InstructionLivenessAnalyzer(MethodNode methodNode, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(methodNode, bl);
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    public final boolean getVisitExceptionHandlers() {
        return this.visitExceptionHandlers;
    }

    private final int getIndexOf(AbstractInsnNode $this$indexOf) {
        return this.instructions.indexOf($this$indexOf);
    }

    @NotNull
    public final boolean[] analyze() {
        if (this.nInsns == 0) {
            return this.isLive;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        this.initControlFlowAnalysis();
        this.traverseCfg();
        this.localVariableAndTryCatchBlockLabelsAreAlwaysLive();
        if (this.instructions.getLast() instanceof LabelNode) {
            AbstractInsnNode abstractInsnNode = this.instructions.getLast();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"getLast(...)");
            this.isLive[this.getIndexOf((AbstractInsnNode)abstractInsnNode)] = true;
        }
        return this.isLive;
    }

    private final void traverseCfg() {
        while (this.top > 0) {
            this.top += -1;
            int insn = this.queue[this.top];
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            int insnOpcode = insnNode.getOpcode();
            Intrinsics.checkNotNull((Object)insnNode);
            switch (UtilKt.getNodeType(insnNode)) {
                case 8: 
                case 14: 
                case 15: {
                    this.visitOpInsn(insn);
                    break;
                }
                case 7: {
                    this.visitJumpInsnNode((JumpInsnNode)insnNode, insn, insnOpcode);
                    break;
                }
                case 12: {
                    this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode);
                    break;
                }
                case 11: {
                    this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode);
                    break;
                }
                default: {
                    if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                    this.visitOpInsn(insn);
                }
            }
            if (!this.visitExceptionHandlers) continue;
            List<TryCatchBlockNode> list = this.handlers[insn];
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                boolean bl = false;
                LabelNode labelNode = tcb.handler;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"handler");
                this.visitControlFlowEdge(this.getIndexOf(labelNode));
            }
        }
    }

    private final void localVariableAndTryCatchBlockLabelsAreAlwaysLive() {
        for (LocalVariableNode localVariable : this.method.localVariables) {
            LabelNode labelNode = localVariable.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
            LabelNode labelNode2 = localVariable.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"end");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode2))] = true;
        }
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
            LabelNode labelNode3 = tcb.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode3, (String)"end");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode3))] = true;
            LabelNode labelNode4 = tcb.handler;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode4, (String)"handler");
            this.isLive[this.getIndexOf((AbstractInsnNode)((AbstractInsnNode)labelNode4))] = true;
        }
    }

    private final void checkAssertions() {
        boolean bl;
        block4: {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterable $this$any$iv = insnList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    private final void visitOpInsn(int insn) {
        this.visitControlFlowEdge(insn + 1);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"dflt");
        int jump = this.getIndexOf(labelNode);
        this.visitControlFlowEdge(jump);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNull((Object)label);
            jump = this.getIndexOf(label);
            this.visitControlFlowEdge(jump);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"dflt");
        int jump = this.getIndexOf(labelNode);
        this.visitControlFlowEdge(jump);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNull((Object)label);
            jump = this.getIndexOf(label);
            this.visitControlFlowEdge(jump);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, int insn, int insnOpcode) {
        if (insnOpcode != 167 && insnOpcode != 168) {
            this.visitControlFlowEdge(insn + 1);
        }
        LabelNode labelNode = insnNode.label;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"label");
        int jump = this.getIndexOf(labelNode);
        this.visitControlFlowEdge(jump);
    }

    private final void initControlFlowAnalysis() {
        this.visitControlFlowEdge(0);
    }

    private final void computeExceptionHandlersForEachInsn(MethodNode m2) {
        if (!this.visitExceptionHandlers) {
            return;
        }
        for (TryCatchBlockNode tcb : m2.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
            int begin = this.getIndexOf(labelNode);
            LabelNode labelNode2 = tcb.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"end");
            int end = this.getIndexOf(labelNode2);
            for (int j2 = begin; j2 < end; ++j2) {
                AbstractInsnNode abstractInsnNode = this.instructions.get(j2);
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"get(...)");
                if (!UtilKt.isMeaningful(abstractInsnNode)) continue;
                List insnHandlers = this.handlers[j2];
                if (insnHandlers == null) {
                    this.handlers[j2] = insnHandlers = (List)new ArrayList();
                }
                Intrinsics.checkNotNull((Object)tcb);
                insnHandlers.add(tcb);
            }
        }
    }

    private final void visitControlFlowEdge(int insn) {
        boolean changes = !this.isLive[insn];
        this.isLive[insn] = true;
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            int n2 = this.top;
            this.top = n2 + 1;
            this.queue[n2] = insn;
        }
    }
}

