/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.SuspendCallArgumentKind;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.InlineStatus;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u000256B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJA\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0002H\u0002J\u001f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001cJ9\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00022\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00172\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u001a*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+H\u0002J \u0010,\u001a\u00020-*\u00020\u00022\u0006\u0010%\u001a\u00020&2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J,\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020)0/2\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0/H\u0002J9\u00103\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00104\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkSuspendModifierForm", "reference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "formOfSuspendModifierForLambdaOrFun", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/SuspendCallArgumentKind;", "findEnclosingSuspendFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "isInScopeForDefaultParameterValues", "", "enclosingSuspendFunction", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Z", "checkNonLocalReturnUsage", "checkRestrictsSuspension", "calledDeclarationSymbol", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isCaseMissedByK1", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "isRestrictSuspensionReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "sameInstanceOfReceiver", "useSiteReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "declarationSiteReceiverOwnerSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "computeReceiversInfo", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiversInfo;", "zipReceiverInfo", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiverInfo;", "expressions", "types", "checkCallableReference", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "ReceiversInfo", "ReceiverInfo", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuspendCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n35#2:383\n35#2:394\n35#2:395\n32#2:397\n1806#3,3:384\n545#3,4:390\n550#3:396\n1806#3,3:398\n776#3:401\n872#3,2:402\n776#3:404\n872#3,2:405\n1806#3,3:408\n1806#3,3:411\n1585#3:414\n1660#3,3:415\n1585#3:418\n1660#3,3:419\n3589#3,7:422\n57#4:387\n57#4:389\n57#4:407\n1#5:388\n*S KotlinDebug\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n*L\n57#1:383\n146#1:394\n148#1:395\n164#1:397\n118#1:384,3\n143#1:390,4\n143#1:396\n210#1:398,3\n217#1:401\n217#1:402,2\n276#1:404\n276#1:405,2\n290#1:408,3\n293#1:411,3\n342#1:414\n342#1:415,3\n357#1:418\n357#1:419,3\n362#1:422,7\n119#1:387\n129#1:389\n280#1:407\n*E\n"})
public final class FirSuspendCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuspendCallChecker INSTANCE = new FirSuspendCallChecker();

    private FirSuspendCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirFunctionSymbol<?> enclosingSuspendFunction;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        FirCallableSymbol firCallableSymbol = reference2.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firCallableSymbol : null;
        if (firCallableSymbol2 == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol2;
        if (Intrinsics.areEqual((Object)reference2.getName(), (Object)StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName()) || symbol instanceof FirNamedFunctionSymbol && Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)symbol).getName(), (Object)StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName())) {
            this.checkSuspendModifierForm(context2, reporter, expression2, reference2, symbol);
        }
        if (reference2 instanceof FirResolvedCallableReference) {
            this.checkCallableReference(reporter, context2, expression2, symbol);
            return;
        }
        FirCallableSymbol firCallableSymbol3 = symbol;
        if (firCallableSymbol3 instanceof FirNamedFunctionSymbol) {
            FirCallableSymbol $this$isSuspend$iv = symbol;
            boolean $i$f$isSuspend = false;
            if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
                return;
            }
        } else if (firCallableSymbol3 instanceof FirPropertySymbol) {
            if (!Intrinsics.areEqual((Object)((FirPropertySymbol)symbol).getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = this.findEnclosingSuspendFunction(context2)) == null) {
            firCallableSymbol = symbol;
            if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), (Object)symbol, null, 16, null);
            } else if (firCallableSymbol instanceof FirPropertySymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), (Object)symbol, null, 16, null);
            }
        } else {
            if (!this.checkNonLocalReturnUsage(context2, enclosingSuspendFunction)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), null, 8, null);
            }
            if (this.isInScopeForDefaultParameterValues(context2, enclosingSuspendFunction)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Suspend function call in default parameter value is unsupported.", null, 16, null);
            }
            if (!this.checkRestrictsSuspension(context2, expression2, enclosingSuspendFunction, symbol)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), null, 8, null);
            }
        }
    }

    private final void checkSuspendModifierForm(CheckerContext context2, DiagnosticReporter reporter, FirQualifiedAccessExpression expression2, FirResolvedNamedReference reference2, FirCallableSymbol<?> symbol) {
        if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getSuspend())) {
            if (!Intrinsics.areEqual((Object)reference2.getName(), (Object)StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName()) || expression2.getExplicitReceiver() != null || this.formOfSuspendModifierForLambdaOrFun(expression2) == null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), null, 8, null);
            }
        } else if (Intrinsics.areEqual((Object)reference2.getName(), (Object)StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName())) {
            SuspendCallArgumentKind suspendCallArgumentKind = this.formOfSuspendModifierForLambdaOrFun(expression2);
            switch (suspendCallArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[suspendCallArgumentKind.ordinal()]) {
                case 1: {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN(), null, 8, null);
                    break;
                }
                case 2: {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), null, 8, null);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final SuspendCallArgumentKind formOfSuspendModifierForLambdaOrFun(FirQualifiedAccessExpression $this$formOfSuspendModifierForLambdaOrFun) {
        boolean bl;
        block19: {
            if (!($this$formOfSuspendModifierForLambdaOrFun instanceof FirFunctionCall)) {
                return null;
            }
            FirNamedReference reference2 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getCalleeReference();
            if (reference2 instanceof FirResolvedCallableReference) {
                return null;
            }
            Iterable $this$any$iv = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getTypeArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeProjection it = (FirTypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!FirHelpersKt.isExplicit(it)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        FirCall $this$arguments$iv = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
        boolean $i$f$getArguments = false;
        FirExpression it = (FirExpression)CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        boolean bl3 = false;
        boolean bl4 = it instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)it).isTrailingLambda();
        if (bl4) {
            KtSourceElement ktSourceElement;
            KtSourceElement callExpressionSource;
            KtSourceElement ktSourceElement2;
            if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getExplicitReceiver() == null) {
                ktSourceElement2 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
            } else {
                KtSourceElement ktSourceElement3 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
                if (ktSourceElement3 != null) {
                    IElementType iElementType = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CALL_EXPRESSION");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, iElementType, 1, 1, false, 8, null);
                } else {
                    ktSourceElement2 = null;
                }
            }
            KtSourceElement ktSourceElement4 = callExpressionSource = ktSourceElement2;
            if (ktSourceElement4 != null) {
                IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALUE_ARGUMENT_LIST");
                ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement4, iElementType, 0, 1, false, 10, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement == null) {
                return SuspendCallArgumentKind.LAMBDA;
            }
        }
        if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getOrigin() == FirFunctionCallOrigin.Infix) {
            FirCall $this$arguments$iv2 = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
            boolean $i$f$getArguments2 = false;
            FirExpression lastArgument = (FirExpression)CollectionsKt.lastOrNull($this$arguments$iv2.getArgumentList().getArguments());
            if (lastArgument instanceof FirAnonymousFunctionExpression) {
                KtSourceElement ktSourceElement;
                KtSourceElement ktSourceElement5 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
                if (ktSourceElement5 != null) {
                    IElementType iElementType = KtNodeTypes.PARENTHESIZED;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PARENTHESIZED");
                    ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement5, iElementType, 0, 1, false, 10, null);
                } else {
                    ktSourceElement = null;
                }
                if (ktSourceElement == null) {
                    Object object = ((FirAnonymousFunctionExpression)lastArgument).getSource();
                    return Intrinsics.areEqual((Object)(object != null && (object = ((KtSourceElement)object).getLighterASTNode()) != null ? object.getTokenType() : null), (Object)KtStubElementTypes.FUNCTION) ? SuspendCallArgumentKind.FUN : SuspendCallArgumentKind.LAMBDA;
                }
            }
        }
        return null;
    }

    private final FirFunctionSymbol<?> findEnclosingSuspendFunction(CheckerContext context2) {
        FirBasedSymbol<?> firBasedSymbol;
        block7: {
            List<FirBasedSymbol<?>> $this$lastOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirBasedSymbol<?>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean $i$f$isSuspend;
                FirCallableSymbol $this$isSuspend$iv;
                boolean bl;
                FirBasedSymbol<?> element$iv;
                FirBasedSymbol<?> it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                FirBasedSymbol<?> firBasedSymbol2 = it;
                if (firBasedSymbol2 instanceof FirAnonymousFunctionSymbol) {
                    if (((FirAnonymousFunctionSymbol)it).isLambda()) {
                        bl = FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(((FirAnonymousFunctionSymbol)it).getResolvedTypeRef().getConeType(), context2.getSession());
                    } else {
                        $this$isSuspend$iv = (FirCallableSymbol)it;
                        $i$f$isSuspend = false;
                        bl = $this$isSuspend$iv.getRawStatus().isSuspend();
                    }
                } else if (firBasedSymbol2 instanceof FirNamedFunctionSymbol) {
                    $this$isSuspend$iv = (FirCallableSymbol)it;
                    $i$f$isSuspend = false;
                    bl = $this$isSuspend$iv.getRawStatus().isSuspend();
                } else {
                    bl = false;
                }
                if (!bl) continue;
                firBasedSymbol = element$iv;
                break block7;
            }
            firBasedSymbol = null;
        }
        FirBasedSymbol<?> firBasedSymbol3 = firBasedSymbol;
        return firBasedSymbol3 instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol3 : null;
    }

    private final boolean isInScopeForDefaultParameterValues(CheckerContext context2, FirFunctionSymbol<?> enclosingSuspendFunction) {
        List<FirValueParameterSymbol> valueParameters = enclosingSuspendFunction.getValueParameterSymbols();
        for (FirBasedSymbol declaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (declaration instanceof FirValueParameterSymbol && valueParameters.contains(declaration) && ((FirValueParameterSymbol)declaration).getHasDefaultValue()) {
                return true;
            }
            if (declaration instanceof FirAnonymousFunctionSymbol && ((FirAnonymousFunctionSymbol)declaration).getInlineStatus() == InlineStatus.Inline || !(declaration instanceof FirFunctionSymbol)) continue;
            FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)declaration;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getRawStatus().isInline()) continue;
            return false;
        }
        return false;
    }

    private final boolean checkNonLocalReturnUsage(CheckerContext context2, FirFunctionSymbol<?> enclosingSuspendFunction) {
        for (FirBasedSymbol declaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (Intrinsics.areEqual((Object)declaration, enclosingSuspendFunction)) {
                return true;
            }
            if (declaration instanceof FirPropertySymbol && ((FirPropertySymbol)declaration).isLocal() || declaration instanceof FirAnonymousFunctionSymbol && ((FirAnonymousFunctionSymbol)declaration).getInlineStatus().getReturnAllowed() || declaration instanceof FirValueParameterSymbol) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkRestrictsSuspension(CheckerContext context2, FirQualifiedAccessExpression expression2, FirFunctionSymbol<?> enclosingSuspendFunction, FirCallableSymbol<?> calledDeclarationSymbol) {
        void $this$filterTo$iv$iv;
        FirReceiverParameterSymbol firReceiverParameterSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        if (expression2 instanceof FirFunctionCall && this.isCaseMissedByK1((FirFunctionCall)expression2)) {
            return true;
        }
        FirSession session = context2.getSession();
        ConeSimpleKotlinType coneSimpleKotlinType = enclosingSuspendFunction.getDispatchReceiverType();
        FirRegularClassSymbol enclosingSuspendFunctionDispatchReceiverOwnerSymbol = coneSimpleKotlinType != null && (coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(coneSimpleKotlinType)) != null ? ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, coneClassLikeLookupTag) : null;
        FirReceiverParameterSymbol enclosingSuspendFunctionExtensionReceiverSymbol = enclosingSuspendFunction.getReceiverParameterSymbol();
        List<FirValueParameterSymbol> enclosingSuspendFunctionContextParameterSymbols = enclosingSuspendFunction.getContextParameterSymbols();
        ReceiversInfo receiversInfo = this.computeReceiversInfo(expression2, session, calledDeclarationSymbol);
        for (FirExpression firExpression : receiversInfo.getExpressions()) {
            boolean bl;
            block14: {
                if (!this.isRestrictSuspensionReceiver(FirTypeUtilsKt.getResolvedType(firExpression), session) || this.sameInstanceOfReceiver(firExpression, enclosingSuspendFunctionDispatchReceiverOwnerSymbol) || this.sameInstanceOfReceiver(firExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) continue;
                Iterable $this$any$iv = enclosingSuspendFunctionContextParameterSymbols;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.sameInstanceOfReceiver(firExpression, it)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            return false;
        }
        FirReceiverParameterSymbol firReceiverParameterSymbol2 = enclosingSuspendFunctionExtensionReceiverSymbol;
        if (firReceiverParameterSymbol2 != null) {
            FirReceiverParameterSymbol firReceiverParameterSymbol3;
            FirReceiverParameterSymbol it = firReceiverParameterSymbol3 = firReceiverParameterSymbol2;
            boolean bl = false;
            firReceiverParameterSymbol = INSTANCE.isRestrictSuspensionReceiver(it.getResolvedType(), session) ? firReceiverParameterSymbol3 : null;
        } else {
            firReceiverParameterSymbol = null;
        }
        Iterable iterable = enclosingSuspendFunctionContextParameterSymbols;
        Collection collection = CollectionsKt.listOfNotNull(firReceiverParameterSymbol);
        boolean $i$f$filter = false;
        Iterable bl = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv$iv;
            boolean bl3 = false;
            if (!INSTANCE.isRestrictSuspensionReceiver(it.getResolvedReturnType(), session)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List restrictSuspensionSymbols = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        switch (restrictSuspensionSymbols.size()) {
            case 0: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)CollectionsKt.single((List)restrictSuspensionSymbols);
        if (this.sameInstanceOfReceiver(receiversInfo.getDispatchReceiverExpression(), firBasedSymbol)) {
            return true;
        }
        for (ReceiverInfo receiver : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)receiversInfo.getExtensionReceiver()), (Iterable)receiversInfo.getContextParameters())) {
            if (!this.sameInstanceOfReceiver(receiver.getExpression(), firBasedSymbol)) continue;
            ConeKotlinType coneKotlinType = receiver.getType();
            boolean bl2 = coneKotlinType != null ? this.isRestrictSuspensionReceiver(coneKotlinType, session) : false;
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCaseMissedByK1(FirFunctionCall expression2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!(expression2 instanceof FirImplicitInvokeCall)) return false;
        FirExpression firExpression = ((FirImplicitInvokeCall)expression2).getExplicitReceiver();
        Object object = firExpression;
        if (firExpression == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!CompilerConeAttributesKt.isExtensionFunctionType((ConeKotlinType)object)) return false;
        boolean bl = true;
        if (!bl) return false;
        boolean bl2 = true;
        boolean isInvokeFromExtensionFunctionType = bl2;
        if (!isInvokeFromExtensionFunctionType) {
            return false;
        }
        KtSourceElement ktSourceElement = ((FirImplicitInvokeCall)expression2).getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALUE_ARGUMENT_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 == null) return false;
        LighterASTNode lighterASTNode = ktSourceElement2.getLighterASTNode();
        if (lighterASTNode == null) return false;
        List<LighterASTNode> list = LightTreeUtilsKt.getChildren(lighterASTNode, source.getTreeStructure());
        if (list == null) return false;
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.VALUE_ARGUMENT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int visualValueArgumentsCount = ((List)destination$iv$iv).size();
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        if (visualValueArgumentsCount == ((Collection)$this$arguments$iv.getArgumentList().getArguments()).size() - 1) return false;
        return true;
    }

    private final boolean isRestrictSuspensionReceiver(ConeKotlinType $this$isRestrictSuspensionReceiver, FirSession session) {
        ConeKotlinType coneKotlinType = $this$isRestrictSuspensionReceiver;
        if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl;
            block10: {
                FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isRestrictSuspensionReceiver, session, null, 2, null).getLookupTag(), session);
                if (firRegularClassSymbol == null) {
                    return false;
                }
                FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
                if (FirAnnotationUtilsKt.hasAnnotationWithClassId(regularClassSymbol, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension(), session)) {
                    return true;
                }
                Iterable $this$any$iv = regularClassSymbol.getResolvedSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it, session)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        if (coneKotlinType instanceof ConeTypeParameterType) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = ((ConeTypeParameterType)$this$isRestrictSuspensionReceiver).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it.getConeType(), session)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean sameInstanceOfReceiver(FirExpression useSiteReceiverExpression, FirBasedSymbol<?> declarationSiteReceiverOwnerSymbol) {
        return declarationSiteReceiverOwnerSymbol == null || useSiteReceiverExpression == null ? false : (useSiteReceiverExpression instanceof FirThisReceiverExpression ? Intrinsics.areEqual(((FirThisReceiverExpression)useSiteReceiverExpression).getCalleeReference().getBoundSymbol(), declarationSiteReceiverOwnerSymbol) : (useSiteReceiverExpression instanceof FirPropertyAccessExpression ? declarationSiteReceiverOwnerSymbol instanceof FirValueParameterSymbol && DeclarationUtilsKt.isContextParameter(declarationSiteReceiverOwnerSymbol) && Intrinsics.areEqual(ReferenceUtilsKt.toResolvedCallableSymbol((FirResolvable)((Object)useSiteReceiverExpression)), declarationSiteReceiverOwnerSymbol) : false));
    }

    /*
     * WARNING - void declaration
     */
    private final ReceiversInfo computeReceiversInfo(FirQualifiedAccessExpression $this$computeReceiversInfo, FirSession session, FirCallableSymbol<?> calledDeclarationSymbol) {
        Collection<ConeKotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirExpression dispatchReceiver = $this$computeReceiversInfo.getDispatchReceiver();
        if ($this$computeReceiversInfo instanceof FirImplicitInvokeCall && dispatchReceiver != null && FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getResolvedType(dispatchReceiver), session)) {
            Object object;
            Collection<ConeKotlinType> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            FirExpression variableForInvoke = dispatchReceiver;
            ConeKotlinType variableForInvokeType = FirTypeUtilsKt.getResolvedType(variableForInvoke);
            if (!CompilerConeAttributesKt.getHasContextParameters(variableForInvokeType) && !CompilerConeAttributesKt.isExtensionFunctionType(variableForInvokeType)) {
                return new ReceiversInfo(null, new ReceiverInfo(null, null), CollectionsKt.emptyList());
            }
            int amountOfContexts = CompilerConeAttributesKt.getContextParameterNumberForFunctionType(variableForInvokeType);
            Iterable iterable = ArraysKt.take((Object[])variableForInvokeType.getTypeArguments(), (int)amountOfContexts);
            List list = CollectionsKt.take((Iterable)((FirImplicitInvokeCall)$this$computeReceiversInfo).getArgumentList().getArguments(), (int)amountOfContexts);
            FirSuspendCallChecker firSuspendCallChecker = this;
            boolean $i$f$map = false;
            void var11_18 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it instanceof ConeKotlinType ? (ConeKotlinType)it : null);
            }
            collection2 = (List)destination$iv$iv2;
            List<ReceiverInfo> contexts2 = firSuspendCallChecker.zipReceiverInfo(list, (List<? extends ConeKotlinType>)collection2);
            ReceiverInfo extension = new ReceiverInfo((FirExpression)CollectionsKt.getOrNull(((FirImplicitInvokeCall)$this$computeReceiversInfo).getArgumentList().getArguments(), (int)amountOfContexts), (object = ArraysKt.getOrNull((Object[])variableForInvokeType.getTypeArguments(), (int)amountOfContexts)) instanceof ConeKotlinType ? (ConeKotlinType)object : null);
            return new ReceiversInfo(null, extension, contexts2);
        }
        Iterable variableForInvoke = calledDeclarationSymbol.getContextParameterSymbols();
        List<FirExpression> list = $this$computeReceiversInfo.getContextArguments();
        FirSuspendCallChecker firSuspendCallChecker = this;
        ReceiverInfo receiverInfo = new ReceiverInfo($this$computeReceiversInfo.getExtensionReceiver(), calledDeclarationSymbol.getResolvedReceiverType());
        FirExpression firExpression = dispatchReceiver;
        boolean $i$f$map = false;
        void amountOfContexts = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirValueParameterSymbol destination$iv$iv2 = (FirValueParameterSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getResolvedReturnType());
        }
        collection = (List)destination$iv$iv;
        List<ReceiverInfo> list2 = firSuspendCallChecker.zipReceiverInfo(list, (List<? extends ConeKotlinType>)collection);
        ReceiverInfo receiverInfo2 = receiverInfo;
        FirExpression firExpression2 = firExpression;
        return new ReceiversInfo(firExpression2, receiverInfo2, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ReceiverInfo> zipReceiverInfo(List<? extends FirExpression> expressions, List<? extends ConeKotlinType> types2) {
        void $this$zip$iv;
        Iterable iterable = expressions;
        Iterable other$iv = types2;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<ReceiverInfo> list$iv = new ArrayList<ReceiverInfo>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void p1;
            void p0;
            ConeKotlinType coneKotlinType = (ConeKotlinType)second$iv.next();
            FirExpression firExpression = (FirExpression)first$iv.next();
            ArrayList<ReceiverInfo> arrayList = list$iv;
            boolean bl = false;
            arrayList.add(new ReceiverInfo((FirExpression)p0, (ConeKotlinType)p1));
        }
        return list$iv;
    }

    private final void checkCallableReference(DiagnosticReporter reporter, CheckerContext context2, FirQualifiedAccessExpression expression2, FirCallableSymbol<?> symbol) {
        if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Callable reference to suspend property is unsupported.", null, 16, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiverInfo;", "", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    public static final class ReceiverInfo {
        @Nullable
        private final FirExpression expression;
        @Nullable
        private final ConeKotlinType type;

        public ReceiverInfo(@Nullable FirExpression expression2, @Nullable ConeKotlinType type) {
            this.expression = expression2;
            this.type = type;
        }

        @Nullable
        public final FirExpression getExpression() {
            return this.expression;
        }

        @Nullable
        public final ConeKotlinType getType() {
            return this.type;
        }

        @Nullable
        public final FirExpression component1() {
            return this.expression;
        }

        @Nullable
        public final ConeKotlinType component2() {
            return this.type;
        }

        @NotNull
        public final ReceiverInfo copy(@Nullable FirExpression expression2, @Nullable ConeKotlinType type) {
            return new ReceiverInfo(expression2, type);
        }

        public static /* synthetic */ ReceiverInfo copy$default(ReceiverInfo receiverInfo, FirExpression firExpression, ConeKotlinType coneKotlinType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firExpression = receiverInfo.expression;
            }
            if ((n2 & 2) != 0) {
                coneKotlinType = receiverInfo.type;
            }
            return receiverInfo.copy(firExpression, coneKotlinType);
        }

        @NotNull
        public String toString() {
            return "ReceiverInfo(expression=" + this.expression + ", type=" + this.type + ')';
        }

        public int hashCode() {
            int result2 = this.expression == null ? 0 : this.expression.hashCode();
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReceiverInfo)) {
                return false;
            }
            ReceiverInfo receiverInfo = (ReceiverInfo)other;
            if (!Intrinsics.areEqual((Object)this.expression, (Object)receiverInfo.expression)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)receiverInfo.type);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J/\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiversInfo;", "", "dispatchReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "extensionReceiver", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiverInfo;", "contextParameters", "", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiverInfo;Ljava/util/List;)V", "getDispatchReceiverExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExtensionReceiver", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiverInfo;", "getContextParameters", "()Ljava/util/List;", "expressions", "getExpressions", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirSuspendCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiversInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1641#2,10:383\n1914#2:393\n1915#2:395\n1651#2:396\n1#3:394\n*S KotlinDebug\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker$ReceiversInfo\n*L\n319#1:383,10\n319#1:393\n319#1:395\n319#1:396\n319#1:394\n*E\n"})
    public static final class ReceiversInfo {
        @Nullable
        private final FirExpression dispatchReceiverExpression;
        @NotNull
        private final ReceiverInfo extensionReceiver;
        @NotNull
        private final List<ReceiverInfo> contextParameters;
        @NotNull
        private final List<FirExpression> expressions;

        /*
         * WARNING - void declaration
         */
        public ReceiversInfo(@Nullable FirExpression dispatchReceiverExpression, @NotNull ReceiverInfo extensionReceiver, @NotNull List<ReceiverInfo> contextParameters) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)extensionReceiver, (String)"extensionReceiver");
            Intrinsics.checkNotNullParameter(contextParameters, (String)"contextParameters");
            this.dispatchReceiverExpression = dispatchReceiverExpression;
            this.extensionReceiver = extensionReceiver;
            this.contextParameters = contextParameters;
            Object object = new FirExpression[]{this.dispatchReceiverExpression, this.extensionReceiver.getExpression()};
            Collection collection = CollectionsKt.listOfNotNull((Object[])object);
            object = this.contextParameters;
            Collection collection2 = collection;
            ReceiversInfo receiversInfo = this;
            boolean $i$f$mapNotNull = false;
            void var6_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ReceiverInfo it = (ReceiverInfo)element$iv$iv;
                boolean bl2 = false;
                if (it.getExpression() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            receiversInfo.expressions = CollectionsKt.plus((Collection)collection2, (Iterable)list);
        }

        @Nullable
        public final FirExpression getDispatchReceiverExpression() {
            return this.dispatchReceiverExpression;
        }

        @NotNull
        public final ReceiverInfo getExtensionReceiver() {
            return this.extensionReceiver;
        }

        @NotNull
        public final List<ReceiverInfo> getContextParameters() {
            return this.contextParameters;
        }

        @NotNull
        public final List<FirExpression> getExpressions() {
            return this.expressions;
        }

        @Nullable
        public final FirExpression component1() {
            return this.dispatchReceiverExpression;
        }

        @NotNull
        public final ReceiverInfo component2() {
            return this.extensionReceiver;
        }

        @NotNull
        public final List<ReceiverInfo> component3() {
            return this.contextParameters;
        }

        @NotNull
        public final ReceiversInfo copy(@Nullable FirExpression dispatchReceiverExpression, @NotNull ReceiverInfo extensionReceiver, @NotNull List<ReceiverInfo> contextParameters) {
            Intrinsics.checkNotNullParameter((Object)extensionReceiver, (String)"extensionReceiver");
            Intrinsics.checkNotNullParameter(contextParameters, (String)"contextParameters");
            return new ReceiversInfo(dispatchReceiverExpression, extensionReceiver, contextParameters);
        }

        public static /* synthetic */ ReceiversInfo copy$default(ReceiversInfo receiversInfo, FirExpression firExpression, ReceiverInfo receiverInfo, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firExpression = receiversInfo.dispatchReceiverExpression;
            }
            if ((n2 & 2) != 0) {
                receiverInfo = receiversInfo.extensionReceiver;
            }
            if ((n2 & 4) != 0) {
                list = receiversInfo.contextParameters;
            }
            return receiversInfo.copy(firExpression, receiverInfo, list);
        }

        @NotNull
        public String toString() {
            return "ReceiversInfo(dispatchReceiverExpression=" + this.dispatchReceiverExpression + ", extensionReceiver=" + this.extensionReceiver + ", contextParameters=" + this.contextParameters + ')';
        }

        public int hashCode() {
            int result2 = this.dispatchReceiverExpression == null ? 0 : this.dispatchReceiverExpression.hashCode();
            result2 = result2 * 31 + this.extensionReceiver.hashCode();
            result2 = result2 * 31 + ((Object)this.contextParameters).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReceiversInfo)) {
                return false;
            }
            ReceiversInfo receiversInfo = (ReceiversInfo)other;
            if (!Intrinsics.areEqual((Object)this.dispatchReceiverExpression, (Object)receiversInfo.dispatchReceiverExpression)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extensionReceiver, (Object)receiversInfo.extensionReceiver)) {
                return false;
            }
            return Intrinsics.areEqual(this.contextParameters, receiversInfo.contextParameters);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendCallArgumentKind.values().length];
            try {
                nArray[SuspendCallArgumentKind.FUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuspendCallArgumentKind.LAMBDA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

