/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeAttribute;
import org.jetbrains.kotlin.fir.types.ConeCapturedTypeConstructor;
import org.jetbrains.kotlin.fir.types.ConeClassLikeErrorLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubTypeConstructor;
import org.jetbrains.kotlin.fir.types.ConeTypeConstructorMarker;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableTypeConstructor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JA\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001a\u00a2\u0006\u0002\b\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010 \u001a\u00020!J\u001a\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010 \u001a\u00020!H\u0016J\f\u0010%\u001a\u00020\u0016*\u00020&H\u0002J\f\u0010'\u001a\u00020\u0005*\u00020(H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010)\u001a\u00020(H\u0014J\f\u0010*\u001a\u00020\u0016*\u00020\u0018H\u0014J\f\u0010+\u001a\u00020\u0016*\u00020\u0018H\u0004J\f\u0010\u001f\u001a\u00020\u0016*\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020,H\u0014J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020-H\u0014J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020.H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00060\tj\u0002`\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "", "attributeRenderer", "Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;", "renderCapturedDetails", "", "<init>", "(Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;Z)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getBuilder", "()Ljava/lang/StringBuilder;", "setBuilder", "(Ljava/lang/StringBuilder;)V", "idRenderer", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "getIdRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "setIdRenderer", "(Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;)V", "renderAsPossibleFunctionType", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "functionClassKindExtractor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "renderType", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lkotlin/ExtensionFunctionType;", "render", "nullabilityMarker", "", "renderConstructor", "constructor", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "renderTypeArguments", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "renderForSameLookupTags", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "flexibleType", "renderAttributes", "renderNonCompilerAttributes", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "Lorg/jetbrains/kotlin/fir/types/ConeDefinitelyNotNullType;", "Lorg/jetbrains/kotlin/fir/types/ConeIntersectionType;", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeRenderer.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,278:1\n1#2:279\n1914#3,2:280\n776#3:282\n872#3,2:283\n195#4:285\n*S KotlinDebug\n*F\n+ 1 ConeTypeRenderer.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer\n*L\n146#1:280,2\n219#1:282\n219#1:283,2\n220#1:285\n*E\n"})
public class ConeTypeRenderer {
    @NotNull
    private final ConeAttributeRenderer attributeRenderer;
    private boolean renderCapturedDetails;
    public StringBuilder builder;
    public ConeIdRenderer idRenderer;

    public ConeTypeRenderer(@NotNull ConeAttributeRenderer attributeRenderer, boolean renderCapturedDetails) {
        Intrinsics.checkNotNullParameter((Object)attributeRenderer, (String)"attributeRenderer");
        this.attributeRenderer = attributeRenderer;
        this.renderCapturedDetails = renderCapturedDetails;
    }

    public /* synthetic */ ConeTypeRenderer(ConeAttributeRenderer coneAttributeRenderer, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            coneAttributeRenderer = ConeAttributeRenderer.ToString.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(coneAttributeRenderer, bl);
    }

    @NotNull
    public final StringBuilder getBuilder() {
        StringBuilder stringBuilder = this.builder;
        if (stringBuilder != null) {
            return stringBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        return null;
    }

    public final void setBuilder(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
        this.builder = stringBuilder;
    }

    @NotNull
    public final ConeIdRenderer getIdRenderer() {
        ConeIdRenderer coneIdRenderer = this.idRenderer;
        if (coneIdRenderer != null) {
            return coneIdRenderer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"idRenderer");
        return null;
    }

    public final void setIdRenderer(@NotNull ConeIdRenderer coneIdRenderer) {
        Intrinsics.checkNotNullParameter((Object)coneIdRenderer, (String)"<set-?>");
        this.idRenderer = coneIdRenderer;
    }

    public void renderAsPossibleFunctionType(@NotNull ConeKotlinType type, @NotNull Function1<? super ConeKotlinType, ? extends FunctionTypeKind> functionClassKindExtractor, @NotNull Function1<? super ConeTypeProjection, Unit> renderType) {
        FunctionTypeKind kind;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(functionClassKindExtractor, (String)"functionClassKindExtractor");
        Intrinsics.checkNotNullParameter(renderType, (String)"renderType");
        FunctionTypeKind functionTypeKind = kind = (FunctionTypeKind)functionClassKindExtractor.invoke((Object)type);
        if (!(functionTypeKind != null ? !functionTypeKind.isReflectType() : false)) {
            renderType.invoke((Object)type);
            return;
        }
        this.renderNonCompilerAttributes(type);
        if (ConeTypeUtilsKt.isMarkedNullable(type)) {
            this.getBuilder().append("(");
        }
        String string = kind.getPrefixForTypeRender();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.getBuilder().append(it);
            this.getBuilder().append(" ");
        }
        List contextParameters = CollectionsKt.emptyList();
        ConeTypeProjection receiverParameter = null;
        List regularParameters = ArraysKt.asList((Object[])type.getTypeArguments());
        int numberOfContextParameters = CompilerConeAttributesKt.getContextParameterNumberForFunctionType(type);
        if (numberOfContextParameters > 0 && regularParameters.size() >= numberOfContextParameters + 1) {
            contextParameters = regularParameters.subList(0, numberOfContextParameters);
            regularParameters = regularParameters.subList(numberOfContextParameters, regularParameters.size());
        }
        if (CompilerConeAttributesKt.isExtensionFunctionType(type) && regularParameters.size() >= 2 && !Intrinsics.areEqual((Object)CollectionsKt.first((List)regularParameters), (Object)ConeStarProjection.INSTANCE)) {
            receiverParameter = (ConeTypeProjection)CollectionsKt.first((List)regularParameters);
            regularParameters = regularParameters.subList(1, regularParameters.size());
        }
        if (!((Collection)contextParameters).isEmpty()) {
            this.getBuilder().append("context(");
            Iterator iterator2 = ((Iterable)contextParameters).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int index = n2++;
                ConeTypeProjection contextParameter = (ConeTypeProjection)iterator2.next();
                if (index != 0) {
                    this.getBuilder().append(", ");
                }
                this.render(contextParameter);
            }
            this.getBuilder().append(") ");
        }
        List arguments = regularParameters.subList(0, regularParameters.size() - 1);
        ConeTypeProjection returnType = (ConeTypeProjection)CollectionsKt.last(regularParameters);
        if (receiverParameter != null) {
            this.render(receiverParameter);
            this.getBuilder().append(".");
        }
        this.getBuilder().append("(");
        Iterator iterator3 = ((Iterable)arguments).iterator();
        int n3 = 0;
        while (iterator3.hasNext()) {
            int index = n3++;
            ConeTypeProjection argument = (ConeTypeProjection)iterator3.next();
            if (index != 0) {
                this.getBuilder().append(", ");
            }
            this.render(argument);
        }
        this.getBuilder().append(") -> ");
        this.render(returnType);
        if (ConeTypeUtilsKt.isMarkedNullable(type)) {
            this.getBuilder().append(")?");
        }
    }

    public static /* synthetic */ void renderAsPossibleFunctionType$default(ConeTypeRenderer coneTypeRenderer, ConeKotlinType coneKotlinType, Function1 function1, Function1 function12, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderAsPossibleFunctionType");
        }
        if ((n2 & 4) != 0) {
            function12 = arg_0 -> ConeTypeRenderer.renderAsPossibleFunctionType$lambda$0(coneTypeRenderer, arg_0);
        }
        coneTypeRenderer.renderAsPossibleFunctionType(coneKotlinType, (Function1<? super ConeKotlinType, ? extends FunctionTypeKind>)function1, (Function1<? super ConeTypeProjection, Unit>)function12);
    }

    public final void render(@NotNull ConeKotlinType type, @NotNull String nullabilityMarker) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)nullabilityMarker, (String)"nullabilityMarker");
        if (!(type instanceof ConeFlexibleType) && !(type instanceof ConeDefinitelyNotNullType)) {
            this.renderAttributes(type);
        }
        if ((coneKotlinType = type) instanceof ConeDefinitelyNotNullType) {
            this.render((ConeDefinitelyNotNullType)type);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.render((ConeIntersectionType)type);
        } else if (coneKotlinType instanceof ConeDynamicType) {
            this.getBuilder().append("dynamic");
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            this.render((ConeFlexibleType)type);
        } else {
            if (coneKotlinType instanceof ConeSimpleKotlinType) {
                String string;
                boolean hasTypeArguments = type instanceof ConeClassLikeType && !(type.getTypeArguments().length == 0);
                String string2 = string = nullabilityMarker;
                TypeConstructorMarker typeConstructorMarker = ConeTypeUtilsKt.getConstructor((ConeRigidType)type);
                ConeTypeRenderer coneTypeRenderer = this;
                boolean bl = false;
                boolean bl2 = !hasTypeArguments;
                String string3 = bl2 ? string : null;
                if (string3 == null) {
                    string3 = "";
                }
                coneTypeRenderer.renderConstructor(typeConstructorMarker, string3);
                if (hasTypeArguments) {
                    this.renderTypeArguments((ConeClassLikeType)type);
                    this.getBuilder().append(nullabilityMarker);
                }
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.getBuilder().append(nullabilityMarker);
    }

    public static /* synthetic */ void render$default(ConeTypeRenderer coneTypeRenderer, ConeKotlinType coneKotlinType, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: render");
        }
        if ((n2 & 2) != 0) {
            string = !(coneKotlinType instanceof ConeFlexibleType) && ConeTypeUtilsKt.isMarkedNullable(coneKotlinType) ? "?" : "";
        }
        coneTypeRenderer.render(coneKotlinType, string);
    }

    /*
     * WARNING - void declaration
     */
    public void renderConstructor(@NotNull TypeConstructorMarker constructor, @NotNull String nullabilityMarker) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)nullabilityMarker, (String)"nullabilityMarker");
        if (!(constructor instanceof ConeTypeConstructorMarker)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ConeTypeConstructorMarker coneTypeConstructorMarker = (ConeTypeConstructorMarker)constructor;
        if (coneTypeConstructorMarker instanceof ConeTypeVariableTypeConstructor) {
            this.getBuilder().append("TypeVariable(");
            this.getBuilder().append(((ConeTypeVariableTypeConstructor)constructor).getName());
            stringBuilder = this.getBuilder().append(")");
        } else if (coneTypeConstructorMarker instanceof ConeCapturedTypeConstructor) {
            this.getBuilder().append("CapturedType(");
            this.render(((ConeCapturedTypeConstructor)constructor).getProjection());
            this.getBuilder().append(")");
            if (this.renderCapturedDetails) {
                Unit unit;
                StringBuilder stringBuilder2 = this.getBuilder();
                StringBuilder stringBuilder3 = new StringBuilder().append(" with lowerType=");
                ConeKotlinType coneKotlinType = ((ConeCapturedTypeConstructor)constructor).getLowerType();
                if (coneKotlinType != null) {
                    void p0;
                    ConeKotlinType coneKotlinType2 = coneKotlinType;
                    StringBuilder stringBuilder4 = stringBuilder3;
                    StringBuilder stringBuilder5 = stringBuilder2;
                    boolean bl = false;
                    ConeTypeRenderer.render$default(this, (ConeKotlinType)p0, null, 2, null);
                    Unit unit2 = Unit.INSTANCE;
                    stringBuilder2 = stringBuilder5;
                    stringBuilder3 = stringBuilder4;
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                stringBuilder2.append(stringBuilder3.append(unit).append(", supertypes=[").toString());
                this.renderCapturedDetails = false;
                List<ConeKotlinType> list = ((ConeCapturedTypeConstructor)constructor).getSupertypes();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ConeKotlinType p0 = (ConeKotlinType)element$iv;
                        boolean bl = false;
                        ConeTypeRenderer.render$default(this, p0, null, 2, null);
                    }
                }
                this.renderCapturedDetails = true;
                this.getBuilder().append("]");
            }
            stringBuilder = Unit.INSTANCE;
        } else if (coneTypeConstructorMarker instanceof ConeClassLikeErrorLookupTag) {
            stringBuilder = this.getBuilder().append("ERROR CLASS: " + ((ConeClassLikeErrorLookupTag)constructor).getDiagnostic().getReason());
        } else if (coneTypeConstructorMarker instanceof ConeClassLikeLookupTag) {
            this.getIdRenderer().renderClassId(((ConeClassLikeLookupTag)constructor).getClassId());
            stringBuilder = Unit.INSTANCE;
        } else if (coneTypeConstructorMarker instanceof ConeClassifierLookupTag) {
            stringBuilder = this.getBuilder().append(((ConeClassifierLookupTag)constructor).getName().asString());
        } else if (coneTypeConstructorMarker instanceof ConeStubTypeConstructor) {
            stringBuilder = this.getBuilder().append("Stub (subtyping): " + ((ConeStubTypeConstructor)constructor).getVariable());
        } else if (coneTypeConstructorMarker instanceof ConeIntegerLiteralType) {
            this.render((ConeIntegerLiteralType)constructor);
            stringBuilder = Unit.INSTANCE;
        } else {
            if (coneTypeConstructorMarker instanceof ConeIntersectionType) {
                throw new IllegalStateException("`renderConstructor` mustn't be called with an intersection type argument. Call `render` to simply render the type or filter out intersection types on the call-site.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        this.getBuilder().append(nullabilityMarker);
    }

    public static /* synthetic */ void renderConstructor$default(ConeTypeRenderer coneTypeRenderer, TypeConstructorMarker typeConstructorMarker, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderConstructor");
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        coneTypeRenderer.renderConstructor(typeConstructorMarker, string);
    }

    private final void renderTypeArguments(ConeClassLikeType $this$renderTypeArguments) {
        if ($this$renderTypeArguments.getTypeArguments().length == 0) {
            return;
        }
        this.getBuilder().append("<");
        ConeTypeProjection[] coneTypeProjectionArray = $this$renderTypeArguments.getTypeArguments();
        int n2 = coneTypeProjectionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int index = i2;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i2];
            if (index > 0) {
                this.getBuilder().append(", ");
            }
            this.render(typeArgument);
        }
        this.getBuilder().append(">");
    }

    private final boolean renderForSameLookupTags(ConeFlexibleType $this$renderForSameLookupTags) {
        if ($this$renderForSameLookupTags.isTrivial() && !($this$renderForSameLookupTags.getLowerBound() instanceof ConeDefinitelyNotNullType)) {
            this.render($this$renderForSameLookupTags.getLowerBound(), "!");
            return true;
        }
        if ($this$renderForSameLookupTags.getLowerBound() instanceof ConeLookupTagBasedType && $this$renderForSameLookupTags.getUpperBound() instanceof ConeLookupTagBasedType && Intrinsics.areEqual((Object)((ConeLookupTagBasedType)$this$renderForSameLookupTags.getLowerBound()).getLookupTag(), (Object)((ConeLookupTagBasedType)$this$renderForSameLookupTags.getUpperBound()).getLookupTag()) && !((ConeLookupTagBasedType)$this$renderForSameLookupTags.getLowerBound()).isMarkedNullable() && ((ConeLookupTagBasedType)$this$renderForSameLookupTags.getUpperBound()).isMarkedNullable() && (!($this$renderForSameLookupTags.getLowerBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getLowerBound().getTypeArguments().length == 0) && (!($this$renderForSameLookupTags.getUpperBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getUpperBound().getTypeArguments().length == 0)) {
            this.render($this$renderForSameLookupTags.getLowerBound(), "!");
            return true;
        }
        return false;
    }

    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        if (this.renderForSameLookupTags(flexibleType)) {
            return;
        }
        this.getBuilder().append("ft<");
        ConeTypeRenderer.render$default(this, flexibleType.getLowerBound(), null, 2, null);
        this.getBuilder().append(", ");
        ConeTypeRenderer.render$default(this, flexibleType.getUpperBound(), null, 2, null);
        this.getBuilder().append(">");
    }

    protected void renderAttributes(@NotNull ConeKotlinType $this$renderAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAttributes, (String)"<this>");
        if (!CollectionsKt.any((Iterable)$this$renderAttributes.getAttributes())) {
            return;
        }
        this.getBuilder().append(this.attributeRenderer.render($this$renderAttributes.getAttributes()));
    }

    /*
     * WARNING - void declaration
     */
    protected final void renderNonCompilerAttributes(@NotNull ConeKotlinType $this$renderNonCompilerAttributes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$renderNonCompilerAttributes, (String)"<this>");
        Map<KClass<ConeAttribute<?>>, ClassId> compilerAttributes = CompilerConeAttributes.INSTANCE.getClassIdByCompilerAttributeKey();
        Iterable $this$filter$iv = $this$renderNonCompilerAttributes.getAttributes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConeAttribute it = (ConeAttribute)element$iv$iv;
            boolean bl = false;
            if (!(!compilerAttributes.containsKey(it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$ifNotEmpty$iv = (List)destination$iv$iv;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$renderNonCompilerAttributes_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            this.getBuilder().append(this.attributeRenderer.render($this$renderNonCompilerAttributes_u24lambda_u241));
        }
    }

    private final void render(ConeTypeProjection $this$render) {
        ConeTypeProjection coneTypeProjection = $this$render;
        if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            this.getBuilder().append("*");
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            this.getBuilder().append("CONFLICTING-PROJECTION ");
            ConeTypeRenderer.render$default(this, ((ConeKotlinTypeConflictingProjection)$this$render).getType(), null, 2, null);
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            this.getBuilder().append("in ");
            ConeTypeRenderer.render$default(this, ((ConeKotlinTypeProjectionIn)$this$render).getType(), null, 2, null);
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            this.getBuilder().append("out ");
            ConeTypeRenderer.render$default(this, ((ConeKotlinTypeProjectionOut)$this$render).getType(), null, 2, null);
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            ConeTypeRenderer.render$default(this, (ConeKotlinType)$this$render, null, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    protected void render(@NotNull ConeIntegerLiteralType type) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ConeIntegerLiteralType coneIntegerLiteralType = type;
        if (coneIntegerLiteralType instanceof ConeIntegerLiteralConstantType) {
            stringBuilder = this.getBuilder().append("ILT: " + ((ConeIntegerLiteralConstantType)type).getValue());
        } else if (coneIntegerLiteralType instanceof ConeIntegerConstantOperatorType) {
            stringBuilder = this.getBuilder().append("IOT");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    protected void render(@NotNull ConeDefinitelyNotNullType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ConeTypeRenderer.render$default(this, type.getOriginal(), null, 2, null);
        this.getBuilder().append(" & Any");
    }

    protected void render(@NotNull ConeIntersectionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.getBuilder().append("it(");
        Iterator iterator2 = ((Iterable)type.getIntersectedTypes()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            ConeKotlinType intersected = (ConeKotlinType)iterator2.next();
            if (index > 0) {
                this.getBuilder().append(" & ");
            }
            ConeTypeRenderer.render$default(this, intersected, null, 2, null);
        }
        this.getBuilder().append(")");
    }

    private static final Unit renderAsPossibleFunctionType$lambda$0(ConeTypeRenderer this$0, ConeTypeProjection coneTypeProjection) {
        Intrinsics.checkNotNullParameter((Object)coneTypeProjection, (String)"<this>");
        this$0.render(coneTypeProjection);
        return Unit.INSTANCE;
    }

    public ConeTypeRenderer() {
        this(null, false, 3, null);
    }
}

