/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.DfaType;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenSelfTypeExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "ConditionChecker", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,680:1\n1650#2:681\n1914#2:682\n1915#2:684\n1651#2:685\n1641#2,10:686\n1914#2:696\n1915#2:698\n1651#2:699\n1660#2,3:700\n1#3:683\n1#3:697\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker\n*L\n387#1:681\n387#1:682\n387#1:684\n387#1:685\n393#1:686,10\n393#1:696\n393#1:698\n393#1:699\n400#1:700,3\n387#1:683\n393#1:697\n*E\n"})
final class WhenOnEnumExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnEnumExhaustivenessChecker INSTANCE = new WhenOnEnumExhaustivenessChecker();

    private WhenOnEnumExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(subjectType, session);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        return ((FirRegularClass)symbol.getFir()).getClassKind() == ClassKind.ENUM_CLASS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        void $this$mapTo$iv;
        Collection<WhenMissingCase> destination$iv;
        FirDeclaration it;
        Object element$iv;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        if (WhenSelfTypeExhaustivenessChecker.INSTANCE.isExhaustiveThroughSelfTypeCheck(whenExpression, subjectType, session)) {
            return;
        }
        FirClassifierSymbol<?> firClassifierSymbol = ToSymbolUtilsKt.toSymbol(subjectType, session);
        Intrinsics.checkNotNull(firClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol");
        FirRegularClass enumClass = (FirRegularClass)((FirRegularClassSymbol)firClassifierSymbol).getFir();
        Iterable iterable = enumClass.getDeclarations();
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv.iterator();
        while (object.hasNext()) {
            FirEnumEntry it$iv;
            element$iv = element$iv$iv = object.next();
            boolean bl = false;
            it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if ((it instanceof FirEnumEntry ? (FirEnumEntry)it : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add((WhenMissingCase)((Object)it$iv));
        }
        Set notCheckedEntries = (Set)destination$iv;
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.DataFlowBasedExhaustiveness)) {
            FirPureAbstractElement firPureAbstractElement = whenExpression.getSubjectVariable();
            if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null) {
                List list;
                List list2;
                FirPureAbstractElement initializer = firPureAbstractElement;
                boolean bl = false;
                Object object2 = object = initializer instanceof FirSmartCastExpression ? (FirSmartCastExpression)initializer : null;
                if (object != null && (element$iv$iv = ((FirSmartCastExpression)object).getLowerTypesFromSmartCast()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    element$iv = (Iterable)element$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    it = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo2 = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                        boolean bl4 = false;
                        DfaType it2 = (DfaType)element$iv$iv2;
                        boolean bl5 = false;
                        Object object3 = it2 instanceof DfaType.Symbol ? (DfaType.Symbol)it2 : null;
                        if ((object3 != null && (object3 = ((DfaType.Symbol)object3).getSymbol()) != null ? (Object)((FirBasedSymbol)object3).getFir() : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = list = null;
                }
                if (list2 == null) {
                    list = CollectionsKt.emptyList();
                }
                List knownNonValues = list;
                TypeIntrinsics.asMutableCollection((Object)notCheckedEntries).removeAll(knownNonValues);
            }
        }
        whenExpression.accept(ConditionChecker.INSTANCE, notCheckedEntries);
        $this$mapNotNullTo$iv = notCheckedEntries;
        destination$iv = destination;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            object = (FirEnumEntry)item$iv;
            Collection<WhenMissingCase> collection2 = destination$iv;
            boolean bl = false;
            collection2.add(new WhenMissingCase.EnumCheckIsMissing(it3.getSymbol().getCallableId()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "<init>", "()V", "visitEqualityOperatorCall", "", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "data", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker$ConditionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,680:1\n1#2:681\n57#3:682\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnEnumExhaustivenessChecker$ConditionChecker\n*L\n406#1:682\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Set<FirEnumEntry>> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Set<FirEnumEntry> data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirOperation it = equalityOperatorCall.getOperation();
            boolean bl = false;
            if (!(it == FirOperation.EQ || it == FirOperation.IDENTITY)) {
                return;
            }
            FirCall $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
            FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReferenceUnsafe(argument);
            FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            FirVariableSymbol firVariableSymbol = firBasedSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firBasedSymbol : null;
            if (firVariableSymbol == null) {
                return;
            }
            FirVariableSymbol symbol = firVariableSymbol;
            Object e2 = symbol.getFir();
            FirEnumEntry firEnumEntry = e2 instanceof FirEnumEntry ? (FirEnumEntry)e2 : null;
            if (firEnumEntry == null) {
                return;
            }
            FirEnumEntry checkedEnumEntry = firEnumEntry;
            data.remove(checkedEnumEntry);
        }
    }
}

