/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0014\u0010\u001f\u001a\u00020 *\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010#\u001a\u00020\u0018*\u00020\u00112\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020 H\u0002J$\u0010(\u001a\u00020)2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00150\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "fileToInitializationFuns", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getFileToInitializationFuns", "()Ljava/util/Map;", "fileToInitializerPureness", "", "getFileToInitializerPureness", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "createInitializationFunction", "file", "createInitializationField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "fileName", "", "buildPropertiesInitializationBody", "initializers", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "initializedField", "buildBodyWithIfGuard", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPropertyLazyInitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyLazyInitLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,300:1\n275#2:301\n269#2,10:302\n75#2,4:312\n220#3,2:316\n*S KotlinDebug\n*F\n+ 1 PropertyLazyInitLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering\n*L\n104#1:301\n104#1:302,10\n120#1:312,4\n149#1:316,2\n*E\n"})
public final class PropertyLazyInitLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private static final ReadOnlyProperty<Object, IrStatementOriginImpl> PROPERTY_INIT_FUN_CALL$delegate = IrStatementOriginImpl.Companion.provideDelegate((Object)Companion, org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLowering$Companion.$$delegatedProperties[0]);

    public PropertyLazyInitLowering(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    private final IrBuiltIns getIrBuiltIns() {
        return this.context.getIrBuiltIns();
    }

    private final IrFactory getIrFactory() {
        return this.context.getIrFactory();
    }

    private final Map<IrFile, IrSimpleFunction> getFileToInitializationFuns() {
        return this.context.getPropertyLazyInitialization().getFileToInitializationFuns();
    }

    private final Map<IrFile, Boolean> getFileToInitializerPureness() {
        return this.context.getPropertyLazyInitialization().getFileToInitializerPureness();
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.context.getPropertyLazyInitialization().getEnabled()) {
            return;
        }
        if (!(container instanceof IrField || container instanceof IrSimpleFunction || container instanceof IrProperty)) {
            return;
        }
        if (!PropertyLazyInitLoweringKt.access$isCompatibleDeclaration(container, this.context)) {
            return;
        }
        IrDeclarationParent irDeclarationParent = ((IrDeclarationBase)container).getParent();
        IrFile irFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        if (irFile == null) {
            return;
        }
        IrFile file = irFile;
        if (this.getFileToInitializationFuns().containsKey(file)) {
            irSimpleFunction = this.getFileToInitializationFuns().get(file);
        } else if (Intrinsics.areEqual((Object)this.getFileToInitializerPureness().get(file), (Object)true)) {
            irSimpleFunction = null;
        } else {
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction it = irSimpleFunction2 = this.createInitializationFunction(file);
            boolean bl = false;
            this.getFileToInitializationFuns().put(file, it);
            irSimpleFunction = irSimpleFunction2;
        }
        if (irSimpleFunction == null) {
            return;
        }
        IrSimpleFunction initFun = irSimpleFunction;
        IrCall initializationCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, initFun.getSymbol(), initFun.getReturnType(), null, Companion.getPROPERTY_INIT_FUN_CALL(), null, 0, 0, 116, null);
        if (container instanceof IrSimpleFunction) {
            MiscKt.prependFunctionCall(irBody, initializationCall);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createInitializationFunction(IrFile file) {
        IrSimpleFunction irSimpleFunction;
        void $this$addFunction$iv;
        String fileName = IrDeclarationsKt.getName(file);
        List declarations2 = CollectionsKt.toList((Iterable)file.getDeclarations());
        Map fieldToInitializer = PropertyLazyInitLoweringKt.access$calculateFieldToExpression(declarations2, this.context);
        if (fieldToInitializer.isEmpty()) {
            return null;
        }
        boolean allFieldsInFilePure = PropertyLazyInitLoweringKt.access$allFieldsInFilePure(fieldToInitializer.values());
        this.getFileToInitializerPureness().put(file, allFieldsInFilePure);
        if (allFieldsInFilePure) {
            return null;
        }
        Object object = this.createInitializationField(this.getIrFactory(), fileName);
        IrField $this$createInitializationFunction_u24lambda_u240 = object;
        boolean bl = false;
        file.getDeclarations().add($this$createInitializationFunction_u24lambda_u240);
        $this$createInitializationFunction_u24lambda_u240.setParent(file);
        IrField initializedField = object;
        object = this.getIrFactory();
        IrDeclarationContainer klass$iv = file;
        boolean $i$f$addFunction = false;
        void $this$buildFun$iv$iv = $this$addFunction$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv$iv = new IrFunctionBuilder();
        boolean bl2 = false;
        IrFunctionBuilder $this$createInitializationFunction_u24lambda_u241 = $this$buildFun_u24lambda_u240$iv$iv;
        boolean bl3 = false;
        Name name2 = Name.special("<init properties " + fileName + '>');
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        $this$createInitializationFunction_u24lambda_u241.setName(name2);
        $this$createInitializationFunction_u24lambda_u241.setStartOffset(-2);
        $this$createInitializationFunction_u24lambda_u241.setEndOffset(-2);
        $this$createInitializationFunction_u24lambda_u241.setReturnType(this.getIrBuiltIns().getUnitType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"INTERNAL");
        $this$createInitializationFunction_u24lambda_u241.setVisibility(descriptorVisibility);
        $this$createInitializationFunction_u24lambda_u241.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        IrSimpleFunction function$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv, $this$buildFun_u24lambda_u240$iv$iv);
        boolean bl4 = false;
        klass$iv.getDeclarations().add(function$iv);
        function$iv.setParent(klass$iv);
        Object $this$createInitializationFunction_u24lambda_u242 = object = irSimpleFunction;
        boolean bl5 = false;
        this.buildPropertiesInitializationBody((IrSimpleFunction)$this$createInitializationFunction_u24lambda_u242, fieldToInitializer, initializedField);
        return object;
    }

    private final IrField createInitializationField(IrFactory $this$createInitializationField, String fileName) {
        IrFactory $this$buildField$iv = $this$createInitializationField;
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$createInitializationField_u24lambda_u240 = $this$buildField_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("properties initialized " + fileName);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$createInitializationField_u24lambda_u240.setName(name2);
        $this$createInitializationField_u24lambda_u240.setType(this.getIrBuiltIns().getBooleanType());
        $this$createInitializationField_u24lambda_u240.setStatic(true);
        $this$createInitializationField_u24lambda_u240.setFinal(true);
        $this$createInitializationField_u24lambda_u240.setOrigin(JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION());
        return DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u241$iv);
    }

    private final void buildPropertiesInitializationBody(IrSimpleFunction $this$buildPropertiesInitializationBody, Map<IrField, ? extends IrExpression> initializers, IrField initializedField) {
        $this$buildPropertiesInitializationBody.setBody(IrFactoryHelpersKt.createBlockBody(this.getIrFactory(), -1, -1, CollectionsKt.listOf((Object)this.buildBodyWithIfGuard(initializers, initializedField))));
    }

    private final IrStatement buildBodyWithIfGuard(Map<IrField, ? extends IrExpression> initializers, IrField initializedField) {
        List list;
        List $this$buildBodyWithIfGuard_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        IrSetField upGuard = PropertyLazyInitLoweringKt.access$createIrSetField(initializedField, JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true));
        $this$buildBodyWithIfGuard_u24lambda_u240.add(upGuard);
        Map<IrField, ? extends IrExpression> $this$forEach$iv = initializers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrField, ? extends IrExpression>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IrField, ? extends IrExpression> element$iv;
            Map.Entry<IrField, ? extends IrExpression> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            IrField field = entry.getKey();
            IrExpression expression2 = entry.getValue();
            $this$buildBodyWithIfGuard_u24lambda_u240.add(PropertyLazyInitLoweringKt.access$createIrSetField(field, expression2));
        }
        $this$buildBodyWithIfGuard_u24lambda_u240.add(JsIrBuilder.INSTANCE.buildBlock(this.getIrBuiltIns().getUnitType()));
        List statements = CollectionsKt.build((List)list);
        return JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.getIrBuiltIns().getUnitType(), PropertyLazyInitLoweringKt.access$createIrGetField(initializedField), JsIrBuilder.INSTANCE.buildBlock(this.getIrBuiltIns().getUnitType()), JsIrBuilder.INSTANCE.buildComposite(this.getIrBuiltIns().getUnitType(), statements), 0, 0, 0, 0, 240, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyLazyInitLowering$Companion;", "", "<init>", "()V", "PROPERTY_INIT_FUN_CALL", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "getPROPERTY_INIT_FUN_CALL", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "PROPERTY_INIT_FUN_CALL$delegate", "Lkotlin/properties/ReadOnlyProperty;", "backend.js"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final IrStatementOriginImpl getPROPERTY_INIT_FUN_CALL() {
            return (IrStatementOriginImpl)PROPERTY_INIT_FUN_CALL$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "PROPERTY_INIT_FUN_CALL", "getPROPERTY_INIT_FUN_CALL()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

