/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.stubs.KotlinClassifierStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010\f\u001a\u0004\u0018\u00010\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0081\u0010\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\t*\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0012*\u00020\u0007H\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\u001e*\u00020\u0007H\u0001\u00a2\u0006\u0002\b\u001fJ}\u0010 \u001a\u00020\t\"\b\b\u0000\u0010!*\u00020\u0001\"\b\b\u0001\u0010\"*\u00020\u0001*\u00020\n2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"\u0018\u00010$2\u001d\u0010%\u001a\u0019\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u00020\t0&\u00a2\u0006\u0002\b'2\u001d\u0010(\u001a\u0019\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u00020\t0&\u00a2\u0006\u0002\b'H\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b)Je\u0010*\u001a\u0010\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"\u0018\u00010$\"\b\b\u0000\u0010!*\u00020\u0001\"\b\b\u0001\u0010\"*\u00020\u0001*\u00020\u00072\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H!0,\u00a2\u0006\u0002\b'2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\"0,\u00a2\u0006\u0002\b'H\u0001\u00a2\u0006\u0002\b.JN\u0010/\u001a\u00020\t\"\b\b\u0000\u00100*\u00020\u0001*\u00020\n2\u000e\u00101\u001a\n\u0012\u0004\u0012\u0002H0\u0018\u0001022\u001d\u00103\u001a\u0019\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u00020\t0&\u00a2\u0006\u0002\b'H\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b4J<\u00105\u001a\n\u0012\u0004\u0012\u0002H0\u0018\u000106\"\b\b\u0000\u00100*\u00020\u0001*\u00020\u00072\u0017\u00107\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H00,\u00a2\u0006\u0002\b'H\u0001\u00a2\u0006\u0002\b8\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/StubUtils;", "", "<init>", "()V", "deserializeClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "dataStream", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream;", "serializeClassId", "", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubOutputStream;", "classId", "createNestedClassId", "parentStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "isDeclaredInsideValueArgument", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "isDeclaredInsideValueArgument$psi_impl", "writeNullableBoolean", "value", "writeNullableBoolean$psi_impl", "(Lcom/intellij/psi/stubs/StubOutputStream;Ljava/lang/Boolean;)V", "readNullableBoolean", "readNullableBoolean$psi_impl", "(Lcom/intellij/psi/stubs/StubInputStream;)Ljava/lang/Boolean;", "readFqName", "Lorg/jetbrains/kotlin/name/FqName;", "readFqName$psi_impl", "writeNullableMap", "K", "V", "map", "", "keyWriter", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "valueWriter", "writeNullableMap$psi_impl", "readNullableMap", "keyReader", "Lkotlin/Function1;", "valueReader", "readNullableMap$psi_impl", "writeNullableCollection", "E", "collection", "", "elementWriter", "writeNullableCollection$psi_impl", "readNullableCollection", "", "elementReader", "readNullableCollection$psi_impl", "psi-impl"})
@SourceDebugExtension(value={"SMAP\nStubUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StubUtils.kt\norg/jetbrains/kotlin/psi/stubs/StubUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n220#2,2:147\n1914#3,2:149\n*S KotlinDebug\n*F\n+ 1 StubUtils.kt\norg/jetbrains/kotlin/psi/stubs/StubUtils\n*L\n94#1:147,2\n127#1:149,2\n*E\n"})
public final class StubUtils {
    @NotNull
    public static final StubUtils INSTANCE = new StubUtils();

    private StubUtils() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId deserializeClassId(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            return null;
        }
        StringRef classId = stringRef;
        String string = classId.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return ClassId.Companion.fromString$default(ClassId.Companion, string, false, 2, null);
    }

    @JvmStatic
    public static final void serializeClassId(@NotNull StubOutputStream dataStream, @Nullable ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        ClassId classId2 = classId;
        dataStream.writeName(classId2 != null ? classId2.asString() : null);
    }

    @JvmStatic
    @Nullable
    public static final ClassId createNestedClassId(@NotNull StubElement<?> parentStub, @NotNull KtClassLikeDeclaration currentDeclaration) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        Intrinsics.checkNotNullParameter((Object)currentDeclaration, (String)"currentDeclaration");
        if (currentDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)currentDeclaration).isObjectLiteral()) {
            return null;
        }
        StubElement<?> stubElement = parentStub;
        if (stubElement instanceof KotlinFileStub) {
            FqName fqName = ((KotlinFileStub)parentStub).getPackageFqName();
            Name name2 = currentDeclaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getNameAsSafeName(...)");
            classId = new ClassId(fqName, name2);
        } else if (stubElement instanceof KotlinScriptStub) {
            StubElement stubElement2 = ((KotlinScriptStub)parentStub).getParentStub();
            Intrinsics.checkNotNullExpressionValue((Object)stubElement2, (String)"getParentStub(...)");
            classId = StubUtils.createNestedClassId(stubElement2, currentDeclaration);
        } else if (stubElement instanceof KotlinPlaceHolderStub && Intrinsics.areEqual((Object)((KotlinPlaceHolderStub)parentStub).getStubType(), KtStubElementTypes.CLASS_BODY)) {
            KotlinClassifierStub containingClassStub;
            StubElement stubElement3 = ((KotlinPlaceHolderStub)parentStub).getParentStub();
            KotlinClassifierStub kotlinClassifierStub = containingClassStub = stubElement3 instanceof KotlinClassifierStub ? (KotlinClassifierStub)stubElement3 : null;
            if (containingClassStub != null && !(currentDeclaration instanceof KtEnumEntry)) {
                ClassId classId2 = containingClassStub.getClassId();
                if (classId2 != null) {
                    Name name3 = currentDeclaration.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getNameAsSafeName(...)");
                    classId = classId2.createNestedClassId(name3);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }

    @JvmStatic
    public static final boolean isDeclaredInsideValueArgument$psi_impl(@Nullable ASTNode node) {
        boolean bl;
        while (true) {
            IElementType iElementType;
            ASTNode parent2;
            ASTNode aSTNode = node;
            ASTNode aSTNode2 = parent2 = aSTNode != null ? aSTNode.getTreeParent() : null;
            IElementType iElementType2 = iElementType = aSTNode2 != null ? aSTNode2.getElementType() : null;
            if (Intrinsics.areEqual((Object)iElementType, KtStubElementTypes.VALUE_ARGUMENT)) {
                bl = true;
                break;
            }
            if (iElementType == null || KtTokenSets.DECLARATION_TYPES.contains(iElementType)) {
                bl = false;
                break;
            }
            node = parent2;
        }
        return bl;
    }

    @JvmStatic
    public static final void writeNullableBoolean$psi_impl(@NotNull StubOutputStream $this$writeNullableBoolean, @Nullable Boolean value2) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$writeNullableBoolean, (String)"<this>");
        Boolean bl = value2;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            n2 = 0;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            n2 = 1;
        } else if (bl == null) {
            n2 = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int n3 = n2;
        $this$writeNullableBoolean.writeByte(n3);
    }

    @JvmStatic
    @Nullable
    public static final Boolean readNullableBoolean$psi_impl(@NotNull StubInputStream $this$readNullableBoolean) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$readNullableBoolean, (String)"<this>");
        switch ($this$readNullableBoolean.readByte()) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final FqName readFqName$psi_impl(@NotNull StubInputStream $this$readFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$readFqName, (String)"<this>");
        String string = $this$readFqName.readNameString();
        Intrinsics.checkNotNull((Object)string);
        return new FqName(string);
    }

    @JvmStatic
    public static final <K, V> void writeNullableMap$psi_impl(@NotNull StubOutputStream $this$writeNullableMap, @Nullable Map<K, ? extends V> map, @NotNull Function2<? super StubOutputStream, ? super K, Unit> keyWriter, @NotNull Function2<? super StubOutputStream, ? super V, Unit> valueWriter) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$writeNullableMap, (String)"<this>");
            Intrinsics.checkNotNullParameter(keyWriter, (String)"keyWriter");
            Intrinsics.checkNotNullParameter(valueWriter, (String)"valueWriter");
            boolean $i$f$writeNullableMap$psi_impl = false;
            Map<K, V> map2 = map;
            int nullableSize = map2 != null ? map2.size() + 1 : 0;
            $this$writeNullableMap.writeVarInt(nullableSize);
            Map<K, V> map3 = map;
            if (map3 == null) break block1;
            Map<K, V> $this$forEach$iv = map3;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<K, V> element$iv;
                Map.Entry<K, V> entry = element$iv = iterator2.next();
                boolean bl = false;
                keyWriter.invoke((Object)$this$writeNullableMap, entry.getKey());
                valueWriter.invoke((Object)$this$writeNullableMap, entry.getValue());
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final <K, V> Map<K, V> readNullableMap$psi_impl(@NotNull StubInputStream $this$readNullableMap, @NotNull Function1<? super StubInputStream, ? extends K> keyReader, @NotNull Function1<? super StubInputStream, ? extends V> valueReader) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$readNullableMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(keyReader, (String)"keyReader");
        Intrinsics.checkNotNullParameter(valueReader, (String)"valueReader");
        int nullableSize = $this$readNullableMap.readVarInt();
        if (nullableSize == 0) {
            map = null;
        } else {
            int size = nullableSize - 1;
            switch (size) {
                case 0: {
                    map = MapsKt.emptyMap();
                    break;
                }
                case 1: {
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)keyReader.invoke((Object)$this$readNullableMap), (Object)valueReader.invoke((Object)$this$readNullableMap)));
                    break;
                }
                default: {
                    Map map2;
                    Map $this$readNullableMap_u24lambda_u240 = map2 = MapsKt.createMapBuilder((int)size);
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < size) {
                        int it = n2++;
                        boolean bl2 = false;
                        Object key = keyReader.invoke((Object)$this$readNullableMap);
                        Object value2 = valueReader.invoke((Object)$this$readNullableMap);
                        $this$readNullableMap_u24lambda_u240.put(key, value2);
                    }
                    map = MapsKt.build((Map)map2);
                }
            }
        }
        return map;
    }

    @JvmStatic
    public static final <E> void writeNullableCollection$psi_impl(@NotNull StubOutputStream $this$writeNullableCollection, @Nullable Collection<? extends E> collection, @NotNull Function2<? super StubOutputStream, ? super E, Unit> elementWriter) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$writeNullableCollection, (String)"<this>");
            Intrinsics.checkNotNullParameter(elementWriter, (String)"elementWriter");
            boolean $i$f$writeNullableCollection$psi_impl = false;
            Collection<E> collection2 = collection;
            int nullableSize = collection2 != null ? collection2.size() + 1 : 0;
            $this$writeNullableCollection.writeVarInt(nullableSize);
            Collection<E> collection3 = collection;
            if (collection3 == null) break block1;
            Iterable $this$forEach$iv = collection3;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                elementWriter.invoke((Object)$this$writeNullableCollection, it);
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final <E> List<E> readNullableCollection$psi_impl(@NotNull StubInputStream $this$readNullableCollection, @NotNull Function1<? super StubInputStream, ? extends E> elementReader) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$readNullableCollection, (String)"<this>");
        Intrinsics.checkNotNullParameter(elementReader, (String)"elementReader");
        int nullableSize = $this$readNullableCollection.readVarInt();
        if (nullableSize == 0) {
            list = null;
        } else {
            int size = nullableSize - 1;
            switch (size) {
                case 0: {
                    list = CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    list = CollectionsKt.listOf((Object)elementReader.invoke((Object)$this$readNullableCollection));
                    break;
                }
                default: {
                    List list2;
                    List $this$readNullableCollection_u24lambda_u240 = list2 = CollectionsKt.createListBuilder((int)size);
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < size) {
                        int it = n2++;
                        boolean bl2 = false;
                        $this$readNullableCollection_u24lambda_u240.add(elementReader.invoke((Object)$this$readNullableCollection));
                    }
                    list = CollectionsKt.build((List)list2);
                }
            }
        }
        return list;
    }
}

