/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nUpperBoundViolatedInTypealiasConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpperBoundViolatedInTypealiasConstructorChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n249#2:54\n1204#3,2:55\n1281#3,4:57\n1585#3:61\n1660#3,3:62\n*S KotlinDebug\n*F\n+ 1 UpperBoundViolatedInTypealiasConstructorChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker\n*L\n25#1:54\n31#1:55,2\n31#1:57,4\n37#1:61\n37#1:62,3\n*E\n"})
public final class UpperBoundViolatedInTypealiasConstructorChecker
implements CallChecker {
    @NotNull
    public static final UpperBoundViolatedInTypealiasConstructorChecker INSTANCE = new UpperBoundViolatedInTypealiasConstructorChecker();

    private UpperBoundViolatedInTypealiasConstructorChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        void $this$mapTo$iv$iv;
        Object it;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = obj instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)obj : null;
        if (typeAliasConstructorDescriptor == null) {
            return;
        }
        TypeAliasConstructorDescriptor resultingDescriptor = typeAliasConstructorDescriptor;
        PsiElement $this$getStrictParentOfType$iv = reportOn;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtCallExpression.class, true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        KotlinType kotlinType = resultingDescriptor.getUnderlyingConstructorDescriptor().getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getReturnType(...)");
        KotlinType underlyingConstructedType = kotlinType;
        List<TypeProjection> underlyingTypeArguments = underlyingConstructedType.getArguments();
        List<TypeParameterDescriptor> list = resultingDescriptor.getUnderlyingConstructorDescriptor().getReturnType().getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        List<TypeParameterDescriptor> underlyingTypeParameters = list;
        ClassicTypeCheckerState state = new ClassicTypeCheckerState(false, false, null, null, null, 30, null);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)underlyingTypeParameters);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object object = destination$iv$iv;
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = new Pair((Object)((TypeParameterDescriptor)it.getValue()).getTypeConstructor(), (Object)underlyingTypeArguments.get(it.getIndex()).getType().unwrap());
            object.put(it.getFirst(), it.getSecond());
        }
        Map map = destination$iv$iv;
        NewTypeSubstitutorByConstructorMap substitutor2 = new NewTypeSubstitutorByConstructorMap(map);
        List<TypeParameterDescriptor> list2 = resolvedCall2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
        List<TypeParameterDescriptor> aliasTypeParameters = list2;
        Iterable $this$map$iv = resultingDescriptor.getTypeAliasDescriptor().getUnderlyingType().getArguments();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getType());
        }
        List originalTypes = (List)destination$iv$iv2;
        Iterator iterator2 = ((Iterable)CollectionsKt.zip((Iterable)underlyingTypeArguments, (Iterable)underlyingTypeParameters)).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            Pair argumentAndParameter = (Pair)iterator2.next();
            TypeProjection argument = (TypeProjection)argumentAndParameter.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)argumentAndParameter.component2();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.getOrNull(aliasTypeParameters, (int)index);
            if (Intrinsics.areEqual((Object)(typeParameterDescriptor != null ? typeParameterDescriptor.getDefaultType() : null), (Object)CollectionsKt.getOrNull((List)originalTypes, (int)index))) continue;
            for (KotlinType upperBound : parameter.getUpperBounds()) {
                KtModifierListOwnerStub ktModifierListOwnerStub;
                TypeCheckerState typeCheckerState = state;
                KotlinType kotlinType2 = argument.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState, (KotlinTypeMarker)kotlinType2, (KotlinTypeMarker)substitutor2.safeSubstitute(upperBound.unwrap()), false, 8, null) || (ktModifierListOwnerStub = (KtTypeProjection)CollectionsKt.getOrNull(callExpression.getTypeArguments(), (int)index)) == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) continue;
                KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
                context2.getTrace().report(Errors.UPPER_BOUND_VIOLATED_WARNING.on((KtTypeReference)typeReference, upperBound, argument.getType()));
            }
        }
    }
}

