/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfigurator;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatformAnalyzerServices;", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "<init>", "()V", "computePlatformSpecificDefaultImports", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "result", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "defaultLowPriorityImports", "", "getDefaultLowPriorityImports", "()Ljava/util/List;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "frontend.java"})
public final class JvmPlatformAnalyzerServices
extends PlatformDependentAnalyzerServices {
    @NotNull
    public static final JvmPlatformAnalyzerServices INSTANCE = new JvmPlatformAnalyzerServices();
    @NotNull
    private static final List<ImportPath> defaultLowPriorityImports = CollectionsKt.listOf((Object)ImportPath.Companion.fromString("java.lang.*"));
    @NotNull
    private static final PlatformConfigurator platformConfigurator = JvmPlatformConfigurator.INSTANCE;

    private JvmPlatformAnalyzerServices() {
    }

    @Override
    public void computePlatformSpecificDefaultImports(@NotNull StorageManager storageManager, @NotNull List<ImportPath> result2) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        result2.add(ImportPath.Companion.fromString("kotlin.jvm.*"));
        for (PackageViewDescriptor builtInPackage : new JvmBuiltIns(storageManager, JvmBuiltIns.Kind.FALLBACK).getBuiltInPackagesImportedByDefault()) {
            JvmPlatformAnalyzerServices.computePlatformSpecificDefaultImports$addAllClassifiersFromScope(result2, builtInPackage.getMemberScope());
        }
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultLowPriorityImports() {
        return defaultLowPriorityImports;
    }

    @Override
    @NotNull
    public PlatformConfigurator getPlatformConfigurator() {
        return platformConfigurator;
    }

    private static final void computePlatformSpecificDefaultImports$addAllClassifiersFromScope(List<ImportPath> $result, MemberScope scope2) {
        for (DeclarationDescriptor descriptor : scope2.getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER())) {
            FqName fqName = DescriptorUtils.getFqNameSafe(descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"getFqNameSafe(...)");
            $result.add(new ImportPath(fqName, false, null, 4, null));
        }
    }
}

