/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.js;

import java.io.ByteArrayInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.js.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/js/KotlinJavaScriptMetadataStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "<init>", "()V", "getStubVersion", "", "supportedFileType", "Lorg/jetbrains/kotlin/com/intellij/openapi/fileTypes/FileType;", "getSupportedFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "expectedBinaryVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getExpectedBinaryVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "hasMetadata", "", "virtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "readFile", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "content", "", "decompiler-js"})
public final class KotlinJavaScriptMetadataStubBuilder
extends KotlinMetadataStubBuilder {
    @NotNull
    public static final KotlinJavaScriptMetadataStubBuilder INSTANCE = new KotlinJavaScriptMetadataStubBuilder();

    private KotlinJavaScriptMetadataStubBuilder() {
    }

    @Override
    public int getStubVersion() {
        return 235;
    }

    @Override
    @NotNull
    protected FileType getSupportedFileType() {
        return KotlinJavaScriptMetaFileType.INSTANCE;
    }

    @Override
    @NotNull
    protected BinaryVersion getExpectedBinaryVersion() {
        return JsMetadataVersion.INSTANCE;
    }

    @Override
    protected boolean hasMetadata(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return true;
    }

    @Override
    @NotNull
    protected KotlinMetadataStubBuilder.FileWithMetadata readFile(@NotNull VirtualFile virtualFile, @Nullable byte[] content) {
        byte[] content2;
        ByteArrayInputStream stream;
        JsMetadataVersion version2;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        byte[] byArray = content;
        if (content == null) {
            byte[] byArray2 = virtualFile.contentsToByteArray(false);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"contentsToByteArray(...)");
        }
        if (!(version2 = JsMetadataVersion.Companion.readFrom(stream = new ByteArrayInputStream(content2 = byArray))).isCompatibleWithCurrentCompilerVersion()) {
            return new KotlinMetadataStubBuilder.FileWithMetadata.Incompatible(version2);
        }
        JsProtoBuf.Header.parseDelimitedFrom(stream);
        ProtoBuf.PackageFragment proto = ProtoBuf.PackageFragment.parseFrom(stream, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
        Intrinsics.checkNotNull((Object)proto);
        return new KotlinMetadataStubBuilder.FileWithMetadata.Compatible(proto, version2, JsSerializerProtocol.INSTANCE);
    }
}

