/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.PreSerializationNativeSymbols;
import org.jetbrains.kotlin.backend.common.ir.PreSerializationSymbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/KlibAssertionWrapperLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "asserts", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isAssertionArgumentEvaluationEnabled", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "lower", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Transformer", "ir.backend.common"})
public abstract class KlibAssertionWrapperLowering
implements FileLoweringPass {
    @NotNull
    private final LoweringContext context;
    @NotNull
    private final Set<IrSimpleFunctionSymbol> asserts;

    public KlibAssertionWrapperLowering(@NotNull LoweringContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        PreSerializationSymbols preSerializationSymbols = this.context.getSymbols();
        Intrinsics.checkNotNull((Object)preSerializationSymbols, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.backend.common.ir.PreSerializationNativeSymbols");
        this.asserts = CollectionsKt.toSet(((PreSerializationNativeSymbols)preSerializationSymbols).getAsserts());
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    @NotNull
    protected abstract IrSimpleFunctionSymbol isAssertionArgumentEvaluationEnabled();

    public final void lower(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        function2.transformChildren(new Transformer(), function2.getSymbol());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transformChildren(new Transformer(), irFile.getSymbol());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/KlibAssertionWrapperLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/KlibAssertionWrapperLowering;)V", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "data", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.backend.common"})
    private final class Transformer
    extends IrTransformer<IrSymbol> {
        @Override
        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrSymbol data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return super.visitElement(element, element instanceof IrSymbolOwner ? ((IrSymbolOwner)element).getSymbol() : data);
        }

        @Override
        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrSymbol data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return super.visitDeclaration(declaration, declaration.getSymbol());
        }

        @Override
        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrSymbol data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!KlibAssertionWrapperLowering.this.asserts.contains(expression2.getSymbol())) {
                return super.visitCall(expression2, data);
            }
            DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder(KlibAssertionWrapperLowering.this.getContext(), data, expression2.getStartOffset(), expression2.getEndOffset());
            return LowerUtilsKt.irIfThen(builder2, ExpressionHelpersKt.irCall((IrBuilder)builder2, KlibAssertionWrapperLowering.this.isAssertionArgumentEvaluationEnabled()), expression2);
        }
    }
}

