/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.ClassFakeOverrideReplacement;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarationsKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0017J\u001c\u0010\u0019\u001a\u00020\u0017*\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\b\b\u0002\u0010\u001f\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017J\u0012\u0010%\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0017H\u0002J\"\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u0017H\u0002J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmCachedDeclarations;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "fieldsForObjectInstances", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;)V", "getFieldsForObjectInstances", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getFieldForEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "getFieldForObjectInstance", "singleton", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getPrivateFieldForObjectInstance", "getStaticBackingField", "irProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getStaticAndCompanionDeclaration", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "jvmStaticFunction", "makeProxy", "target", "isStatic", "", "getDefaultImplsFunction", "interfaceFun", "forCompatibilityMode", "getDefaultImplsClass", "interfaceClass", "getClassFakeOverrideReplacement", "Lorg/jetbrains/kotlin/backend/jvm/ClassFakeOverrideReplacement;", "fakeOverride", "computeClassFakeOverrideReplacement", "findDefaultImplsRedirection", "Lorg/jetbrains/kotlin/backend/jvm/ClassFakeOverrideReplacement$DefaultImplsRedirection;", "implementation", "newFunction", "superFunction", "needsJvmDefaultCompatibilityBridge", "declaration", "getRepeatedAnnotationSyntheticContainer", "annotationClass", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmCachedDeclarations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCachedDeclarations.kt\norg/jetbrains/kotlin/backend/jvm/JvmCachedDeclarations\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,419:1\n413#2:420\n414#2,2:425\n413#2:427\n414#2,2:432\n413#2:434\n414#2,2:439\n413#2:450\n414#2,2:454\n413#2:456\n414#2,2:461\n413#2,3:463\n413#2:488\n414#2,2:547\n75#3,4:421\n75#3,4:428\n269#3,4:435\n269#3,4:441\n51#3,4:457\n51#3,4:489\n321#3:493\n315#3,13:494\n128#3:507\n122#3,10:508\n75#3,4:518\n1586#4:445\n1661#4,3:446\n832#4:451\n862#4,2:452\n672#4,11:466\n672#4,11:477\n777#4:522\n873#4,2:523\n1586#4:525\n1661#4,2:526\n1663#4:546\n1#5:449\n17#6,16:528\n33#6:545\n19#7:544\n*S KotlinDebug\n*F\n+ 1 JvmCachedDeclarations.kt\norg/jetbrains/kotlin/backend/jvm/JvmCachedDeclarations\n*L\n51#1:420\n51#1:425,2\n75#1:427\n75#1:432,2\n112#1:434\n112#1:439,2\n195#1:450\n195#1:454,2\n246#1:456\n246#1:461,2\n261#1:463,3\n317#1:488\n317#1:547,2\n52#1:421,4\n76#1:428,4\n118#1:435,4\n137#1:441,4\n247#1:457,4\n318#1:489,4\n330#1:493\n330#1:494,13\n336#1:507\n336#1:508,10\n339#1:518,4\n168#1:445\n168#1:446,3\n235#1:451\n235#1:452,2\n305#1:466,11\n311#1:477,11\n350#1:522\n350#1:523,2\n355#1:525\n355#1:526,2\n355#1:546\n355#1:528,16\n355#1:545\n355#1:544\n*E\n"})
public final class JvmCachedDeclarations {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final CachedFieldsForObjectInstances fieldsForObjectInstances;

    public JvmCachedDeclarations(@NotNull JvmBackendContext context2, @NotNull CachedFieldsForObjectInstances fieldsForObjectInstances) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fieldsForObjectInstances, (String)"fieldsForObjectInstances");
        this.context = context2;
        this.fieldsForObjectInstances = fieldsForObjectInstances;
    }

    @NotNull
    public final CachedFieldsForObjectInstances getFieldsForObjectInstances() {
        return this.fieldsForObjectInstances;
    }

    @NotNull
    public final IrField getFieldForEnumEntry(@NotNull IrEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(enumEntry){

            public Object get() {
                return JvmCachedDeclarationsKt.access$getDeclaringField((IrEnumEntry)this.receiver);
            }

            public void set(Object value2) {
                JvmCachedDeclarationsKt.access$setDeclaringField((IrEnumEntry)this.receiver, (IrField)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            IrField irField;
            IrField irField2;
            boolean bl = false;
            IrFactory $this$buildField$iv = this.context.getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
            boolean bl2 = false;
            IrFieldBuilder $this$getFieldForEnumEntry_u24lambda_u240_u240 = $this$buildField_u24lambda_u241$iv;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange($this$getFieldForEnumEntry_u24lambda_u240_u240, enumEntry);
            $this$getFieldForEnumEntry_u24lambda_u240_u240.setName(enumEntry.getName());
            $this$getFieldForEnumEntry_u24lambda_u240_u240.setType(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(enumEntry)));
            $this$getFieldForEnumEntry_u24lambda_u240_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRY());
            $this$getFieldForEnumEntry_u24lambda_u240_u240.setFinal(true);
            $this$getFieldForEnumEntry_u24lambda_u240_u240.setStatic(true);
            IrField $this$getFieldForEnumEntry_u24lambda_u240_u241 = irField2 = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u241$iv);
            boolean bl4 = false;
            $this$getFieldForEnumEntry_u24lambda_u240_u241.setParent(enumEntry.getParent());
            IrField it$iv = irField = irField2;
            boolean bl5 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = irField;
        }
        return (IrField)object;
    }

    @NotNull
    public final IrField getFieldForObjectInstance(@NotNull IrClass singleton) {
        Intrinsics.checkNotNullParameter((Object)singleton, (String)"singleton");
        return this.fieldsForObjectInstances.getFieldForObjectInstance(singleton);
    }

    @NotNull
    public final IrField getPrivateFieldForObjectInstance(@NotNull IrClass singleton) {
        Intrinsics.checkNotNullParameter((Object)singleton, (String)"singleton");
        return this.fieldsForObjectInstances.getPrivateFieldForObjectInstance(singleton);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrField getStaticBackingField(@NotNull IrProperty irProperty) {
        Intrinsics.checkNotNullParameter((Object)irProperty, (String)"irProperty");
        if (irProperty.isFakeOverride()) {
            return null;
        }
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField oldField = irField;
        IrDeclarationParent irDeclarationParent = irProperty.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return null;
        }
        IrClass oldParent = irClass;
        if (!IrUtilsKt.isObject(oldParent)) {
            return null;
        }
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(irProperty){

            public Object get() {
                return JvmCachedDeclarationsKt.access$getStaticBackingFields((IrProperty)this.receiver);
            }

            public void set(Object value2) {
                JvmCachedDeclarationsKt.access$setStaticBackingFields((IrProperty)this.receiver, (IrField)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            IrField irField2;
            boolean shouldMoveFields;
            IrField irField3;
            boolean bl = false;
            IrFactory $this$buildField$iv = this.context.getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
            boolean bl2 = false;
            IrFieldBuilder $this$getStaticBackingField_u24lambda_u240_u240 = $this$buildField_u24lambda_u241$iv;
            boolean bl3 = false;
            $this$getStaticBackingField_u24lambda_u240_u240.updateFrom(oldField);
            $this$getStaticBackingField_u24lambda_u240_u240.setName(oldField.getName());
            $this$getStaticBackingField_u24lambda_u240_u240.setStatic(true);
            IrField $this$getStaticBackingField_u24lambda_u240_u241 = irField3 = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u241$iv);
            boolean bl4 = false;
            boolean hasJvmField = IrUtilsKt.hasAnnotation((IrAnnotationContainer)oldField, JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME);
            boolean bl5 = shouldMoveFields = oldParent.isCompanion() && (!JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(oldParent)) || hasJvmField);
            if (shouldMoveFields) {
                List list;
                $this$getStaticBackingField_u24lambda_u240_u241.setParent(IrUtilsKt.getParentAsClass(oldParent));
                boolean isPrivate = DescriptorVisibilities.isPrivate(oldField.getVisibility());
                boolean parentIsPrivate = DescriptorVisibilities.isPrivate(oldParent.getVisibility());
                IrField irField4 = $this$getStaticBackingField_u24lambda_u240_u241;
                if (parentIsPrivate && !isPrivate) {
                    void $this$getStaticBackingField_u24lambda_u240_u241_u240;
                    JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, $this$getStaticBackingField_u24lambda_u240_u241.getSymbol(), 0, 0, 6, null);
                    IrField irField5 = irField4;
                    boolean bl6 = false;
                    list = CollectionsKt.plus((Collection)AdditionalIrUtilsKt.filterOutAnnotations(DeprecationResolver.Companion.getJAVA_DEPRECATED(), oldField.getAnnotations()), (Object)ExpressionHelpersKt.irCall((IrBuilder)$this$getStaticBackingField_u24lambda_u240_u241_u240, $this$getStaticBackingField_u24lambda_u240_u241_u240.getIrSymbols().getJavaLangDeprecatedConstructorWithDeprecatedFlag()));
                    irField4 = irField5;
                } else {
                    list = oldField.getAnnotations();
                }
                irField4.setAnnotations(list);
            } else {
                $this$getStaticBackingField_u24lambda_u240_u241.setParent(oldParent);
                $this$getStaticBackingField_u24lambda_u240_u241.setAnnotations(oldField.getAnnotations());
            }
            IrExpressionBody irExpressionBody = oldField.getInitializer();
            $this$getStaticBackingField_u24lambda_u240_u241.setInitializer(irExpressionBody != null ? (IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpressionBody, $this$getStaticBackingField_u24lambda_u240_u241) : null);
            IrElement irElement = oldField;
            IrValueParameter irValueParameter = oldParent.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            JvmIrUtilsKt.replaceThisByStaticReference(irElement, this.fieldsForObjectInstances, oldParent, irValueParameter);
            $this$getStaticBackingField_u24lambda_u240_u241.setOrigin(IrUtilsKt.getParentAsClass(irProperty).isCompanion() ? JvmLoweredDeclarationOrigin.INSTANCE.getCOMPANION_PROPERTY_BACKING_FIELD() : $this$getStaticBackingField_u24lambda_u240_u241.getOrigin());
            IrField it$iv = irField2 = irField3;
            boolean bl7 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = irField2;
        }
        return (IrField)object;
    }

    @NotNull
    public final Pair<IrSimpleFunction, IrSimpleFunction> getStaticAndCompanionDeclaration(@NotNull IrSimpleFunction jvmStaticFunction) {
        Intrinsics.checkNotNullParameter((Object)jvmStaticFunction, (String)"jvmStaticFunction");
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(jvmStaticFunction){

            public Object get() {
                return JvmCachedDeclarationsKt.access$getStaticCompanionDeclarations((IrSimpleFunction)this.receiver);
            }

            public void set(Object value2) {
                JvmCachedDeclarationsKt.access$setStaticCompanionDeclarations((IrSimpleFunction)this.receiver, (Pair)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            Pair pair;
            Pair pair2;
            boolean bl = false;
            IrClass companion = IrUtilsKt.getParentAsClass(jvmStaticFunction);
            boolean bl2 = companion.isCompanion();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (jvmStaticFunction.isExternal()) {
                IrSimpleFunction irSimpleFunction;
                IrFactory $this$buildFun$iv = this.context.getIrFactory();
                boolean $i$f$buildFun = false;
                IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
                boolean bl3 = false;
                IrFunctionBuilder $this$getStaticAndCompanionDeclaration_u24lambda_u240_u240 = $this$buildFun_u24lambda_u240$iv;
                boolean bl4 = false;
                $this$getStaticAndCompanionDeclaration_u24lambda_u240_u240.updateFrom(jvmStaticFunction);
                $this$getStaticAndCompanionDeclaration_u24lambda_u240_u240.setName(jvmStaticFunction.getName());
                IrSimpleFunction $this$getStaticAndCompanionDeclaration_u24lambda_u240_u241 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
                boolean bl5 = false;
                $this$getStaticAndCompanionDeclaration_u24lambda_u240_u241.setParent(companion.getParent());
                IrDeclarationsKt.copyAttributes$default($this$getStaticAndCompanionDeclaration_u24lambda_u240_u241, jvmStaticFunction, false, 2, null);
                IrUtilsKt.copyAnnotationsFrom($this$getStaticAndCompanionDeclaration_u24lambda_u240_u241, jvmStaticFunction);
                JvmIrUtilsKt.copyCorrespondingPropertyFrom($this$getStaticAndCompanionDeclaration_u24lambda_u240_u241, jvmStaticFunction);
                IrUtilsKt.copyFunctionSignatureFrom$default($this$getStaticAndCompanionDeclaration_u24lambda_u240_u241, jvmStaticFunction, null, 2, null);
                $this$getStaticAndCompanionDeclaration_u24lambda_u240_u241.setParameters(IrUtilsKt.getNonDispatchParameters($this$getStaticAndCompanionDeclaration_u24lambda_u240_u241));
                $this$getStaticAndCompanionDeclaration_u24lambda_u240_u241.setMetadata(jvmStaticFunction.getMetadata());
                IrSimpleFunction staticExternal = irSimpleFunction;
                pair2 = TuplesKt.to((Object)staticExternal, (Object)this.makeProxy(companion, staticExternal, false));
            } else {
                pair2 = TuplesKt.to((Object)this.makeProxy(IrUtilsKt.getParentAsClass(companion), jvmStaticFunction, true), (Object)jvmStaticFunction);
            }
            Pair it$iv = pair = pair2;
            boolean bl6 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = pair;
        }
        return (Pair)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction makeProxy(IrClass $this$makeProxy, IrSimpleFunction target, boolean isStatic) {
        void $this$makeProxy_u24lambda_u241_u241_u240;
        void $this$makeProxy_u24lambda_u241_u241;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        DescriptorVisibility descriptorVisibility;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$makeProxy_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
        boolean bl = false;
        IrElementBuilderKt.setSourceRange($this$makeProxy_u24lambda_u240, target);
        $this$makeProxy_u24lambda_u240.setReturnType(target.getReturnType());
        $this$makeProxy_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getJVM_STATIC_WRAPPER());
        Name name2 = Name.identifier(MethodSignatureMapper.mapFunctionName$default(this.context.getDefaultMethodSignatureMapper(), target, false, 2, null));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$makeProxy_u24lambda_u240.setName(name2);
        $this$makeProxy_u24lambda_u240.setModality(IrUtilsKt.isInterface($this$makeProxy) ? Modality.OPEN : target.getModality());
        DescriptorVisibility descriptorVisibility2 = target.getVisibility();
        if (Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.INTERNAL)) {
            DescriptorVisibility descriptorVisibility3 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PUBLIC");
        } else if (Intrinsics.areEqual((Object)descriptorVisibility2, (Object)DescriptorVisibilities.PROTECTED)) {
            if (isStatic) {
                DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PROTECTED_STATIC_VISIBILITY;
                descriptorVisibility = descriptorVisibility4;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility4, (String)"PROTECTED_STATIC_VISIBILITY");
            } else {
                DescriptorVisibility descriptorVisibility5 = DescriptorVisibilities.PROTECTED;
                descriptorVisibility = descriptorVisibility5;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility5, (String)"PROTECTED");
            }
        } else {
            descriptorVisibility = target.getVisibility();
        }
        $this$makeProxy_u24lambda_u240.setVisibility(descriptorVisibility);
        $this$makeProxy_u24lambda_u240.setSuspend(target.isSuspend());
        IrSimpleFunction $this$makeProxy_u24lambda_u241 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
        boolean bl2 = false;
        $this$makeProxy_u24lambda_u241.setParent($this$makeProxy);
        IrDeclarationsKt.copyAttributes$default($this$makeProxy_u24lambda_u241, target, false, 2, null);
        IrUtilsKt.copyTypeParametersFrom$default($this$makeProxy_u24lambda_u241, target, null, null, 6, null);
        IrUtilsKt.copyAnnotationsFrom($this$makeProxy_u24lambda_u241, target);
        Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = IrUtilsKt.getNonDispatchParameters(target);
        IrSimpleFunction irSimpleFunction2 = $this$makeProxy_u24lambda_u241;
        boolean $i$f$map22 = false;
        descriptorVisibility2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it, $this$makeProxy_u24lambda_u241, null, 0, 0, null, null, null, null, null, false, false, false, null, null, 16382, null));
        }
        irSimpleFunction2.setParameters((List)destination$iv$iv);
        if (!isStatic) {
            IrValueParameter irValueParameter = $this$makeProxy.getThisReceiver();
            $this$makeProxy_u24lambda_u241.setParameters(CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(irValueParameter != null ? IrUtilsKt.copyTo$default(irValueParameter, $this$makeProxy_u24lambda_u241, null, 0, 0, null, null, IrUtilsKt.getDefaultType($this$makeProxy), null, null, false, false, false, IrParameterKind.DispatchReceiver, null, 12222, null) : null), (Iterable)$this$makeProxy_u24lambda_u241.getParameters()));
        }
        DeclarationIrBuilder $i$f$map22 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)$this$makeProxy_u24lambda_u241.getSymbol(), 0, 0, 6, null);
        irSimpleFunction2 = $this$makeProxy_u24lambda_u241;
        boolean bl4 = false;
        IrFunctionAccessExpression $i$f$mapTo22 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$makeProxy_u24lambda_u241_u241, target);
        IrBuilder irBuilder = (IrBuilder)$this$makeProxy_u24lambda_u241_u241;
        boolean bl5 = false;
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$makeProxy_u24lambda_u241_u241_u240, $this$makeProxy_u24lambda_u241, 0, 2, null);
        int dstIndex = 0;
        if (target.getDispatchReceiverParameter() != null) {
            $this$makeProxy_u24lambda_u241_u241_u240.getArguments().set(dstIndex++, ExpressionHelpersKt.irGetField$default((IrBuilder)$this$makeProxy_u24lambda_u241_u241, null, this.getFieldForObjectInstance(IrUtilsKt.getParentAsClass(target)), null, 4, null));
        }
        for (IrValueParameter param : $this$makeProxy_u24lambda_u241.getParameters()) {
            if (param.getKind() == IrParameterKind.DispatchReceiver) continue;
            $this$makeProxy_u24lambda_u241_u241_u240.getArguments().set(dstIndex++, ExpressionHelpersKt.irGet((IrBuilder)$this$makeProxy_u24lambda_u241_u241, param));
        }
        irSimpleFunction2.setBody(ExpressionHelpersKt.irExprBody(irBuilder, irFunctionAccessExpression));
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunction getDefaultImplsFunction(@NotNull IrSimpleFunction interfaceFun, boolean forCompatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)interfaceFun, (String)"interfaceFun");
        IrClass parent2 = IrUtilsKt.getParentAsClass(interfaceFun);
        boolean bl = JvmIrUtilsKt.isJvmInterface(parent2);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmCachedDeclarations$getDefaultImplsFunction$32 = false;
            String $i$a$-assert-JvmCachedDeclarations$getDefaultImplsFunction$32 = "Parent of " + DumpIrTreeKt.dump$default(interfaceFun, null, 1, null) + " should be interface";
            throw new AssertionError((Object)$i$a$-assert-JvmCachedDeclarations$getDefaultImplsFunction$32);
        }
        boolean bl2 = bl = !forCompatibilityMode || JvmCachedDeclarationsKt.access$getDefaultImplsMethod(interfaceFun) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmCachedDeclarations$getDefaultImplsFunction$42 = false;
            String $i$a$-assert-JvmCachedDeclarations$getDefaultImplsFunction$42 = "DefaultImpls stub in compatibility mode should be requested only once from interface lowering: " + DumpIrTreeKt.dump$default(interfaceFun, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-JvmCachedDeclarations$getDefaultImplsFunction$42);
        }
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(interfaceFun){

            public Object get() {
                return JvmCachedDeclarationsKt.access$getDefaultImplsMethod((IrSimpleFunction)this.receiver);
            }

            public void set(Object value2) {
                JvmCachedDeclarationsKt.access$setDefaultImplsMethod((IrSimpleFunction)this.receiver, (IrSimpleFunction)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            Object object2;
            boolean bl3 = false;
            IrClass defaultImpls = this.getDefaultImplsClass(IrUtilsKt.getParentAsClass(interfaceFun));
            IrDeclarationOrigin defaultImplsOrigin = !forCompatibilityMode && !interfaceFun.isFakeOverride() ? interfaceFun.getOrigin() : ((IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)interfaceFun)).getOrigin();
            Object object3 = DescriptorVisibilities.isPrivate(interfaceFun.getVisibility()) ? DescriptorVisibilities.PRIVATE : DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNull((Object)object3);
            DescriptorVisibility defaultImplsVisibility = object3;
            Object it = object3 = IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), defaultImpls, interfaceFun.getName(), interfaceFun, IrUtilsKt.getDefaultType(parent2), defaultImplsOrigin, Modality.OPEN, defaultImplsVisibility, false, false, parent2.getTypeParameters(), (Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.context){

                public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
                }
            }, 256, null);
            boolean bl4 = false;
            JvmIrUtilsKt.copyCorrespondingPropertyFrom((IrSimpleFunction)it, interfaceFun);
            if (forCompatibilityMode && !((IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)interfaceFun)).getOrigin().isSynthetic()) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                JvmIrBuilder $this$getDefaultImplsFunction_u24lambda_u242_u240_u240 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, ((IrSimpleFunction)it).getSymbol(), 0, 0, 6, null);
                boolean bl5 = false;
                Iterable iterable = it.getAnnotations();
                Object object4 = it;
                boolean $i$f$filterNot = false;
                void var18_23 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    IrConstructorCall it2 = (IrConstructorCall)element$iv$iv;
                    boolean bl6 = false;
                    if (AdditionalIrUtilsKt.hasEqualFqName(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)it2.getSymbol().getOwner()), DeprecationResolver.Companion.getJAVA_DEPRECATED())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object4.setAnnotations(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ExpressionHelpersKt.irCall((IrBuilder)$this$getDefaultImplsFunction_u24lambda_u242_u240_u240, $this$getDefaultImplsFunction_u24lambda_u242_u240_u240.getIrSymbols().getJavaLangDeprecatedConstructorWithDeprecatedFlag())));
            }
            JvmCachedDeclarationsKt.setOriginalFunctionForDefaultImpl((IrSimpleFunction)it, interfaceFun);
            Object it$iv = object2 = object3;
            boolean bl7 = false;
            $this$getOrSetIfNull$iv.set(it$iv);
            object = object2;
        }
        return (IrSimpleFunction)object;
    }

    public static /* synthetic */ IrSimpleFunction getDefaultImplsFunction$default(JvmCachedDeclarations jvmCachedDeclarations, IrSimpleFunction irSimpleFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jvmCachedDeclarations.getDefaultImplsFunction(irSimpleFunction, bl);
    }

    @NotNull
    public final IrClass getDefaultImplsClass(@NotNull IrClass interfaceClass) {
        Intrinsics.checkNotNullParameter((Object)interfaceClass, (String)"interfaceClass");
        KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(interfaceClass){

            public Object get() {
                return JvmCachedDeclarationsKt.access$getDefaultImplsClass((IrClass)this.receiver);
            }

            public void set(Object value2) {
                JvmCachedDeclarationsKt.access$setDefaultImplsClass((IrClass)this.receiver, (IrClass)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            IrClass irClass;
            IrClass irClass2;
            boolean bl = false;
            IrFactory $this$buildClass$iv = this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl2 = false;
            IrClassBuilder $this$getDefaultImplsClass_u24lambda_u240_u240 = $this$buildClass_u24lambda_u241$iv;
            boolean bl3 = false;
            $this$getDefaultImplsClass_u24lambda_u240_u240.setStartOffset(interfaceClass.getStartOffset());
            $this$getDefaultImplsClass_u24lambda_u240_u240.setEndOffset(interfaceClass.getEndOffset());
            $this$getDefaultImplsClass_u24lambda_u240_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getDEFAULT_IMPLS());
            Name name2 = Name.identifier("DefaultImpls");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$getDefaultImplsClass_u24lambda_u240_u240.setName(name2);
            IrClass $this$getDefaultImplsClass_u24lambda_u240_u241 = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
            boolean bl4 = false;
            $this$getDefaultImplsClass_u24lambda_u240_u241.setParent(interfaceClass);
            IrUtilsKt.createThisReceiverParameter($this$getDefaultImplsClass_u24lambda_u240_u241);
            IrClass it$iv = irClass = irClass2;
            boolean bl5 = false;
            $this$getOrSetIfNull$iv.set((Object)it$iv);
            object = irClass;
        }
        return (IrClass)object;
    }

    @NotNull
    public final ClassFakeOverrideReplacement getClassFakeOverrideReplacement(@NotNull IrSimpleFunction fakeOverride) {
        ClassFakeOverrideReplacement classFakeOverrideReplacement;
        Intrinsics.checkNotNullParameter((Object)fakeOverride, (String)"fakeOverride");
        if (!fakeOverride.isFakeOverride() || JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(fakeOverride))) {
            classFakeOverrideReplacement = ClassFakeOverrideReplacement.None.INSTANCE;
        } else {
            KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(fakeOverride){

                public Object get() {
                    return JvmCachedDeclarationsKt.access$getClassFakeOverrideReplacement((IrSimpleFunction)this.receiver);
                }

                public void set(Object value2) {
                    JvmCachedDeclarationsKt.access$setClassFakeOverrideReplacement((IrSimpleFunction)this.receiver, (ClassFakeOverrideReplacement)value2);
                }
            };
            boolean $i$f$getOrSetIfNull = false;
            Object object = $this$getOrSetIfNull$iv.get();
            if (object == null) {
                ClassFakeOverrideReplacement classFakeOverrideReplacement2;
                boolean bl = false;
                ClassFakeOverrideReplacement classFakeOverrideReplacement3 = this.computeClassFakeOverrideReplacement(fakeOverride);
                if (classFakeOverrideReplacement3 == null) {
                    classFakeOverrideReplacement3 = ClassFakeOverrideReplacement.None.INSTANCE;
                }
                ClassFakeOverrideReplacement it$iv = classFakeOverrideReplacement2 = classFakeOverrideReplacement3;
                boolean bl2 = false;
                $this$getOrSetIfNull$iv.set((Object)it$iv);
                object = classFakeOverrideReplacement2;
            }
            classFakeOverrideReplacement = (ClassFakeOverrideReplacement)object;
        }
        return classFakeOverrideReplacement;
    }

    private final ClassFakeOverrideReplacement computeClassFakeOverrideReplacement(IrSimpleFunction fakeOverride) {
        IrSimpleFunction irSimpleFunction = JvmDefaultUtilsKt.findInterfaceImplementation(fakeOverride, this.context.getConfig().getJvmDefaultMode(), true);
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction implementation2 = irSimpleFunction;
        IrSimpleFunction newFunction = JvmDefaultUtilsKt.createDefaultImplsRedirection(this.context.getIrFactory(), fakeOverride);
        this.context.remapMultiFieldValueClassStructure(fakeOverride, newFunction, null);
        IrSimpleFunction superFunction = (IrSimpleFunction)JvmIrUtilsKt.firstSuperMethodFromKotlin(newFunction, implementation2).getOwner();
        ClassFakeOverrideReplacement.DefaultImplsRedirection defaultImplsRedirection = this.findDefaultImplsRedirection(implementation2, newFunction, superFunction);
        if (defaultImplsRedirection != null) {
            ClassFakeOverrideReplacement.DefaultImplsRedirection it = defaultImplsRedirection;
            boolean bl = false;
            return it;
        }
        if (this.needsJvmDefaultCompatibilityBridge(fakeOverride)) {
            return new ClassFakeOverrideReplacement.DefaultCompatibilityBridge(newFunction, superFunction);
        }
        return null;
    }

    private final ClassFakeOverrideReplacement.DefaultImplsRedirection findDefaultImplsRedirection(IrSimpleFunction implementation2, IrSimpleFunction newFunction, IrSimpleFunction superFunction) {
        IrSimpleFunction irSimpleFunction;
        if (Intrinsics.areEqual((Object)implementation2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || Intrinsics.areEqual((Object)implementation2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) || IrUtilsKt.hasAnnotation((IrAnnotationContainer)implementation2, PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME())) {
            return null;
        }
        if (JvmDefaultUtilsKt.isDefinitelyNotDefaultImplsMethod(implementation2, this.context.getConfig().getJvmDefaultMode(), implementation2)) {
            IrClass klass = IrUtilsKt.getParentAsClass(newFunction);
            int n = WhenMappings.$EnumSwitchMapping$0[this.context.getConfig().getJvmDefaultMode().ordinal()];
            if (n == 1 && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)klass, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME())) {
                return null;
            }
            if (n == 2 && IrUtilsKt.hasAnnotation((IrAnnotationContainer)klass, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITHOUT_COMPATIBILITY_FQ_NAME())) {
                return null;
            }
            irSimpleFunction = superFunction;
        } else {
            irSimpleFunction = JvmCachedDeclarations.getDefaultImplsFunction$default(this, superFunction, false, 2, null);
        }
        IrSimpleFunction callee = irSimpleFunction;
        return new ClassFakeOverrideReplacement.DefaultImplsRedirection(newFunction, superFunction, callee);
    }

    private final boolean needsJvmDefaultCompatibilityBridge(IrSimpleFunction declaration) {
        IrSimpleFunction current;
        Object v0;
        IrSimpleFunctionSymbol it;
        boolean found$iv;
        Object single$iv;
        boolean $i$f$singleOrNull;
        Iterable $this$singleOrNull$iv;
        block7: {
            $this$singleOrNull$iv = declaration.getOverriddenSymbols();
            $i$f$singleOrNull = false;
            single$iv = null;
            found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl = false;
                if (!IrUtilsKt.isClass(IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner()))) continue;
                if (found$iv) {
                    v0 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = v0;
        IrSimpleFunction irSimpleFunction = current = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        while (current != null) {
            Object v3;
            block8: {
                if (current.getModality() == Modality.ABSTRACT) {
                    return false;
                }
                if (JvmDefaultUtilsKt.findInterfaceImplementation$default(current, this.context.getConfig().getJvmDefaultMode(), false, 2, null) != null) {
                    return true;
                }
                $this$singleOrNull$iv = current.getOverriddenSymbols();
                $i$f$singleOrNull = false;
                single$iv = null;
                found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl = false;
                    if (!IrUtilsKt.isClass(IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner()))) continue;
                    if (found$iv) {
                        v3 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v3 = !found$iv ? null : single$iv;
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = v3;
            current = irSimpleFunctionSymbol2 != null ? (IrSimpleFunction)irSimpleFunctionSymbol2.getOwner() : null;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final IrClass getRepeatedAnnotationSyntheticContainer(@NotNull IrClass annotationClass) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
            $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(annotationClass){

                public Object get() {
                    return JvmCachedDeclarationsKt.access$getRepeatedAnnotationSyntheticContainer((IrClass)this.receiver);
                }

                public void set(Object value2) {
                    JvmCachedDeclarationsKt.access$setRepeatedAnnotationSyntheticContainer((IrClass)this.receiver, (IrClass)value2);
                }
            };
            $i$f$getOrSetIfNull = false;
            v0 = $this$getOrSetIfNull$iv.get();
            if (v0 != null) break block5;
            $i$a$-getOrSetIfNull-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2 = false;
            $this$buildClass$iv = this.context.getIrFactory();
            $i$f$buildClass = false;
            $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            $i$a$-run-DeclarationBuildersKt$buildClass$2$iv = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u240 = $this$buildClass_u24lambda_u241$iv;
            $i$a$-buildClass-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$containerClass$1 = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u240.setKind(ClassKind.ANNOTATION_CLASS);
            v1 = Name.identifier("Container");
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"identifier(...)");
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u240.setName(v1);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u241 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
            $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$containerClass$2 = false;
            IrUtilsKt.createThisReceiverParameter((IrClass)$this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u241);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u241.setParent(annotationClass);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u241.setSuperTypes(CollectionsKt.listOf((Object)this.context.getIrBuiltIns().getAnnotationType()));
            containerClass = $this$buildClass$iv;
            v2 = Name.identifier("value");
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"identifier(...)");
            propertyName = v2;
            $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$containerClass$2 = new IrType[]{IrTypesKt.typeWith(annotationClass, new IrType[0])};
            propertyType = IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$containerClass$2);
            $this$addConstructor$iv = containerClass;
            $i$f$addConstructor = false;
            $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            $i$f$buildConstructor = false;
            $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
            $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv = false;
            $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
            $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u242 = $this$addConstructor_u24lambda_u240$iv;
            $i$a$-addConstructor-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$1 = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u242.setPrimary(true);
            $this$addConstructor_u24lambda_u240$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
            constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u241$iv$iv);
            $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u243 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
            $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$2 = false;
            DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u243, propertyName, (IrType)propertyType, null, 4, null);
            $this$addProperty$iv = containerClass;
            $i$f$addProperty = false;
            $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            $i$f$buildProperty = false;
            $this$buildProperty_u24lambda_u241$iv$iv = new IrPropertyBuilder();
            $i$a$-run-DeclarationBuildersKt$buildProperty$2$iv$iv = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u244 = $this$buildProperty_u24lambda_u241$iv$iv;
            $i$a$-addProperty-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$3 = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u244.setName(propertyName);
            property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u241$iv$iv);
            $i$a$-also-DeclarationBuildersKt$addProperty$1$iv = false;
            $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
            property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245 = $this$addProperty$iv = $this$buildProperty$iv$iv;
            $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$4 = false;
            $this$buildField$iv = this.context.getIrFactory();
            $i$f$buildField = false;
            $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv = false;
            $i$a$-addProperty-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$3 = $this$buildField_u24lambda_u241$iv;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u242 = $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245;
            $i$a$-buildField-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$4$1 = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245_u240.setName(propertyName);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245_u240.setType(propertyType);
            $i$f$buildField = $this$buildField$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, $this$buildField_u24lambda_u241$iv);
            $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$4$2 = false;
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245_u241.setParent((IrDeclarationParent)containerClass);
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245_u241.setCorrespondingPropertySymbol($this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245.getSymbol());
            $this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u242.setBackingField((IrField)$this$buildField$iv);
            DeclarationBuildersKt.addDefaultGetter((IrProperty)$this$getRepeatedAnnotationSyntheticContainer_u24lambda_u240_u245, (IrClass)containerClass, this.context.getIrBuiltIns());
            $this$addProperty$iv = annotationClass.getAnnotations();
            var18_47 = containerClass;
            $i$f$filter = false;
            $i$a$-apply-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$4 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (IrConstructorCall)element$iv$iv;
                $i$a$-filter-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$5 = false;
                if (AdditionalIrUtilsKt.isAnnotationWithEqualFqName(it, StandardNames.FqNames.retention) || AdditionalIrUtilsKt.isAnnotationWithEqualFqName(it, StandardNames.FqNames.target)) ** GOTO lbl-1000
                v3 = JvmAnnotationNames.INHERITED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"INHERITED_ANNOTATION");
                if (AdditionalIrUtilsKt.isAnnotationWithEqualFqName(it, v3)) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (IrConstructorCall)item$iv$iv;
                var19_48 = destination$iv$iv;
                $i$a$-map-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$6 = false;
                $i$a$-buildField-JvmCachedDeclarations$getRepeatedAnnotationSyntheticContainer$2$4$1 = it;
                initialParent$iv = (IrDeclarationParent)containerClass;
                $i$f$deepCopyWithSymbols = false;
                $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                $i$f$deepCopyImpl = false;
                symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                var25_54 = symbolRemapper$iv$iv;
                $i$a$-deepCopyWithSymbols-DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1 = false;
                p0 = var25_54;
                typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                v5 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                if (v5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
                }
                var19_48.add((IrConstructorCall)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrConstructorCall)v5), initialParent$iv));
            }
            var18_47.setAnnotations(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ExpressionHelpersKt.irCall((IrBuilder)JvmIrBuilderKt.createJvmIrBuilder$default(this.context, containerClass.getSymbol(), 0, 0, 6, null), (IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(this.context.getSymbols().getRepeatableContainer())))));
            it$iv = var27_56 = containerClass;
            $i$a$-also-AddToStdlibKt$getOrSetIfNull$1$iv = false;
            $this$getOrSetIfNull$iv.set(it$iv);
            v0 = var27_56;
        }
        return (IrClass)v0;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JvmDefaultMode.values().length];
            try {
                nArray[JvmDefaultMode.NO_COMPATIBILITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmDefaultMode.ENABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

